/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IModelProviderFactory;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class J2EEModelProviderRegistry
extends RegistryReader {
    static final String EXTENSION_NAME = "J2EEModelProvider";
    static final String ELEMENT_providers = "provider";
    static final String MODEL_PROVIDER = "modelProvider";
    static final String PROVIDER_FACTORY_CLASS = "factoryClass";
    static final String PROVIDER_PRIORITY = "priority";
    static final String PROVIDER_FACET = "facet";
    static final String PROVIDER_FACET_ID = "id";
    static final String PROVIDER_FACET_VERSION = "versions";
    private static J2EEModelProviderRegistry INSTANCE = null;

    public J2EEModelProviderRegistry() {
        super("org.eclipse.jst.j2ee", EXTENSION_NAME);
    }

    public static J2EEModelProviderRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new J2EEModelProviderRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        block11: {
            IProjectFacet pv;
            IConfigurationElement[] facet;
            IModelProviderFactory factory;
            String priority;
            block12: {
                block10: {
                    priority = null;
                    if (element.getName().equals(ELEMENT_providers)) break block10;
                    return false;
                }
                factory = null;
                IConfigurationElement[] mp = element.getChildren(MODEL_PROVIDER);
                try {
                    factory = (IModelProviderFactory)mp[0].createExecutableExtension(PROVIDER_FACTORY_CLASS);
                }
                catch (CoreException e) {
                    this.logError(element, e.getMessage());
                    J2EEPlugin.logError(e);
                }
                if (factory != null) {
                    priority = mp[0].getAttribute(PROVIDER_PRIORITY);
                }
                if (factory == null) break block11;
                facet = element.getChildren(PROVIDER_FACET);
                String facetId = facet[0].getAttribute(PROVIDER_FACET_ID);
                pv = null;
                try {
                    pv = ProjectFacetsManager.getProjectFacet((String)facetId);
                }
                catch (IllegalArgumentException e) {
                    this.logError(element, "Unrecognized facet: " + facetId);
                    J2EEPlugin.logError(e);
                }
                if (pv != null) break block12;
                this.logError(element, "Unrecognized facet: " + facetId);
                return true;
            }
            try {
                String facetVersions = facet[0].getAttribute(PROVIDER_FACET_VERSION);
                StringTokenizer tokens = new StringTokenizer(facetVersions, ",");
                while (tokens.hasMoreElements()) {
                    String facetversion = (String)tokens.nextElement();
                    IProjectFacetVersion fv = pv.getVersion(facetversion);
                    if (fv == null) continue;
                    J2EEModelProviderRegistry.addModelProvider(factory, fv, priority);
                }
            }
            catch (Exception e) {
                this.logError(element, e.getMessage());
                J2EEPlugin.logError(e);
                return true;
            }
        }
        return true;
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        J2EEPlugin.logError(buf.toString());
    }

    private static void addModelProvider(IModelProviderFactory provider, IProjectFacetVersion version, String priority) {
        ModelProviderManager.registerProvider(provider, version, priority);
    }
}

