/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.codetype;

import java.util.function.BiConsumer;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.codetype.CodeTypeGenerator;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.uniqueid.UniqueIds;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class CodeTypeNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_codeTypeName;
    private IClasspathEntry m_sharedSourceFolder;
    private String m_package;
    private String m_superType;
    private String m_codeTypeIdDataType;
    private IFuture<IType> m_createdCodeType;
    private String m_createdCodeTypeFqn;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        progress.init(1, this.toString(), new Object[0]);
        IFuture<IType> createCodeType = this.createCodeType(env, progress.newChild(1));
        this.setCreatedCodeType(createCodeType);
    }

    protected IFuture<IType> createCodeType(IEnvironment env, IProgress progress) {
        Ensure.notBlank((CharSequence)this.getCodeTypeName(), (CharSequence)"No codetype name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSharedSourceFolder(), (CharSequence)"No source folder provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getPackage(), (CharSequence)"No package name provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getSuperType(), (CharSequence)"No supertype provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getCodeTypeIdDataType(), (CharSequence)"No codetype id datatype provided", (Object[])new Object[0]);
        Object codeTypeBuilder = ((CodeTypeGenerator)((Object)((CodeTypeGenerator)((CodeTypeGenerator)((CodeTypeGenerator)new CodeTypeGenerator().withElementName(this.getCodeTypeName())).withPackageName(this.getPackage())).withSuperClass(this.getSuperType())).withCodeTypeIdDataType(this.getCodeTypeIdDataType()))).withClassIdValue(ClassIds.nextIfEnabled(this.getPackage() + "." + this.getCodeTypeName()));
        String idValue = UniqueIds.next(this.getCodeTypeIdDataType());
        if (Strings.isBlank((CharSequence)idValue)) {
            idValue = JavaTypes.defaultValueOf((CharSequence)this.getCodeTypeIdDataType());
        }
        if (Strings.hasText((CharSequence)idValue) && !"null".equals(idValue)) {
            ((CodeTypeGenerator)((Object)codeTypeBuilder)).withIdValueBuilder(ISourceGenerator.raw((CharSequence)idValue));
        }
        this.setCreatedCodeTypeFqn(codeTypeBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)codeTypeBuilder, this.getSharedSourceFolder(), progress);
    }

    public String getCodeTypeName() {
        return this.m_codeTypeName;
    }

    public void setCodeTypeName(String codeTypeName) {
        this.m_codeTypeName = codeTypeName;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    protected void setCreatedCodeType(IFuture<IType> createdCodeType) {
        this.m_createdCodeType = createdCodeType;
    }

    public IFuture<IType> getCreatedCodeType() {
        return this.m_createdCodeType;
    }

    protected void setCreatedCodeTypeFqn(String createdCodeTypeFqn) {
        this.m_createdCodeTypeFqn = createdCodeTypeFqn;
    }

    public String getCreatedCodeTypeFqn() {
        return this.m_createdCodeTypeFqn;
    }

    public String getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(String superType) {
        this.m_superType = superType;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public String getCodeTypeIdDataType() {
        return this.m_codeTypeIdDataType;
    }

    public void setCodeTypeIdDataType(String codeTypeIdDataType) {
        this.m_codeTypeIdDataType = codeTypeIdDataType;
    }

    public String toString() {
        return "Create new Code Type";
    }
}

