/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder;

import java.nio.CharBuffer;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.SourceCollector;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;

public abstract class AbstractSourceBuilder<TYPE extends ISourceBuilder<TYPE>>
implements ISourceBuilder<TYPE> {
    private final IBuilderContext m_context;

    protected AbstractSourceBuilder(IBuilderContext context) {
        this.m_context = Ensure.notNull(context);
    }

    protected TYPE thisInstance() {
        return (TYPE)this;
    }

    @Override
    public IBuilderContext context() {
        return this.m_context;
    }

    @Override
    public TYPE append(String s) {
        return this.append((CharSequence)s);
    }

    @Override
    public TYPE appendLine(CharSequence s) {
        return this.append(s).nl();
    }

    @Override
    public TYPE append(boolean b) {
        return this.append(Boolean.toString(b));
    }

    @Override
    public TYPE append(double d) {
        return this.append(Double.toString(d));
    }

    @Override
    public TYPE append(float f) {
        return this.append(Float.toString(f));
    }

    @Override
    public TYPE append(int i) {
        return this.append(Integer.toString(i));
    }

    @Override
    public TYPE append(long l) {
        return this.append(Long.toString(l));
    }

    @Override
    public TYPE append(char[] c) {
        return this.append(CharBuffer.wrap(c));
    }

    @Override
    public TYPE space() {
        return this.append(' ');
    }

    @Override
    public TYPE nl() {
        return this.append(this.context().lineDelimiter());
    }

    @Override
    public TYPE parenthesisOpen() {
        return this.append('(');
    }

    @Override
    public TYPE parenthesisClose() {
        return this.append(')');
    }

    @Override
    public TYPE equalSign() {
        return this.append(" = ");
    }

    @Override
    public TYPE dot() {
        return this.append('.');
    }

    @Override
    public TYPE colon() {
        return this.append(':');
    }

    @Override
    public TYPE comma() {
        return this.append(',');
    }

    @Override
    public TYPE semicolon() {
        return this.append(';');
    }

    @Override
    public TYPE append(ISourceGenerator<ISourceBuilder<?>> generator) {
        Ensure.notNull(generator).generate(this);
        return this.thisInstance();
    }

    @Override
    public <T extends ISourceGenerator<ISourceBuilder<?>>> Collector<T, ISourceBuilder<?>, ISourceBuilder<?>> collector(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return new SourceCollector(this, prefix, delimiter, suffix);
    }

    @Override
    public TYPE append(Stream<? extends ISourceGenerator<ISourceBuilder<?>>> generators, CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        Ensure.notNull(generators).collect(this.collector(prefix, delimiter, suffix));
        return this.thisInstance();
    }

    @Override
    public TYPE append(Optional<? extends ISourceGenerator<ISourceBuilder<?>>> opt) {
        Ensure.notNull(opt).ifPresent(this::append);
        return this.thisInstance();
    }
}

