/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.params.support.ParameterDeclaration;

interface ResolutionCache {
    public static final ResolutionCache DISABLED = (__, resolver) -> resolver.get();

    public static ResolutionCache enabled() {
        return new Concurrent();
    }

    public @Nullable Object resolve(ParameterDeclaration var1, Supplier<?> var2);

    public static class Concurrent
    implements ResolutionCache {
        private final Map<ParameterDeclaration, Object> cache = new ConcurrentHashMap<ParameterDeclaration, Object>();

        @Override
        public @Nullable Object resolve(ParameterDeclaration declaration, Supplier<?> resolver) {
            return this.cache.computeIfAbsent(declaration, __ -> resolver.get());
        }
    }
}

