/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresTriggerSourceLoader;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.impl.IngresTriggerImpl;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class IngresCatalogTrigger
extends IngresTriggerImpl
implements ICatalogObject {
    private final Object SOURCE_LOCK = new Object();
    private Boolean sourceLoaded = Boolean.FALSE;
    private SoftReference sourceLoaderRef;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.SOURCE_LOCK;
        synchronized (object) {
            if (this.sourceLoaded.booleanValue()) {
                this.sourceLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source getSource() {
        Object object = this.SOURCE_LOCK;
        synchronized (object) {
            if (!this.sourceLoaded.booleanValue()) {
                this.loadSource();
            }
        }
        return super.getSource();
    }

    protected final IngresTriggerSourceLoader getSourceLoader() {
        if (this.sourceLoaderRef == null || this.sourceLoaderRef.get() == null) {
            this.sourceLoaderRef = new SoftReference<IngresTriggerSourceLoader>(this.createSourceLoader());
        }
        return (IngresTriggerSourceLoader)((Object)this.sourceLoaderRef.get());
    }

    protected IngresTriggerSourceLoader createSourceLoader() {
        return new IngresTriggerSourceLoader(this);
    }

    private void loadSource() {
        boolean deliver = this.eDeliver();
        try {
            try {
                this.eSetDeliver(false);
                Source loadedSource = SQLRoutinesFactory.eINSTANCE.createSource();
                this.getSourceLoader().loadSource(this.getSubjectTable().getName(), this.getSchema().getName(), this.getName(), loadedSource);
                this.setSource(loadedSource);
                this.sourceLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }
}

