/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;

public final class XmlWriter {
    public static final String ENCODING = "UTF-8";
    private static final String NL = System.getProperty("line.separator");
    private final Writer base;
    private final String singleIndent;
    private final LinkedList<Context> elementStack;

    public XmlWriter(Writer base) {
        this(base, "  ");
    }

    public XmlWriter(Writer base, String indent) {
        this.base = base;
        this.singleIndent = indent;
        this.elementStack = new LinkedList();
    }

    public void startElement(String name) throws IOException {
        if (this.elementStack.size() > 0) {
            Context parentContext = this.elementStack.getLast();
            if (!parentContext.hasChildren) {
                this.base.write(62);
                this.base.write(NL);
            }
            parentContext.hasChildren = true;
        }
        this.indent();
        this.base.write(60);
        this.base.write(name);
        this.elementStack.addLast(new Context(name));
    }

    public void endElement() throws IOException {
        if (this.elementStack.isEmpty()) {
            throw new RuntimeException();
        }
        Context context = this.elementStack.removeLast();
        if (context.hasChildren) {
            this.indent();
            this.base.write("</");
            this.base.write(context.element);
            this.base.write(">");
            this.base.write(NL);
        } else {
            this.base.write("/>");
            this.base.write(NL);
        }
    }

    public void addAttribute(String name, String value) throws IOException {
        if (this.elementStack.isEmpty()) {
            throw new RuntimeException();
        }
        if (this.elementStack.getLast().hasChildren) {
            throw new RuntimeException();
        }
        this.base.write(32);
        this.base.write(name);
        this.base.write("=\"");
        this.base.write(value);
        this.base.write(34);
    }

    public void flush() throws IOException {
        this.base.flush();
    }

    private void indent() throws IOException {
        int i = 0;
        int n = this.elementStack.size();
        while (i < n) {
            this.base.write(this.singleIndent);
            ++i;
        }
    }

    private static final class Context {
        public String element;
        public boolean hasChildren;

        public Context(String element) {
            this.element = element;
            this.hasChildren = false;
        }
    }
}

