/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleDocumentPartitionerExtension;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class IOConsolePartitioner
implements IConsoleDocumentPartitioner,
IConsoleDocumentPartitionerExtension,
IDocumentPartitionerExtension {
    private static final boolean ASSERT = false;
    private static final Comparator<IRegion> CMP_REGION_BY_OFFSET = Comparator.comparing(IRegion::getOffset);
    private static final String CONTROL_CHARACTERS_PATTERN_STR = "(?:\b+|\u0000+|\u000b+|\f+)";
    private static final String CONTROL_CHARACTERS_WITH_CR_PATTERN_STR = "(?:\b+|\u0000+|\u000b+|\f+|\r+(?!\n))";
    private IDocument document;
    private final ArrayList<IOConsolePartition> partitions = new ArrayList();
    private static final int MAX_BUFFER_BYTES = 16000000;
    private final BlockingQueue<PendingPartition> pendingPartitions = new LinkedBlockingQueue<PendingPartition>(1953);
    private final QueueProcessingJob queueJob = new QueueProcessingJob();
    private final TrimJob trimJob = new TrimJob();
    private DocUpdateType updateType = DocUpdateType.INPUT;
    private ArrayList<IOConsolePartition> inputPartitions;
    private MultiStringMatcher legalLineDelimiterMatcher;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private final IOConsole console;
    private volatile boolean streamsClosed;
    private Pattern controlCharacterPattern = null;
    private boolean carriageReturnAsControlCharacter = true;
    private int outputOffset = 0;

    public IOConsolePartitioner(IOConsole console) {
        this.console = Objects.requireNonNull(console);
        this.queueJob.setRule(console.getSchedulingRule());
        this.trimJob.setRule(console.getSchedulingRule());
    }

    public IDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IDocument doc) {
        if (doc == this.document) {
            return;
        }
        this.disconnect();
        if (doc != null) {
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                this.inputPartitions = new ArrayList();
                this.document = doc;
                this.legalLineDelimiterMatcher = MultiStringMatcher.create((String[])this.document.getLegalLineDelimiters());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.pendingPartitions.clear();
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            this.trimJob.cancel();
            this.queueJob.cancel();
            this.legalLineDelimiterMatcher = null;
            this.document = null;
            this.inputPartitions = null;
            this.partitions.clear();
        }
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int low, int high) {
        this.lowWaterMark = low;
        this.highWaterMark = high;
        ConsolePlugin.getStandardDisplay().asyncExec(this::checkBufferSize);
    }

    public void streamsClosed() {
        if (this.streamsClosed) {
            String msg = "Streams are already closed.";
            IOConsolePartitioner.log(4, msg, new IllegalStateException(msg));
            return;
        }
        this.streamsClosed = true;
        this.checkFinished();
    }

    private void checkFinished() {
        if (this.streamsClosed) {
            boolean morePending;
            boolean bl = morePending = !this.pendingPartitions.isEmpty();
            if (morePending) {
                this.queueJob.schedule();
            } else {
                this.console.partitionerFinished();
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{IOConsolePartition.OUTPUT_PARTITION_TYPE, IOConsolePartition.INPUT_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computeIOPartitioning(offset, length);
    }

    private IOConsolePartition[] computeIOPartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition[] computePartitioning(int offset, int length, boolean includeWritable, boolean includeReadOnly) {
        ArrayList<IOConsolePartition> result = new ArrayList<IOConsolePartition>();
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int index = this.findPartitionCandidate(offset);
            if (index < 0) {
                index = 0;
            }
            int end = offset + length;
            while (index < this.partitions.size()) {
                IOConsolePartition partition = this.partitions.get(index);
                if (partition.getOffset() >= end) break;
                if (includeWritable && !partition.isReadOnly() || includeReadOnly && partition.isReadOnly()) {
                    result.add(partition);
                }
                ++index;
            }
        }
        return result.toArray(new IOConsolePartition[0]);
    }

    public ITypedRegion getPartition(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition : new TypedRegion(offset, 0, IOConsolePartition.INPUT_PARTITION_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition getIOPartition(int offset) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            IOConsolePartition partition;
            int index = this.findPartitionCandidate(offset);
            if (index >= 0 && (partition = this.partitions.get(index)).getOffset() + partition.getLength() > offset) {
                return partition;
            }
            return null;
        }
    }

    private int findPartitionCandidate(int offset) {
        Region target = new Region(offset, 0);
        int index = Collections.binarySearch(this.partitions, target, CMP_REGION_BY_OFFSET);
        if (index >= 0) {
            return index;
        }
        return -index - 2;
    }

    private void checkBufferSize() {
        int length;
        if (this.document != null && this.highWaterMark > 0 && (length = this.document.getLength()) > this.highWaterMark) {
            this.trim(length - this.lowWaterMark, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        this.pendingPartitions.clear();
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            if (this.document != null) {
                this.trimJob.setTrimOffset(this.document.getLength());
                this.trimJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion documentChanged2(DocumentEvent event) {
        if (this.document != event.getDocument()) {
            IOConsolePartitioner.log(2, "IOConsolePartitioner is connected to wrong document.");
            this.updateType = DocUpdateType.INPUT;
            return null;
        }
        {
            block22: {
                catch (Throwable throwable) {
                    this.updateType = DocUpdateType.INPUT;
                    throw throwable;
                }
                {
                    if (this.document.getLength() != 0) break block22;
                    ArrayList<IOConsolePartition> arrayList = this.partitions;
                    synchronized (arrayList) {
                        this.partitions.clear();
                        this.inputPartitions.clear();
                        this.outputOffset = 0;
                    }
                    Region region = new Region(0, 0);
                    this.updateType = DocUpdateType.INPUT;
                    return region;
                }
            }
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                try {
                    switch (this.updateType) {
                        case INPUT: {
                            if (event.getOffset() <= this.outputOffset) {
                                this.outputOffset -= Math.min(event.getLength(), this.outputOffset - event.getOffset());
                                if (event.getText() != null) {
                                    this.outputOffset += event.getText().length();
                                }
                            }
                            IRegion iRegion = this.applyUserInput(event);
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 12] lbl35 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return iRegion;
                        }
                        case OUTPUT: {
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 13] lbl39 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return null;
                        }
                        case TRIM: {
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 14] lbl43 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return null;
                        }
                    }
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                IOConsolePartitioner.log(4, "Invalid enum value " + String.valueOf((Object)this.updateType));
                // MONITOREXIT @DISABLED, blocks:[17, 7, 10] lbl49 : MonitorExitStatement: MONITOREXIT : var2_3
                this.updateType = DocUpdateType.INPUT;
                return null;
            }
        }
    }

    private IRegion applyUserInput(DocumentEvent event) {
        IOConsolePartition partition;
        int eventPartitionIndex;
        int eventTextLength = event.getText() != null ? event.getText().length() : 0;
        int offset = event.getOffset();
        int amountDeleted = event.getLength();
        IOConsoleInputStream inputStream = this.console.getInputStream();
        if (amountDeleted == 0 && eventTextLength == 0) {
            return null;
        }
        int lastPartitionWithValidOffset = eventPartitionIndex = this.findPartitionCandidate(offset);
        if (amountDeleted > 0 && eventPartitionIndex >= 0) {
            int toDelete = amountDeleted;
            int i = eventPartitionIndex;
            while (i < this.partitions.size() && toDelete > 0) {
                partition = this.partitions.get(i);
                int removeLength = Math.min(partition.getLength(), toDelete);
                partition.setLength(partition.getLength() - removeLength);
                toDelete -= removeLength;
                ++i;
            }
            --lastPartitionWithValidOffset;
        }
        if (eventTextLength > 0) {
            int inputPartitionIndex = eventPartitionIndex;
            IOConsolePartition inputPartition = this.getPartitionByIndex(inputPartitionIndex);
            if (inputPartition != null && inputPartition.isReadOnly() && offset == inputPartition.getOffset()) {
                --lastPartitionWithValidOffset;
                inputPartition = this.getPartitionByIndex(--inputPartitionIndex);
            }
            int textOffset = 0;
            while (textOffset < eventTextLength) {
                MultiStringMatcher.Match nextNewline = this.legalLineDelimiterMatcher.indexOf((CharSequence)event.getText(), textOffset);
                int newTextOffset = nextNewline != null ? nextNewline.getOffset() + nextNewline.getText().length() : eventTextLength;
                int inputLength = newTextOffset - textOffset;
                if (inputPartition == null || inputPartition.isReadOnly()) {
                    int inputOffset = offset + textOffset;
                    if (inputPartition != null && inputOffset < inputPartition.getOffset() + inputPartition.getLength()) {
                        this.splitPartition(inputOffset);
                    }
                    inputPartition = new IOConsolePartition(inputOffset, inputStream);
                    this.partitions.add(++inputPartitionIndex, inputPartition);
                    this.inputPartitions.add(inputPartition);
                    ++lastPartitionWithValidOffset;
                }
                inputPartition.setLength(inputPartition.getLength() + inputLength);
                if (nextNewline != null) {
                    this.inputPartitions.sort(CMP_REGION_BY_OFFSET);
                    StringBuilder inputLine = new StringBuilder();
                    for (IOConsolePartition p : this.inputPartitions) {
                        try {
                            String fragment = this.document.get(p.getOffset(), p.getLength());
                            inputLine.append(fragment);
                        }
                        catch (BadLocationException e) {
                            IOConsolePartitioner.log(e);
                        }
                        p.setReadOnly();
                    }
                    this.inputPartitions.clear();
                    if (inputStream != null) {
                        inputStream.appendData(inputLine.toString());
                    }
                }
                Assert.isTrue((newTextOffset > textOffset ? 1 : 0) != 0);
                textOffset = newTextOffset;
            }
        }
        int newOffset = 0;
        if (lastPartitionWithValidOffset >= 0) {
            IOConsolePartition partition2 = this.partitions.get(lastPartitionWithValidOffset);
            newOffset = partition2.getOffset() + partition2.getLength();
        }
        ListIterator<IOConsolePartition> it = this.partitions.listIterator(lastPartitionWithValidOffset + 1);
        while (it.hasNext()) {
            partition = (IOConsolePartition)it.next();
            if (partition.getLength() <= 0) {
                it.remove();
                if (!IOConsolePartitioner.isInputPartition(partition)) continue;
                boolean bl = this.inputPartitions.remove(partition);
                continue;
            }
            partition.setOffset(newOffset);
            newOffset += partition.getLength();
        }
        return new Region(0, this.document.getLength());
    }

    private IOConsolePartition splitPartition(int offset) {
        IOConsolePartition newPartition;
        int partitionIndex = this.findPartitionCandidate(offset);
        IOConsolePartition existingPartition = this.partitions.get(partitionIndex);
        if (IOConsolePartitioner.isInputPartition(existingPartition)) {
            newPartition = new IOConsolePartition(offset, existingPartition.getInputStream());
            if (existingPartition.isReadOnly()) {
                newPartition.setReadOnly();
            }
            if (this.inputPartitions.contains(existingPartition)) {
                this.inputPartitions.add(newPartition);
            }
        } else {
            newPartition = new IOConsolePartition(offset, existingPartition.getOutputStream());
        }
        newPartition.setLength(existingPartition.getOffset() + existingPartition.getLength() - offset);
        existingPartition.setLength(offset - existingPartition.getOffset());
        this.partitions.add(partitionIndex + 1, newPartition);
        return newPartition;
    }

    public void streamAppended(IOConsoleOutputStream stream, String s) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        if (s == null) {
            return;
        }
        PendingPartition partition = new PendingPartition(stream, s);
        while (!this.offer(partition)) {
            this.helpProgress();
        }
        this.queueJob.schedule();
    }

    private void helpProgress() {
        if (Display.getCurrent() != null) {
            this.queueJob.processPendingPartitions();
        } else {
            Thread.yield();
        }
    }

    private boolean offer(PendingPartition p) {
        try {
            return this.pendingPartitions.offer(p, 10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void trim(int truncateOffset, boolean truncateToOffsetLineStart) {
        if (this.document != null) {
            try {
                int length = this.document.getLength();
                int cutOffset = truncateOffset;
                if (truncateToOffsetLineStart) {
                    int cutoffLine = this.document.getLineOfOffset(truncateOffset);
                    cutOffset = this.document.getLineOffset(cutoffLine);
                }
                if (cutOffset >= length) {
                    this.updateType = DocUpdateType.TRIM;
                    this.document.set("");
                } else {
                    IOConsolePartition partition = this.getIOPartition(cutOffset);
                    partition.setLength(partition.getOffset() + partition.getLength() - cutOffset);
                    this.updateType = DocUpdateType.TRIM;
                    this.document.replace(0, cutOffset, "");
                    int index = this.partitions.indexOf(partition);
                    int i = 0;
                    while (i < index) {
                        this.partitions.remove(0);
                        ++i;
                    }
                    int offset = 0;
                    for (IOConsolePartition p : this.partitions) {
                        p.setOffset(offset);
                        offset += p.getLength();
                    }
                    int removedLength = cutOffset;
                    this.outputOffset = Math.max(this.outputOffset - removedLength, 0);
                }
            }
            catch (BadLocationException e) {
                IOConsolePartitioner.log(e);
            }
        }
    }

    @Override
    public boolean isReadOnly(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition.isReadOnly() : true;
    }

    @Override
    public StyleRange[] getStyleRanges(int offset, int length) {
        IOConsolePartition[] computedPartitions = this.computeIOPartitioning(offset, length);
        StyleRange[] styles = new StyleRange[computedPartitions.length];
        int i = 0;
        while (i < computedPartitions.length) {
            int overflow;
            int rangeStart = computedPartitions[i].getOffset();
            int rangeLength = computedPartitions[i].getLength();
            int underflow = offset - rangeStart;
            if (underflow > 0) {
                rangeStart += underflow;
                rangeLength -= underflow;
            }
            if ((overflow = rangeStart + rangeLength - (offset + length)) > 0) {
                rangeLength -= overflow;
            }
            styles[i] = computedPartitions[i].getStyleRange(rangeStart, rangeLength);
            ++i;
        }
        return styles;
    }

    @Override
    public ITypedRegion[] computeReadOnlyPartitions() {
        if (this.document == null) {
            return new IOConsolePartition[0];
        }
        return this.computeReadOnlyPartitions(0, this.document.getLength());
    }

    @Override
    public ITypedRegion[] computeReadOnlyPartitions(int offset, int length) {
        return this.computePartitioning(offset, length, false, true);
    }

    @Override
    public ITypedRegion[] computeWritablePartitions() {
        if (this.document == null) {
            return new IOConsolePartition[0];
        }
        return this.computeWritablePartitions(0, this.document.getLength());
    }

    @Override
    public ITypedRegion[] computeWritablePartitions(int offset, int length) {
        return this.computePartitioning(offset, length, true, false);
    }

    @Override
    public boolean isReadOnly(int offset, int length) {
        ITypedRegion[] readOnlyRegions = this.computeReadOnlyPartitions(offset, length);
        int o = offset;
        int end = offset + length;
        ITypedRegion[] iTypedRegionArray = readOnlyRegions;
        int n = readOnlyRegions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion readOnlyRegion = iTypedRegionArray[n2];
            if (o < readOnlyRegion.getOffset()) {
                return false;
            }
            if ((o += readOnlyRegion.getLength()) >= end) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsReadOnly(int offset, int length) {
        return this.computeReadOnlyPartitions(offset, length).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreviousOffsetByState(int offset, boolean searchWritable) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int partitionIndex = this.findPartitionCandidate(offset);
            while (partitionIndex >= 0) {
                IOConsolePartition partition = this.partitions.get(partitionIndex);
                if (partition.isReadOnly() != searchWritable) {
                    return Math.min(partition.getOffset() + partition.getLength() - 1, offset);
                }
                --partitionIndex;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextOffsetByState(int offset, boolean searchWritable) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int partitionIndex = this.findPartitionCandidate(offset);
            if (partitionIndex >= 0) {
                while (partitionIndex < this.partitions.size()) {
                    IOConsolePartition partition = this.partitions.get(partitionIndex);
                    if (partition.isReadOnly() != searchWritable) {
                        return Math.max(partition.getOffset(), offset);
                    }
                    ++partitionIndex;
                }
            }
        }
        return this.document != null ? this.document.getLength() : 0;
    }

    public boolean isHandleControlCharacters() {
        return this.controlCharacterPattern != null;
    }

    public void setHandleControlCharacters(boolean handleControlCharacters) {
        this.controlCharacterPattern = handleControlCharacters ? Pattern.compile(this.carriageReturnAsControlCharacter ? CONTROL_CHARACTERS_WITH_CR_PATTERN_STR : CONTROL_CHARACTERS_PATTERN_STR) : null;
    }

    public boolean isCarriageReturnAsControlCharacter() {
        return this.carriageReturnAsControlCharacter;
    }

    public void setCarriageReturnAsControlCharacter(boolean carriageReturnAsControlCharacter) {
        this.carriageReturnAsControlCharacter = carriageReturnAsControlCharacter;
        this.setHandleControlCharacters(this.isHandleControlCharacters());
    }

    private IOConsolePartition getPartitionByIndex(int index) {
        return index >= 0 && index < this.partitions.size() ? this.partitions.get(index) : null;
    }

    private static boolean isInputPartition(IOConsolePartition partition) {
        return IOConsolePartition.INPUT_PARTITION_TYPE.equals(partition.getType());
    }

    private static void log(Throwable t) {
        ConsolePlugin.log(t);
    }

    private static void log(int status, String msg) {
        ConsolePlugin.log((IStatus)new Status(status, ConsolePlugin.getUniqueIdentifier(), msg));
    }

    private static void log(int status, String msg, Throwable t) {
        ConsolePlugin.log((IStatus)new Status(status, ConsolePlugin.getUniqueIdentifier(), msg, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartitions() {
        if (this.document == null) {
            return;
        }
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            ArrayList<IOConsolePartition> knownInputPartitions = new ArrayList<IOConsolePartition>(this.inputPartitions);
            int offset = 0;
            for (IOConsolePartition partition : this.partitions) {
                Assert.isTrue((offset == partition.getOffset() ? 1 : 0) != 0);
                Assert.isTrue((partition.getLength() > 0 ? 1 : 0) != 0);
                offset += partition.getLength();
                if (!IOConsolePartitioner.isInputPartition(partition) || partition.isReadOnly()) continue;
                Assert.isTrue((boolean)knownInputPartitions.remove(partition));
            }
            Assert.isTrue((offset == this.document.getLength() ? 1 : 0) != 0);
            Assert.isTrue((boolean)knownInputPartitions.isEmpty());
        }
    }

    private static enum DocUpdateType {
        INPUT,
        OUTPUT,
        TRIM;

    }

    private class PendingPartition {
        private final CharSequence text;
        private final IOConsoleOutputStream stream;

        PendingPartition(IOConsoleOutputStream stream, CharSequence text) {
            this.stream = stream;
            this.text = text;
        }

        public String toString() {
            return this.text.toString();
        }
    }

    private class QueueProcessingJob
    extends UIJob {
        private IOConsolePartition atOutputPartition;
        private int atOutputPartitionIndex;
        private int replaceLength;
        private int nextWriteOffset;

        QueueProcessingJob() {
            super("IOConsole Updater");
            this.atOutputPartition = null;
            this.atOutputPartitionIndex = -1;
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.processPendingPartitions();
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return !IOConsolePartitioner.this.pendingPartitions.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPendingPartitions() {
            ArrayList<PendingPartition> pendingCopy = new ArrayList<PendingPartition>();
            IOConsolePartitioner.this.pendingPartitions.drainTo(pendingCopy);
            int sizeHint = 0;
            if (pendingCopy.isEmpty()) {
                return;
            }
            IOConsoleOutputStream stream = ((PendingPartition)pendingCopy.get((int)0)).stream;
            for (PendingPartition p : pendingCopy) {
                if (p.stream != stream) break;
                sizeHint += p.text.length();
            }
            ArrayList<IOConsolePartition> arrayList = IOConsolePartitioner.this.partitions;
            synchronized (arrayList) {
                if (IOConsolePartitioner.this.document != null) {
                    this.applyStreamOutput(pendingCopy, sizeHint);
                }
                IOConsolePartitioner.this.checkFinished();
                IOConsolePartitioner.this.checkBufferSize();
            }
        }

        private void applyStreamOutput(List<PendingPartition> pendingCopy, int sizeHint) {
            Pattern controlPattern = IOConsolePartitioner.this.controlCharacterPattern;
            this.nextWriteOffset = IOConsolePartitioner.this.outputOffset;
            StringBuilder content = new StringBuilder(sizeHint);
            this.replaceLength = 0;
            this.atOutputPartition = null;
            this.atOutputPartitionIndex = -1;
            for (PendingPartition pending : pendingCopy) {
                CharSequence text = pending.text;
                IOConsoleOutputStream stream = pending.stream;
                Matcher controlCharacterMatcher = controlPattern != null ? controlPattern.matcher(text) : null;
                int textOffset = 0;
                while (textOffset < text.length()) {
                    boolean foundControlCharacter;
                    int partEnd;
                    if (controlCharacterMatcher != null && controlCharacterMatcher.find()) {
                        partEnd = controlCharacterMatcher.start();
                        foundControlCharacter = true;
                    } else {
                        partEnd = text.length();
                        foundControlCharacter = false;
                    }
                    this.partititonContent(stream, text, textOffset, partEnd, content);
                    textOffset = partEnd;
                    if (controlCharacterMatcher == null || !foundControlCharacter) continue;
                    this.applyOutputToDocument(content.toString(), this.nextWriteOffset, this.replaceLength);
                    content.setLength(0);
                    this.replaceLength = 0;
                    this.nextWriteOffset = IOConsolePartitioner.this.outputOffset;
                    String controlCharacterMatch = controlCharacterMatcher.group();
                    char controlCharacter = controlCharacterMatch.charAt(0);
                    int outputLineStartOffset = this.findOutputLineStartOffset(IOConsolePartitioner.this.outputOffset);
                    switch (controlCharacter) {
                        case '\b': {
                            int backStepCount = controlCharacterMatch.length();
                            if (IOConsolePartitioner.this.partitions.isEmpty()) {
                                IOConsolePartitioner.this.outputOffset = 0;
                                break;
                            }
                            if (this.atOutputPartition == null) {
                                this.atOutputPartitionIndex = IOConsolePartitioner.this.partitions.size() - 1;
                                this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                            }
                            while (backStepCount > 0 && IOConsolePartitioner.this.outputOffset > outputLineStartOffset) {
                                if (this.atOutputPartition != null && IOConsolePartitioner.isInputPartition(this.atOutputPartition)) {
                                    do {
                                        IOConsolePartitioner.this.outputOffset = this.atOutputPartition.getOffset() - 1;
                                        --this.atOutputPartitionIndex;
                                        this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                                    } while (this.atOutputPartition != null && IOConsolePartitioner.isInputPartition(this.atOutputPartition));
                                    --backStepCount;
                                }
                                if (this.atOutputPartition == null) {
                                    IOConsolePartitioner.this.outputOffset = 0;
                                    break;
                                }
                                int backSteps = Math.min(IOConsolePartitioner.this.outputOffset - this.atOutputPartition.getOffset(), backStepCount);
                                IOConsolePartitioner.this.outputOffset -= backSteps;
                                backStepCount -= backSteps;
                                --this.atOutputPartitionIndex;
                                this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                            }
                            this.nextWriteOffset = IOConsolePartitioner.this.outputOffset = Math.max(IOConsolePartitioner.this.outputOffset, outputLineStartOffset);
                            break;
                        }
                        case '\r': {
                            IOConsolePartitioner.this.outputOffset = outputLineStartOffset;
                            this.atOutputPartitionIndex = -1;
                            this.atOutputPartition = null;
                            this.nextWriteOffset = IOConsolePartitioner.this.outputOffset;
                            break;
                        }
                        case '\u000b': 
                        case '\f': {
                            int indention = IOConsolePartitioner.this.outputOffset - outputLineStartOffset;
                            int vtabCount = controlCharacterMatch.length();
                            StringBuilder vtab = new StringBuilder(indention + vtabCount);
                            int i = 0;
                            while (i < vtabCount) {
                                vtab.append(System.lineSeparator());
                                ++i;
                            }
                            i = 0;
                            while (i < indention) {
                                vtab.append(' ');
                                ++i;
                            }
                            this.nextWriteOffset = IOConsolePartitioner.this.outputOffset = IOConsolePartitioner.this.document.getLength();
                            this.partititonContent(stream, vtab, 0, vtab.length(), content);
                            break;
                        }
                        case '\u0000': {
                            break;
                        }
                        default: {
                            IOConsolePartitioner.log(4, "No implementation to handle control character 0x" + Integer.toHexString(controlCharacter));
                        }
                    }
                    textOffset = controlCharacterMatcher.end();
                }
            }
            this.applyOutputToDocument(content.toString(), this.nextWriteOffset, this.replaceLength);
        }

        private void partititonContent(IOConsoleOutputStream stream, CharSequence text, int offset, int endOffset, StringBuilder content) {
            int textOffset = offset;
            while (textOffset < endOffset) {
                if (IOConsolePartitioner.this.outputOffset >= IOConsolePartitioner.this.document.getLength()) {
                    if (this.atOutputPartition == null) {
                        this.atOutputPartitionIndex = IOConsolePartitioner.this.partitions.size() - 1;
                        this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                    }
                    if (this.atOutputPartition == null || !this.atOutputPartition.belongsTo(stream)) {
                        this.atOutputPartition = new IOConsolePartition(IOConsolePartitioner.this.outputOffset, stream);
                        IOConsolePartitioner.this.partitions.add(this.atOutputPartition);
                        this.atOutputPartitionIndex = IOConsolePartitioner.this.partitions.size() - 1;
                    }
                    int appendedLength = endOffset - textOffset;
                    content.append(text, textOffset, endOffset);
                    this.atOutputPartition.setLength(this.atOutputPartition.getLength() + appendedLength);
                    IOConsolePartitioner.this.outputOffset += appendedLength;
                    textOffset = endOffset;
                    continue;
                }
                if (this.atOutputPartition == null) {
                    this.atOutputPartitionIndex = IOConsolePartitioner.this.findPartitionCandidate(IOConsolePartitioner.this.outputOffset);
                    this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                    if (this.atOutputPartition == null) {
                        this.atOutputPartition = new IOConsolePartition(IOConsolePartitioner.this.outputOffset, stream);
                        ++this.atOutputPartitionIndex;
                        IOConsolePartitioner.this.partitions.add(this.atOutputPartitionIndex, this.atOutputPartition);
                    }
                }
                if (IOConsolePartitioner.isInputPartition(this.atOutputPartition)) {
                    IOConsolePartitioner.this.outputOffset = this.atOutputPartition.getOffset() + this.atOutputPartition.getLength();
                    ++this.atOutputPartitionIndex;
                    this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                    this.applyOutputToDocument(content.toString(), this.nextWriteOffset, this.replaceLength);
                    content.setLength(0);
                    this.replaceLength = 0;
                    this.nextWriteOffset = IOConsolePartitioner.this.outputOffset;
                    continue;
                }
                int chunkLength = Math.min(endOffset - textOffset, this.atOutputPartition.getLength() - (IOConsolePartitioner.this.outputOffset - this.atOutputPartition.getOffset()));
                Assert.isTrue((chunkLength > 0 ? 1 : 0) != 0);
                if (!this.atOutputPartition.belongsTo(stream)) {
                    IOConsolePartition outputPartition = null;
                    if (this.atOutputPartition.getOffset() == IOConsolePartitioner.this.outputOffset) {
                        outputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex - 1);
                    } else {
                        this.atOutputPartition = IOConsolePartitioner.this.splitPartition(IOConsolePartitioner.this.outputOffset);
                        ++this.atOutputPartitionIndex;
                    }
                    if (outputPartition == null || !outputPartition.belongsTo(stream)) {
                        outputPartition = new IOConsolePartition(IOConsolePartitioner.this.outputOffset, stream);
                        IOConsolePartitioner.this.partitions.add(this.atOutputPartitionIndex, outputPartition);
                        ++this.atOutputPartitionIndex;
                    }
                    outputPartition.setLength(outputPartition.getLength() + chunkLength);
                    this.atOutputPartition.setOffset(this.atOutputPartition.getOffset() + chunkLength);
                    this.atOutputPartition.setLength(this.atOutputPartition.getLength() - chunkLength);
                    if (this.atOutputPartition.getLength() == 0) {
                        IOConsolePartitioner.this.partitions.remove(this.atOutputPartitionIndex);
                        this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
                    }
                }
                content.append(text, textOffset, textOffset + chunkLength);
                this.replaceLength += chunkLength;
                textOffset += chunkLength;
                IOConsolePartitioner.this.outputOffset += chunkLength;
                if (this.atOutputPartition == null || IOConsolePartitioner.this.outputOffset != this.atOutputPartition.getOffset() + this.atOutputPartition.getLength()) continue;
                ++this.atOutputPartitionIndex;
                this.atOutputPartition = IOConsolePartitioner.this.getPartitionByIndex(this.atOutputPartitionIndex);
            }
        }

        private int findOutputLineStartOffset(int outOffset) {
            int outputLineStartOffset = 0;
            try {
                int lineIndex = IOConsolePartitioner.this.document.getLineOfOffset(outOffset);
                while (lineIndex >= 0) {
                    outputLineStartOffset = IOConsolePartitioner.this.document.getLineOffset(lineIndex);
                    IOConsolePartition lineBreakPartition = IOConsolePartitioner.this.getIOPartition(outputLineStartOffset - 1);
                    if (lineBreakPartition != null && IOConsolePartitioner.isInputPartition(lineBreakPartition)) {
                        --lineIndex;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException e) {
                IOConsolePartitioner.log(e);
                outputLineStartOffset = 0;
            }
            return outputLineStartOffset;
        }

        private void applyOutputToDocument(String text, int offset, int length) {
            if (text.length() > 0 || length > 0) {
                try {
                    IOConsolePartitioner.this.updateType = DocUpdateType.OUTPUT;
                    IOConsolePartitioner.this.document.replace(offset, length, text);
                }
                catch (BadLocationException e) {
                    IOConsolePartitioner.log(e);
                }
            }
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;
        private boolean truncateToOffsetLineStart;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setTrimOffset(int offset) {
            this.truncateOffset = offset;
            this.truncateToOffsetLineStart = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList<IOConsolePartition> arrayList = IOConsolePartitioner.this.partitions;
            synchronized (arrayList) {
                IOConsolePartitioner.this.trim(this.truncateOffset, this.truncateToOffsetLineStart);
            }
            return Status.OK_STATUS;
        }
    }
}

