/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.osgi.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ApiBaselineManager
implements IApiBaselineManager,
ISaveParticipant {
    private static final String DEFAULT_BASELINE = "default_api_profile";
    public static final String WORKSPACE_API_BASELINE_ID = "workspace";
    private static final String BASELINE_FILE_EXTENSION = ".profile";
    private volatile ConcurrentHashMap<String, IApiBaseline> baselinecache;
    private volatile Map<String, String> handlecache;
    private volatile Set<String> hasinfos;
    private String defaultbaseline = null;
    private volatile IApiBaseline workspacebaseline;
    private IPath savelocation = null;
    private volatile boolean fNeedsSaving;
    private static ApiBaselineManager fInstance = null;

    private ApiBaselineManager(boolean framework) {
        if (framework) {
            ApiPlugin.getDefault().addSaveParticipant(this);
            this.savelocation = ApiPlugin.getDefault().getStateLocation().append(".api_profiles").addTrailingSeparator();
        }
        this.hasinfos = Collections.emptySet();
    }

    public static synchronized ApiBaselineManager getManager() {
        if (fInstance == null) {
            fInstance = new ApiBaselineManager(ApiPlugin.isRunningInFramework());
        }
        return fInstance;
    }

    @Override
    public IApiBaseline getApiBaseline(String name) {
        if (name == null) {
            return null;
        }
        this.initializeStateCache();
        return this.baselinecache.get(name);
    }

    @Override
    public IApiBaseline[] getApiBaselines() {
        this.initializeStateCache();
        return this.baselinecache.values().toArray(new IApiBaseline[0]);
    }

    @Override
    public void addApiBaseline(IApiBaseline newbaseline) {
        if (newbaseline != null) {
            this.initializeStateCache();
            this.baselinecache.put(newbaseline.getName(), newbaseline);
            if (((ApiBaseline)newbaseline).peekInfos()) {
                this.hasinfos.add(newbaseline.getName());
            }
            this.fNeedsSaving = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeApiBaseline(String name) {
        if (name == null) {
            return false;
        }
        this.initializeStateCache();
        IApiBaseline baseline = this.baselinecache.remove(name);
        if (baseline == null) {
            return false;
        }
        ApiBaselineManager apiBaselineManager = this;
        synchronized (apiBaselineManager) {
            baseline.dispose();
            boolean success = true;
            if (this.savelocation == null) {
                return success;
            }
            File file = this.savelocation.append(name + BASELINE_FILE_EXTENSION).toFile();
            if (file.exists()) {
                try {
                    success &= Files.deleteIfExists(file.toPath());
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
            this.fNeedsSaving = true;
            ApiModelCache.getCache().removeElementInfo(baseline);
            return success;
        }
    }

    public void loadBaselineInfos(ApiBaseline baseline) throws CoreException {
        File file;
        this.initializeStateCache();
        if (this.isBaselineLoaded(baseline)) {
            return;
        }
        String filename = this.handlecache.get(baseline.getName());
        if (filename != null && (file = new File(filename)).exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    baseline.restoreFrom(inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            this.hasinfos.add(baseline.getName());
        }
    }

    public boolean isBaselineLoaded(IApiBaseline baseline) {
        return this.hasinfos.contains(baseline.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStateCache() {
        if (this.baselinecache != null) {
            return;
        }
        if (!ApiPlugin.isRunningInFramework()) {
            ApiBaselineManager apiBaselineManager = this;
            synchronized (apiBaselineManager) {
                if (this.baselinecache == null) {
                    this.handlecache = new ConcurrentHashMap<String, String>(8);
                    this.hasinfos = ConcurrentHashMap.newKeySet(8);
                    this.baselinecache = new ConcurrentHashMap(8);
                }
            }
            return;
        }
        long time = System.currentTimeMillis();
        ApiBaselineManager apiBaselineManager = this;
        synchronized (apiBaselineManager) {
            if (this.baselinecache == null) {
                String def;
                this.handlecache = new ConcurrentHashMap<String, String>(8);
                this.hasinfos = ConcurrentHashMap.newKeySet(8);
                ConcurrentHashMap<String, ApiBaseline> bcache = new ConcurrentHashMap<String, ApiBaseline>(8);
                File[] baselines = this.savelocation.toFile().listFiles(pathname -> pathname.getName().endsWith(BASELINE_FILE_EXTENSION));
                if (baselines != null) {
                    ApiBaseline newbaseline = null;
                    File[] fileArray = baselines;
                    int n = baselines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File baseline = fileArray[n2];
                        if (baseline.exists()) {
                            newbaseline = new ApiBaseline(IPath.fromOSString((String)baseline.getName()).removeFileExtension().toString());
                            this.handlecache.put(newbaseline.getName(), baseline.getAbsolutePath());
                            bcache.put(newbaseline.getName(), newbaseline);
                        }
                        ++n2;
                    }
                }
                this.defaultbaseline = (def = this.getDefaultProfilePref()) != null && bcache.get(def) != null ? def : null;
                this.baselinecache = bcache;
                if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                    System.out.println("Time to initialize state cache: " + (System.currentTimeMillis() - time) + "ms");
                }
            }
        }
    }

    private String getDefaultProfilePref() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString("org.eclipse.pde.api.tools", DEFAULT_BASELINE, null, new IScopeContext[]{InstanceScope.INSTANCE});
    }

    private void persistStateCache() throws CoreException {
        if (this.savelocation == null) {
            return;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        if (this.defaultbaseline != null) {
            node.put(DEFAULT_BASELINE, this.defaultbaseline);
        } else {
            node.remove(DEFAULT_BASELINE);
        }
        if (this.baselinecache != null && !this.hasinfos.isEmpty()) {
            Path dir = this.savelocation.toPath();
            for (Map.Entry<String, IApiBaseline> entry : this.baselinecache.entrySet()) {
                String id = entry.getKey();
                IApiBaseline baseline = entry.getValue();
                if (!this.isBaselineLoaded(baseline)) continue;
                Path file = dir.resolve(id + BASELINE_FILE_EXTENSION);
                this.writeBaselineDescription(baseline, file);
                this.handlecache.put(baseline.getName(), file.toAbsolutePath().toString());
            }
        }
    }

    private void writeBaselineDescription(IApiBaseline baseline, Path file) throws CoreException {
        Document xml = this.getProfileXML(baseline);
        try {
            Util.writeDocumentToFile(xml, file);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Error writing profile descrition", (Throwable)e));
        }
    }

    private Document getProfileXML(IApiBaseline baseline) throws CoreException {
        IApiComponent[] components;
        Document document = Util.newDocument();
        Element root = document.createElement("apiprofile");
        document.appendChild(root);
        root.setAttribute("name", baseline.getName());
        root.setAttribute("version", "2");
        String location = baseline.getLocation();
        if (location != null) {
            root.setAttribute("location", location);
        }
        Element celement = null;
        IApiComponent[] iApiComponentArray = components = baseline.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            HashSet<IApiComponent> allComponentSet = new HashSet<IApiComponent>();
            Set<IApiComponent> multipleComponents = baseline.getAllApiComponents(component.getSymbolicName());
            if (multipleComponents.isEmpty()) {
                allComponentSet.add(component);
            } else {
                allComponentSet.addAll(multipleComponents);
            }
            for (IApiComponent iApiComponent : allComponentSet) {
                if (iApiComponent.isSystemComponent()) continue;
                celement = document.createElement("apicomponent");
                celement.setAttribute("id", iApiComponent.getSymbolicName());
                celement.setAttribute("version", iApiComponent.getVersion());
                celement.setAttribute("location", IPath.fromOSString((String)iApiComponent.getLocation()).toPortableString());
                root.appendChild(celement);
            }
            allComponentSet.clear();
            ++n2;
        }
        return document;
    }

    public IApiComponent[] readBaselineComponents(ApiBaseline baseline, InputStream stream) throws CoreException {
        long start = System.currentTimeMillis();
        DocumentBuilder parser = ApiBaselineManager.getConfiguredParser();
        IApiComponent[] restored = null;
        try {
            Document document = parser.parse(stream);
            Element root = document.getDocumentElement();
            if (root.getNodeName().equals("apiprofile")) {
                String location;
                String baselineLocation = root.getAttribute("location");
                if (baselineLocation != null && !baselineLocation.equals("")) {
                    baseline.setLocation(IPath.fromPortableString((String)baselineLocation).toOSString());
                }
                NodeList children = root.getElementsByTagName("apicomponent");
                ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                int j = 0;
                while (j < children.getLength()) {
                    IApiComponent component;
                    Element componentNode = (Element)children.item(j);
                    if (componentNode.getParentNode().equals(root) && (component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, IPath.fromPortableString((String)(location = componentNode.getAttribute("location"))).toOSString())) != null) {
                        components.add(component);
                    }
                    ++j;
                }
                children = root.getElementsByTagName("pool");
                IApiComponent component = null;
                int j2 = 0;
                while (j2 < children.getLength()) {
                    location = ((Element)children.item(j2)).getAttribute("location");
                    IPath poolPath = IPath.fromPortableString((String)location);
                    NodeList componentNodes = root.getElementsByTagName("apicomponent");
                    int i = 0;
                    while (i < componentNodes.getLength()) {
                        Element compElement = (Element)componentNodes.item(i);
                        String id = compElement.getAttribute("id");
                        String ver = compElement.getAttribute("version");
                        StringBuilder name = new StringBuilder();
                        name.append(id);
                        name.append('_');
                        name.append(ver);
                        File file = poolPath.append(name.toString()).toFile();
                        if (!file.exists()) {
                            name.append(".jar");
                            file = poolPath.append(name.toString()).toFile();
                        }
                        if ((component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, file.getAbsolutePath())) != null) {
                            components.add(component);
                        }
                        ++i;
                    }
                    ++j2;
                }
                restored = components.toArray(new IApiComponent[components.size()]);
                Arrays.sort(restored, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            }
        }
        catch (IOException | SAXException e) {
            throw new CoreException(Status.error((String)"Error restoring API baseline", (Throwable)e));
        }
        if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
            System.out.println("Time to restore a persisted baseline : " + (System.currentTimeMillis() - start) + "ms");
        }
        return restored;
    }

    private static DocumentBuilder getConfiguredParser() throws CoreException {
        try {
            DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            return parser;
        }
        catch (FactoryConfigurationError | ParserConfigurationException e) {
            throw new CoreException(Status.error((String)"Error restoring API baseline", (Throwable)e));
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (!this.fNeedsSaving) {
            return;
        }
        this.persistStateCache();
        this.cleanStateCache();
        this.fNeedsSaving = false;
    }

    private void cleanStateCache() {
        if (this.baselinecache != null) {
            IApiBaseline baseline = null;
            for (Map.Entry<String, IApiBaseline> entry : this.baselinecache.entrySet()) {
                baseline = entry.getValue();
                if (baseline.getName().equals(this.defaultbaseline)) continue;
                baseline.dispose();
                this.hasinfos.remove(baseline.getName());
            }
        }
    }

    public boolean isExistingProfileName(String name) {
        if (this.baselinecache == null || name == null) {
            return false;
        }
        return this.baselinecache.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Job.getJobManager().cancel(ApiAnalysisBuilder.ApiAnalysisJob.class);
            if (this.baselinecache != null) {
                for (IApiBaseline iApiBaseline : this.baselinecache.values()) {
                    iApiBaseline.dispose();
                }
                this.baselinecache.clear();
            }
            ApiBaselineManager apiBaselineManager = this;
            synchronized (apiBaselineManager) {
                if (this.workspacebaseline != null) {
                    this.workspacebaseline.dispose();
                }
            }
            if (this.handlecache != null) {
                this.handlecache.clear();
            }
            if (!this.hasinfos.isEmpty()) {
                this.hasinfos.clear();
            }
            StubApiComponent.disposeAllCaches();
        }
        finally {
            if (ApiPlugin.isRunningInFramework()) {
                ApiPlugin.getDefault().removeSaveParticipant(this);
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    @Override
    public IApiBaseline getDefaultApiBaseline() {
        this.initializeStateCache();
        String defbaseline = this.defaultbaseline;
        if (defbaseline == null) {
            return null;
        }
        return this.baselinecache.get(defbaseline);
    }

    @Override
    public void setDefaultApiBaseline(String name) {
        this.fNeedsSaving = true;
        this.defaultbaseline = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IApiBaseline getWorkspaceBaseline() {
        if (!ApiPlugin.isRunningInFramework()) {
            return null;
        }
        if (this.workspacebaseline == null) {
            try {
                ApiBaselineManager apiBaselineManager = this;
                synchronized (apiBaselineManager) {
                    if (this.workspacebaseline == null) {
                        this.workspacebaseline = this.createWorkspaceBaseline();
                    }
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return this.workspacebaseline;
    }

    public void disposeWorkspaceBaseline() {
        IApiBaseline originalBaseline = this.workspacebaseline;
        if (originalBaseline == null) {
            return;
        }
        final IJobFunction runnable = m -> {
            IApiBaseline oldBaseline = null;
            ApiBaselineManager apiBaselineManager = this;
            synchronized (apiBaselineManager) {
                if (this.workspacebaseline != null && originalBaseline == this.workspacebaseline) {
                    if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                        System.out.println("disposing workspace baseline");
                    }
                    oldBaseline = this.workspacebaseline;
                    StubApiComponent.disposeAllCaches();
                    this.workspacebaseline = null;
                }
            }
            if (oldBaseline != null) {
                oldBaseline.dispose();
            }
            return Status.OK_STATUS;
        };
        if (ApiAnalysisBuilder.isRunningAsJob()) {
            Job.getJobManager().cancel(ApiAnalysisBuilder.ApiAnalysisJob.class);
            Job.getJobManager().cancel(ApiBaselineManager.class);
            Job job = new Job("Disposing Workspace API Baseline"){

                public IStatus run(IProgressMonitor monitor) {
                    return runnable.run(monitor);
                }

                public boolean belongsTo(Object family) {
                    return super.belongsTo(family) || family == ApiBaselineManager.class;
                }
            };
            job.setRule((ISchedulingRule)new ApiBaselineManagerRule());
            job.setSystem(true);
            job.schedule();
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private IApiBaseline createWorkspaceBaseline() throws CoreException {
        long time = System.currentTimeMillis();
        WorkspaceBaseline baseline = new WorkspaceBaseline();
        try {
            List<IPluginModelBase> models = Arrays.asList(PluginRegistry.getWorkspaceModels());
            Set bundles = DependencyManager.getSelfAndDependencies(models);
            IApiComponent[] components = (IApiComponent[])bundles.stream().map(Resource.class::cast).map(PluginRegistry::findModel).filter(Objects::nonNull).map(model -> {
                try {
                    return ApiModelFactory.newApiComponent(baseline, model);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                    return null;
                }
            }).filter(Objects::nonNull).toArray(IApiComponent[]::new);
            baseline.addApiComponents(components);
        }
        finally {
            if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                System.out.println("Time to create a workspace baseline : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        return baseline;
    }

    @Override
    public IApiComponent getWorkspaceComponent(String symbolicName) {
        IApiBaseline baseline = this.getWorkspaceBaseline();
        if (baseline != null) {
            return baseline.getApiComponent(symbolicName);
        }
        return null;
    }

    public static final class ApiBaselineManagerRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ApiBaselineManagerRule || rule instanceof ApiAnalysisBuilder.ApiAnalysisJobRule;
        }
    }
}

