/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import aQute.bnd.osgi.resource.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.bndtools.templating.BytesResource;
import org.bndtools.templating.FolderResource;
import org.bndtools.templating.Resource;
import org.bndtools.templating.ResourceMap;
import org.bndtools.templating.ResourceType;
import org.bndtools.templating.Template;
import org.bndtools.templating.TemplateEngine;
import org.bndtools.templating.util.AttributeDefinitionImpl;
import org.bndtools.templating.util.CompositeOCD;
import org.bndtools.templating.util.ObjectClassDefinitionImpl;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.pde.bnd.ui.templating.BundleLocator;
import org.eclipse.pde.bnd.ui.templating.JaxbMetatype;
import org.eclipse.pde.bnd.ui.templating.JaxbObjectClassDefinition;
import org.eclipse.pde.osgi.xmlns.metatype.v1_4.Tmetadata;
import org.eclipse.pde.osgi.xmlns.metatype.v1_4.Tocd;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class CapabilityBasedTemplate
implements Template {
    private static final String DEFAULT_DIR = "template/";
    private final Capability capability;
    private final BundleLocator locator;
    private final TemplateEngine engine;
    private final String name;
    private final String category;
    private final String description;
    private final Version version;
    private final String dir;
    private final URI iconUri;
    private final String metaTypePath;
    private final String ocdRef;
    private final String helpPath;
    private File _bundleFile = null;

    public CapabilityBasedTemplate(Capability capability, BundleLocator locator, TemplateEngine engine) {
        String v;
        this.capability = capability;
        this.locator = locator;
        this.engine = engine;
        Map attrs = capability.getAttributes();
        Object nameObj = attrs.get("name");
        this.name = nameObj instanceof String ? (String)nameObj : "<<unknown>>";
        this.description = "from " + ResourceUtils.getIdentityCapability((org.osgi.resource.Resource)capability.getResource()).osgi_identity();
        Object categoryObj = attrs.get("category");
        this.category = categoryObj instanceof String ? (String)categoryObj : null;
        Object versionObj = attrs.get("version");
        this.version = versionObj instanceof Version ? (Version)versionObj : (versionObj instanceof String ? Version.parseVersion((String)((String)versionObj)) : ((v = ResourceUtils.getIdentityVersion((org.osgi.resource.Resource)capability.getResource())) != null ? Version.parseVersion((String)v) : Version.emptyVersion));
        Object dirObj = attrs.get("dir");
        if (dirObj instanceof String) {
            Object dirStr = ((String)dirObj).trim();
            if (((String)dirStr).charAt(((String)dirStr).length() - 1) != '/') {
                dirStr = (String)dirStr + "/";
            }
            this.dir = dirStr;
        } else {
            this.dir = DEFAULT_DIR;
        }
        Object iconObj = attrs.get("icon");
        this.iconUri = iconObj instanceof String ? URI.create((String)iconObj) : null;
        Object helpObj = attrs.get("help");
        this.helpPath = helpObj instanceof String ? (String)helpObj : null;
        Object metaTypeObj = attrs.get("metaType");
        this.metaTypePath = metaTypeObj instanceof String ? (String)metaTypeObj : null;
        Object ocdObj = attrs.get("ocd");
        this.ocdRef = ocdObj instanceof String ? ((String)ocdObj).trim() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getShortDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getRanking() {
        Object rankingObj = this.capability.getAttributes().get("ranking");
        return rankingObj instanceof Number ? ((Number)rankingObj).intValue() : 0;
    }

    public ObjectClassDefinition getMetadata() throws Exception {
        return this.getMetadata((IProgressMonitor)new NullProgressMonitor());
    }

    public ObjectClassDefinition getMetadata(IProgressMonitor monitor) throws Exception {
        String resourceId = ResourceUtils.getIdentityCapability((org.osgi.resource.Resource)this.capability.getResource()).osgi_identity();
        CompositeOCD compositeOcd = new CompositeOCD(this.name, this.description, null, new ObjectClassDefinition[0]);
        if (this.metaTypePath != null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JarFile bundleJarFile = new JarFile(this.fetchBundle());){
                JarEntry metaTypeEntry = bundleJarFile.getJarEntry(this.metaTypePath);
                Object object = null;
                Object var9_12 = null;
                try (InputStream entryInput = bundleJarFile.getInputStream(metaTypeEntry);){
                    Tmetadata metaData = JaxbMetatype.readMetaType(entryInput);
                    if (metaData != null) {
                        Map ocdMap = metaData.getOCDOrDesignateOrAny().stream().filter(Tocd.class::isInstance).map(Tocd.class::cast).collect(Collectors.toMap(Tocd::getId, Function.identity()));
                        if (!ocdMap.isEmpty()) {
                            if (ocdMap.size() == 1) {
                                Map.Entry entry = ocdMap.entrySet().iterator().next();
                                if (this.ocdRef == null || this.ocdRef.equals(entry.getKey())) {
                                    compositeOcd.addDelegate((ObjectClassDefinition)new JaxbObjectClassDefinition((Tocd)entry.getValue()));
                                } else {
                                    ILog.get().warn(String.format("MetaType entry '%s' from resource '%s' did not contain an Object Class Definition with id '%s'", this.metaTypePath, resourceId, this.ocdRef), null);
                                }
                            } else if (this.ocdRef != null) {
                                Tocd felixOcd = (Tocd)ocdMap.get(this.ocdRef);
                                if (felixOcd != null) {
                                    compositeOcd.addDelegate((ObjectClassDefinition)new JaxbObjectClassDefinition(felixOcd));
                                } else {
                                    ILog.get().warn(String.format("MetaType entry '%s' from resource '%s' did not contain an Object Class Definition with id '%s'", this.metaTypePath, resourceId, this.ocdRef), null);
                                }
                            } else {
                                ILog.get().warn(String.format("MetaType entry '%s' from resource '%s' contains multiple Object Class Definitions, and no 'ocd' property was specified.", this.metaTypePath, resourceId), null);
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (object == null) {
                        object = throwable2;
                    } else if (object != throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                    throw object;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        ObjectClassDefinitionImpl ocdImpl = new ObjectClassDefinitionImpl(this.name, this.description, null);
        ResourceMap inputs = this.getInputSources();
        Map params = this.engine.getTemplateParameters(inputs, monitor);
        for (Map.Entry entry : params.entrySet()) {
            AttributeDefinitionImpl ad = new AttributeDefinitionImpl((String)entry.getKey(), (String)entry.getKey(), 0, 1);
            if (entry.getValue() != null) {
                ad.setDefaultValue(new String[]{(String)entry.getValue()});
            }
            ocdImpl.addAttribute((AttributeDefinition)ad, true);
        }
        compositeOcd.addDelegate((ObjectClassDefinition)ocdImpl);
        return compositeOcd;
    }

    public ResourceMap generateOutputs(Map<String, List<Object>> parameters) throws Exception {
        return this.generateOutputs(parameters, (IProgressMonitor)new NullProgressMonitor());
    }

    public ResourceMap generateOutputs(Map<String, List<Object>> parameters, IProgressMonitor monitor) throws Exception {
        ResourceMap inputs = this.getInputSources();
        return this.engine.generateOutputs(inputs, parameters, monitor);
    }

    public URI getIcon() {
        return this.iconUri;
    }

    public URI getHelpContent() {
        if (this.helpPath != null) {
            try {
                File f = this.fetchBundle();
                if (f.isFile()) {
                    return new URI("jar:" + String.valueOf(f.toURI().toURL()) + "!/" + this.helpPath);
                }
                if (f.isDirectory()) {
                    return new File(f, this.helpPath).toURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized ResourceMap getInputSources() throws IOException {
        File bundleFile = this.fetchBundle();
        final ResourceMap _inputResources = new ResourceMap();
        if (bundleFile.isDirectory()) {
            final Path basePath = bundleFile.toPath().resolve(this.dir);
            Files.walkFileTree(basePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relativePath = basePath.relativize(dir).toString();
                    if (!relativePath.isBlank()) {
                        _inputResources.put(relativePath, (Resource)new FolderResource());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(final Path file, BasicFileAttributes attrs) throws IOException {
                    String relativePath = basePath.relativize(file).toString();
                    _inputResources.put(relativePath, new Resource(){

                        public ResourceType getType() {
                            return ResourceType.File;
                        }

                        public InputStream getContent() throws IOException {
                            return Files.newInputStream(file, new OpenOption[0]);
                        }

                        public String getTextEncoding() {
                            return Charset.defaultCharset().name();
                        }
                    });
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarInputStream in = new JarInputStream(new FileInputStream(bundleFile));){
                JarEntry jarEntry = in.getNextJarEntry();
                while (jarEntry != null) {
                    String relativePath;
                    String entryPath = jarEntry.getName().trim();
                    if (entryPath.startsWith(this.dir) && !(relativePath = entryPath.substring(this.dir.length())).isEmpty()) {
                        BytesResource resource;
                        if (relativePath.endsWith("/")) {
                            relativePath.substring(0, relativePath.length());
                            resource = new FolderResource();
                        } else {
                            resource = BytesResource.loadFrom((InputStream)in);
                        }
                        _inputResources.put(relativePath, (Resource)resource);
                    }
                    jarEntry = in.getNextJarEntry();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return _inputResources;
    }

    private synchronized File fetchBundle() throws IOException {
        URI location;
        if (this._bundleFile != null && this._bundleFile.exists()) {
            return this._bundleFile;
        }
        Capability idCap = (Capability)this.capability.getResource().getCapabilities("osgi.identity").get(0);
        String id = (String)idCap.getAttributes().get("osgi.identity");
        Capability contentCap = (Capability)this.capability.getResource().getCapabilities("osgi.content").get(0);
        Object locationObj = contentCap.getAttributes().get("url");
        if (locationObj instanceof URI) {
            location = (URI)locationObj;
        } else if (locationObj instanceof String) {
            location = URI.create((String)locationObj);
        } else {
            throw new IOException("Template repository entry is missing url attribute");
        }
        if ("file".equals(location.getScheme())) {
            this._bundleFile = new File(location);
            return this._bundleFile;
        }
        if (this.locator != null) {
            String hashStr = (String)contentCap.getAttributes().get("osgi.content");
            try {
                this._bundleFile = this.locator.locate(id, hashStr, "SHA-256", location);
                if (this._bundleFile != null) {
                    return this._bundleFile;
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to fetch bundle for template: " + this.getName(), e);
            }
        }
        throw new IOException("Unable to fetch bundle for template: " + this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capability == null ? 0 : this.capability.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapabilityBasedTemplate other = (CapabilityBasedTemplate)obj;
        return Objects.equals(this.capability, other.capability);
    }

    public void close() throws IOException {
    }
}

