/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.issue;

import org.eclipse.mylyn.internal.github.core.GitHubAttributeMetadata;
import org.eclipse.mylyn.internal.github.core.issue.Messages;

public enum IssueAttribute {
    KEY(Messages.IssueAttribute_LabelKey, "task.common.key", "shortText", true, true),
    TITLE(Messages.IssueAttribute_LabekSummary, "task.common.summary", "shortRichText", false, true),
    BODY(Messages.IssueAttribute_LabelDescription, "task.common.description", "longRichText", false, true),
    CREATION_DATE(Messages.IssueAttribute_LabelCreated, "task.common.date.created", "dateTime", true, false),
    MODIFICATION_DATE(Messages.IssueAttribute_LabelModified, "task.common.date.modified", "dateTime", true, false),
    CLOSED_DATE(Messages.IssueAttribute_LabelClosed, "task.common.date.completed", "dateTime", true, false),
    STATUS(Messages.IssueAttribute_LabelStatus, "task.common.status", "shortText", false, true),
    REPORTER(Messages.IssueAttribute_LabelReporter, "task.common.user.reporter", "person", true, false),
    COMMENT_NEW(Messages.IssueAttribute_LabelComment, "task.common.comment.new", "longRichText", false, false),
    LABELS(Messages.IssueAttribute_LabelLabels, "github.issue.labels", "multiSelect", false, true),
    ASSIGNEE(Messages.IssueAttribute_LabelAssignee, "task.common.user.assigned", "person", false, true),
    MILESTONE(Messages.IssueAttribute_LabelMilestone, "github.issue.milestone", "singleSelect", false, true),
    ASSIGNEE_GRAVATAR(Messages.IssueAttribute_LabelAssigneeGravatar, "github.issue.assignee.gravatar", "url", null, false, true),
    REPORTER_GRAVATAR(Messages.IssueAttribute_LabelReporterGravatar, "github.issue.reporter.gravatar", "url", null, true, false);

    private final GitHubAttributeMetadata metadata;

    private IssueAttribute(String label, String id, String type, boolean readOnly, boolean initTask) {
        this.metadata = new GitHubAttributeMetadata(id, label, type, readOnly, initTask);
    }

    private IssueAttribute(String label, String id, String type, String kind, boolean readOnly, boolean initTask) {
        this.metadata = new GitHubAttributeMetadata(id, label, kind, type, readOnly, initTask);
    }

    public GitHubAttributeMetadata getMetadata() {
        return this.metadata;
    }
}

