/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesContentHandler;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesWriter;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TaskRepositoriesExternalizer {
    private final SaxRepositoriesWriter writer = new SaxRepositoriesWriter();
    public static final String ELEMENT_TASK_REPOSITORIES = "TaskRepositories";
    public static final String ELEMENT_TASK_REPOSITORY = "TaskRepository";
    public static final String ATTRIBUTE_VERSION = "OutputVersion";
    public static final String ELEMENT_PROPERTY = "Property";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_VALUE = "value";

    public void writeRepositoriesToXML(Collection<TaskRepository> repositories, File file) {
        block15: {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(file));){
                        this.writeRepositories(repositories, outputStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (e.getSuppressed() != null && e.getSuppressed().length > 0) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not close: " + file.getAbsolutePath(), e.getSuppressed()[0]));
                        break block15;
                    }
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not write: " + file.getAbsolutePath(), (Throwable)e));
                }
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not write: " + file.getAbsolutePath(), (Throwable)e));
            }
        }
    }

    public void writeRepositories(Collection<TaskRepository> repositories, ZipOutputStream outputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("repositories.xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        this.writer.setOutputStream(outputStream);
        this.writer.writeRepositoriesToStream(repositories);
        outputStream.flush();
        outputStream.closeEntry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<TaskRepository> readRepositoriesFromXML(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(file));){
                ZipEntry entry = inputStream.getNextEntry();
                while (entry != null && !"repositories.xml".equals(entry.getName())) {
                    entry = inputStream.getNextEntry();
                }
                if (entry == null) {
                    return null;
                }
                SaxRepositoriesContentHandler contentHandler = new SaxRepositoriesContentHandler();
                XMLReader reader = XmlReaderUtil.createXmlReader();
                reader.setContentHandler(contentHandler);
                reader.parse(new InputSource(inputStream));
                return contentHandler.getRepositories();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable e) {
            if (e.getSuppressed() != null && e.getSuppressed().length > 0) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error closing task repositories file", e.getSuppressed()[0]));
                return null;
            }
            file.renameTo(new File(file.getAbsolutePath() + "-save"));
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error reading task repositories", e));
            return null;
        }
    }
}

