/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SelectBreakpointWorkingsetDialog
extends AbstractDebugCheckboxSelectionDialog {
    private static final String SETTINGS_ID = DebugUIPlugin.getUniqueIdentifier() + ".DELETE_ASSOCIATED_CONFIGS_DIALOG";
    private IWorkingSet[] fWorkingSetList = this.getBreakpointWorkingSets();

    protected SelectBreakpointWorkingsetDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void addViewerListeners(StructuredViewer viewer) {
        CheckboxTableViewer checkViewer = this.getCheckBoxTableViewer();
        if (checkViewer != null) {
            checkViewer.addCheckStateListener(event -> {
                this.getCheckBoxTableViewer().setCheckedElements(new Object[]{event.getElement()});
                this.getButton(0).setEnabled(true);
            });
        }
    }

    private IWorkingSet[] getBreakpointWorkingSets() {
        IWorkingSet[] ws = PlatformUI.getWorkbench().getWorkingSetManager().getAllWorkingSets();
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>();
        IWorkingSet[] iWorkingSetArray = ws;
        int n = ws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet w = iWorkingSetArray[n2];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(w.getId())) {
                list.add(w);
            }
            ++n2;
        }
        return list.toArray(new IWorkingSet[list.size()]);
    }

    @Override
    protected Object getViewerInput() {
        return this.fWorkingSetList;
    }

    @Override
    protected String getDialogSettingsId() {
        return SETTINGS_ID;
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_breakpoint_workingset_dialog";
    }

    @Override
    protected String getViewerLabel() {
        return BreakpointGroupMessages.SelectBreakpointWorkingsetDialog_0;
    }
}

