/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.Messages;

public class TargetFeature {
    private final IFeatureModel featureModel;

    public TargetFeature(File featureLocation) throws CoreException {
        this(TargetFeature.loadModel(featureLocation));
    }

    protected TargetFeature(IModel featureModel) throws NullPointerException {
        Objects.requireNonNull(featureModel, "The feature model can't be null");
        this.featureModel = Objects.requireNonNull((IFeatureModel)Adapters.adapt((Object)featureModel, IFeatureModel.class), "The feature model must be an instance of IFeatureModel or adapt to it!");
    }

    public String getId() {
        return this.featureModel.getFeature().getId();
    }

    public String getVersion() {
        return this.featureModel.getFeature().getVersion();
    }

    public String getLocation() {
        return this.featureModel.getInstallLocation();
    }

    public NameVersionDescriptor[] getPlugins() {
        return (NameVersionDescriptor[])Arrays.stream(this.featureModel.getFeature().getPlugins()).map(plugin -> new NameVersionDescriptor(plugin.getId(), plugin.getVersion())).toArray(NameVersionDescriptor[]::new);
    }

    public NameVersionDescriptor[] getDependentFeatures() {
        IFeatureChild[] featureIncludes;
        IFeatureImport[] featureImports;
        ArrayList<NameVersionDescriptor> result = new ArrayList<NameVersionDescriptor>();
        IFeature feature = this.featureModel.getFeature();
        IFeatureImport[] iFeatureImportArray = featureImports = feature.getImports();
        int n = featureImports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.getType() == 1) {
                result.add(new NameVersionDescriptor(featureImport.getId(), null, "feature"));
            }
            ++n2;
        }
        IFeatureChild[] iFeatureChildArray = featureIncludes = feature.getIncludedFeatures();
        int n3 = featureIncludes.length;
        n = 0;
        while (n < n3) {
            IFeatureChild featureInclude = iFeatureChildArray[n];
            result.add(new NameVersionDescriptor(featureInclude.getId(), null, "feature"));
            ++n;
        }
        return result.toArray(new NameVersionDescriptor[result.size()]);
    }

    public String toString() {
        return MessageFormat.format("{0} {1} (Feature)", this.getId(), this.getVersion());
    }

    public final IModel getFeatureModel() {
        return this.featureModel;
    }

    private static IFeatureModel loadModel(File file) throws CoreException {
        File featureXML;
        if (file == null || !file.exists()) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)file)));
        }
        if ("feature.xml".equalsIgnoreCase(file.getName())) {
            featureXML = file;
        } else {
            featureXML = new File(file, "feature.xml");
            if (!featureXML.exists()) {
                throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)featureXML)));
            }
        }
        return ExternalFeatureModelManager.createModel(featureXML);
    }
}

