/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.WorkingSets;
import org.eclipse.m2e.core.ui.internal.util.Util;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionUtil {
    private static final Logger log = LoggerFactory.getLogger(SelectionUtil.class);
    public static final int UNSUPPORTED = 0;
    public static final int PROJECT_WITH_NATURE = 1;
    public static final int PROJECT_WITHOUT_NATURE = 2;
    public static final int POM_FILE = 4;
    public static final int JAR_FILE = 8;
    public static final int WORKING_SET = 16;

    public static int getElementType(Object element) {
        IFile file;
        IProject project = SelectionUtil.getType(element, IProject.class);
        if (project != null) {
            try {
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    return 1;
                }
                return 2;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((file = SelectionUtil.getType(element, IFile.class)) != null && "pom.xml".equals(file.getFullPath().lastSegment())) {
            return 4;
        }
        ArtifactKey artifactKey = SelectionUtil.getType(element, ArtifactKey.class);
        if (artifactKey != null) {
            return 8;
        }
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return 16;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getType(Object element, Class<T> type) {
        if (element == null) {
            return null;
        }
        if (type.isInstance(element)) {
            return type.cast(element);
        }
        Object object = element;
        if (object instanceof IAdaptable) {
            void adaptable;
            IAdaptable iAdaptable = (IAdaptable)object;
            IAdaptable cfr_ignored_0 = (IAdaptable)object;
            Object adapter = adaptable.getAdapter(type);
            if (adapter != null) {
                return (T)adapter;
            }
        }
        return (T)Platform.getAdapterManager().getAdapter(element, type);
    }

    public static IPath getSelectedLocation(IStructuredSelection selection) {
        Object element = selection == null ? null : selection.getFirstElement();
        IPath path = SelectionUtil.getType(element, IPath.class);
        if (path != null) {
            return path;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return resource.getLocation();
        }
        return null;
    }

    public static IWorkingSet getSelectedWorkingSet(IStructuredSelection selection) {
        Object element;
        Object object = element = selection == null ? null : selection.getFirstElement();
        if (element == null) {
            return null;
        }
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return workingSet;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return WorkingSets.getAssignedWorkingSet((IResource)resource.getProject());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ArtifactKey getArtifactKey(Object element) {
        Object object = element;
        if (object instanceof Artifact) {
            void artifact;
            Artifact artifact2 = (Artifact)object;
            Artifact cfr_ignored_0 = (Artifact)object;
            return new ArtifactKey((Artifact)artifact);
        }
        Object object2 = element;
        if (object2 instanceof DependencyNode) {
            void depNode;
            DependencyNode dependencyNode = (DependencyNode)object2;
            DependencyNode cfr_ignored_1 = (DependencyNode)object2;
            org.eclipse.aether.artifact.Artifact artifact = depNode.getDependency().getArtifact();
            return new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), null);
        }
        return SelectionUtil.getType(element, ArtifactKey.class);
    }

    /*
     * WARNING - void declaration
     */
    public static MavenProject getMavenProject(IEditorInput editorInput, IProgressMonitor monitor) throws CoreException {
        IEditorInput iEditorInput = editorInput;
        if (iEditorInput instanceof IFileEditorInput) {
            void fileInput;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
            IFile pomFile = fileInput.getFile();
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IMavenProjectFacade facade = projectManager.create(pomFile, true, monitor);
            if (facade != null) {
                return facade.getMavenProject(monitor);
            }
        } else {
            IEditorInput iEditorInput2 = editorInput;
            if (iEditorInput2 instanceof IStorageEditorInput) {
                void storageInput;
                IStorageEditorInput pomFile = (IStorageEditorInput)iEditorInput2;
                IStorageEditorInput cfr_ignored_1 = (IStorageEditorInput)iEditorInput2;
                IStorage storage = storageInput.getStorage();
                IPath path = storage.getFullPath();
                if (path == null || !new File(path.toOSString()).exists()) {
                    File tempPomFile = null;
                    try {
                        MavenProject mavenProject;
                        block22: {
                            Throwable throwable = null;
                            Object var12_15 = null;
                            InputStream is = storage.getContents();
                            try {
                                tempPomFile = File.createTempFile("maven-pom", ".pom");
                                Files.copy(is, tempPomFile.toPath(), new CopyOption[0]);
                                mavenProject = SelectionUtil.readExternalMavenProject(tempPomFile, monitor);
                                if (is == null) break block22;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    try {
                                        if (is != null) {
                                            is.close();
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException ex) {
                                    log.error("Can't close stream", (Throwable)ex);
                                }
                            }
                            is.close();
                        }
                        return mavenProject;
                    }
                    finally {
                        if (tempPomFile != null) {
                            tempPomFile.delete();
                        }
                    }
                }
                return SelectionUtil.readExternalMavenProject(path.toFile(), monitor);
            }
            if (editorInput.getClass().getName().endsWith("FileStoreEditorInput")) {
                return SelectionUtil.readExternalMavenProject(new File(Util.proxy(editorInput, Util.FileStoreEditorInputStub.class).getURI().getPath()), monitor);
            }
        }
        return null;
    }

    private static MavenProject readExternalMavenProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IMavenExecutionContext context = IMavenExecutionContext.of((File)pomFile);
        MavenExecutionRequest request = context.getExecutionRequest();
        request.setOffline(false);
        request.setUpdateSnapshots(false);
        request.setRecursive(false);
        MavenExecutionResult result = (MavenExecutionResult)context.execute((context1, monitor1) -> {
            IMavenToolbox toolbox = IMavenToolbox.of((IMavenExecutionContext)context1);
            return toolbox.readMavenProject(pomFile, context1.newProjectBuildingRequest());
        }, monitor);
        MavenProject project = result.getProject();
        if (project != null) {
            return project;
        }
        if (result.hasExceptions()) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            List exceptions = result.getExceptions();
            for (Throwable e : exceptions) {
                statuses.add(Status.error((String)e.getMessage(), (Throwable)e));
            }
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.m2e.core", 4, statuses.toArray(new IStatus[statuses.size()]), Messages.SelectionUtil_error_cannot_read, null));
        }
        throw new CoreException(Status.error((String)Messages.SelectionUtil_error_cannot_read));
    }

    /*
     * WARNING - void declaration
     */
    public static IFile getPomFileFromPomEditorOrViewSelection(ISelection selection) {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IFileEditorInput f;
        Object object;
        IFile file = null;
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            Object o;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            Object e = o = structuredSelection.iterator().next();
            if (e instanceof IProject) {
                void project;
                IProject iProject = (IProject)e;
                IProject cfr_ignored_1 = (IProject)e;
                file = project.getFile("pom.xml");
            } else {
                object = o;
                if (object instanceof IFile) {
                    IFile iFile = (IFile)object;
                    IFile cfr_ignored_2 = (IFile)object;
                    file = f;
                }
            }
            if (file != null) {
                return file;
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (object = (input = editor.getEditorInput())) instanceof IFileEditorInput) {
            void fileInput;
            f = (IFileEditorInput)object;
            IFileEditorInput cfr_ignored_3 = (IFileEditorInput)object;
            file = fileInput.getFile();
            if ("pom.xml".equals(file.getName())) {
                return file;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IProject[] getProjects(ISelection selection, boolean includeAll) {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            for (Object o : structuredSelection) {
                void adaptable;
                Object e = o;
                if (e instanceof IProject) {
                    void project;
                    IProject cfr_ignored_1 = (IProject)e;
                    IProject cfr_ignored_2 = (IProject)e;
                    SelectionUtil.safeAdd((IProject)project, projectList);
                    continue;
                }
                Object e2 = o;
                if (e2 instanceof IWorkingSet) {
                    void workingSet;
                    IWorkingSet cfr_ignored_3 = (IWorkingSet)e2;
                    IWorkingSet cfr_ignored_4 = (IWorkingSet)e2;
                    IAdaptable iAdaptable = workingSet.getElements();
                    int n = ((IAdaptable[])iAdaptable).length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource adaptable2 = iAdaptable[n2];
                        IProject project = (IProject)adaptable2.getAdapter(IProject.class);
                        SelectionUtil.safeAdd(project, projectList);
                        ++n2;
                    }
                    continue;
                }
                Object e3 = o;
                if (e3 instanceof IResource) {
                    void resource;
                    IResource cfr_ignored_5 = (IResource)e3;
                    IResource cfr_ignored_6 = (IResource)e3;
                    SelectionUtil.safeAdd(resource.getProject(), projectList);
                    continue;
                }
                Object e4 = o;
                if (!(e4 instanceof IAdaptable)) continue;
                IAdaptable cfr_ignored_7 = (IAdaptable)e4;
                IAdaptable cfr_ignored_8 = (IAdaptable)e4;
                IProject project = (IProject)adaptable.getAdapter(IProject.class);
                SelectionUtil.safeAdd(project, projectList);
            }
        }
        if (projectList.isEmpty() && includeAll) {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private static void safeAdd(IProject project, List<IProject> projectList) {
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && !projectList.contains(project)) {
                projectList.add(project);
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

