/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.filter.ArtifactFilterManager;
import org.eclipse.m2e.core.internal.jobs.MavenJob;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class MavenPomSelectionComponent
extends Composite {
    public static final String PROP_DECORATION_CONTEXT_PROJECT = "org.eclipse.m2e.core.ui.decorationContextProject";
    Text searchText = null;
    TreeViewer searchResultViewer = null;
    String queryType;
    SearchJob searchJob;
    private IStatus status;
    private ISelectionChangedListener selectionListener;
    private static final long SHORT_DELAY = 150L;
    private static final long LONG_DELAY = 500L;
    final HashSet<String> artifactKeys = new HashSet();
    final HashSet<String> managedKeys = new HashSet();
    private IProject project;

    public void dispose() {
        if (this.searchJob != null) {
            this.searchJob.cancel();
        }
        super.dispose();
    }

    public MavenPomSelectionComponent(Composite parent, int style) {
        super(parent, style);
        this.createSearchComposite();
    }

    private void createSearchComposite() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label searchTextlabel = new Label((Composite)this, 0);
        searchTextlabel.setText(Messages.MavenPomSelectionComponent_search_title);
        searchTextlabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.searchText = new Text((Composite)this, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MavenPomSelectionComponent.this.searchResultViewer.getTree().setFocus();
                    MavenPomSelectionComponent.this.selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade();
                }
            }
        });
        this.searchText.addModifyListener(e -> this.scheduleSearch(this.searchText.getText(), true));
        if (!MavenPlugin.getMavenConfiguration().isUpdateIndexesOnStartup()) {
            this.createWarningArea(this);
        }
        Label searchResultsLabel = new Label((Composite)this, 0);
        searchResultsLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        searchResultsLabel.setText(Messages.MavenPomSelectionComponent_lblResults);
        Tree tree = new Tree((Composite)this, 2052);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tree.setData("name", (Object)"searchResultTree");
        tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MavenPomSelectionComponent.this.selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.searchResultViewer = new TreeViewer(tree);
    }

    private void createWarningArea(Composite composite) {
        Composite warningArea = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)warningArea);
        warningArea.setLayout((Layout)new GridLayout(2, false));
        Label warningImg = new Label(warningArea, 0);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)warningImg);
        warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        Text warningLabel = new Text(warningArea, 74);
        warningLabel.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)warningLabel);
        warningLabel.setText(Messages.MavenPomSelectionComponent_UnavailableRemoteRepositoriesIndexes);
    }

    public boolean setFocus() {
        return this.searchText.setFocus();
    }

    void selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade() {
        if (this.searchResultViewer.getTree().getItemCount() > 0 && this.searchResultViewer.getSelection().isEmpty()) {
            Object artifact = this.searchResultViewer.getTree().getTopItem().getData();
            this.searchResultViewer.setSelection((ISelection)new StructuredSelection(artifact), true);
        }
    }

    protected boolean showClassifiers() {
        return true;
    }

    public void init(String queryText, String queryType, IProject project, Set<ArtifactKey> artifacts, Set<ArtifactKey> managed) {
        this.queryType = queryType;
        this.project = project;
        if (queryText != null) {
            this.searchText.setText(queryText);
        }
        if (artifacts != null) {
            for (ArtifactKey a : artifacts) {
                this.artifactKeys.add(a.groupId() + ":" + a.artifactId());
                this.artifactKeys.add(a.groupId() + ":" + a.artifactId() + ":" + a.version());
            }
        }
        if (managed != null) {
            for (ArtifactKey a : managed) {
                this.managedKeys.add(a.groupId() + ":" + a.artifactId());
                this.managedKeys.add(a.groupId() + ":" + a.artifactId() + ":" + a.version());
            }
        }
        this.searchResultViewer.setContentProvider((IContentProvider)new SearchResultContentProvider());
        SearchResultLabelProvider labelProvider = new SearchResultLabelProvider(this.artifactKeys, this.managedKeys);
        DecoratingStyledCellLabelProvider decoratingLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        DecorationContext decorationContext = new DecorationContext();
        if (project != null) {
            decorationContext.putProperty(PROP_DECORATION_CONTEXT_PROJECT, (Object)project);
        }
        decoratingLabelProvider.setDecorationContext((IDecorationContext)decorationContext);
        this.searchResultViewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
        this.searchResultViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                List<IndexedArtifactFile> files = this.getSelectedIndexedArtifactFiles(selection);
                ArtifactFilterManager filterManager = MavenPluginActivator.getDefault().getArifactFilterManager();
                for (IndexedArtifactFile file : files) {
                    ArtifactKey key = (ArtifactKey)file.getAdapter(ArtifactKey.class);
                    IStatus status = filterManager.filter(this.project, key);
                    if (status.isOK()) continue;
                    this.setStatus(4, status.getMessage());
                    return;
                }
                if (files.size() == 1) {
                    IndexedArtifactFile f = files.get(0);
                    int severity = 0;
                    String date = DateFormat.getDateTimeInstance(2, 3).format(f.date);
                    this.setStatus(severity, NLS.bind((String)Messages.MavenPomSelectionComponent_detail1, (Object)f.fname, (Object)(f.size != -1L ? NLS.bind((String)Messages.MavenPomSelectionComponent_details2, (Object)date, (Object)f.size) : date)));
                } else {
                    this.setStatus(0, NLS.bind((String)Messages.MavenPomSelectionComponent_selected, (Object)selection.size()));
                }
            } else {
                this.setStatus(4, Messages.MavenPomSelectionComponent_nosel);
            }
        });
        this.setupClassifiers();
        this.setStatus(4, "");
        this.scheduleSearch(queryText, false);
    }

    protected void setupClassifiers() {
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.searchResultViewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener = listener;
    }

    void setStatus(int severity, String message) {
        this.status = new Status(severity, "org.eclipse.m2e.core", 0, message, null);
        if (this.selectionListener != null) {
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.searchResultViewer, this.searchResultViewer.getSelection()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IndexedArtifact getIndexedArtifact() {
        IStructuredSelection selection = (IStructuredSelection)this.searchResultViewer.getSelection();
        Object element = selection.getFirstElement();
        Object object = element;
        if (object instanceof IndexedArtifact) {
            void indexedArtifact;
            IndexedArtifact indexedArtifact2 = (IndexedArtifact)object;
            IndexedArtifact cfr_ignored_0 = (IndexedArtifact)object;
            return indexedArtifact;
        }
        TreeItem[] treeItems = this.searchResultViewer.getTree().getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return (IndexedArtifact)treeItems[0].getParentItem().getData();
    }

    public IndexedArtifactFile getIndexedArtifactFile() {
        List<IndexedArtifactFile> files = this.getSelectedIndexedArtifactFiles((IStructuredSelection)this.searchResultViewer.getSelection());
        return !files.isEmpty() ? files.get(0) : null;
    }

    /*
     * WARNING - void declaration
     */
    List<IndexedArtifactFile> getSelectedIndexedArtifactFiles(IStructuredSelection selection) {
        ArrayList<IndexedArtifactFile> result = new ArrayList<IndexedArtifactFile>();
        for (Object element : selection.toList()) {
            void indexedArtifactFile;
            Object e = element;
            if (e instanceof IndexedArtifact) {
                void ia;
                IndexedArtifact cfr_ignored_0 = (IndexedArtifact)e;
                IndexedArtifact cfr_ignored_1 = (IndexedArtifact)e;
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifact)ia))) {
                    for (IndexedArtifactFile file : ia.getFiles()) {
                        if (!this.managedKeys.contains(MavenPomSelectionComponent.getKey(file))) continue;
                        result.add(file);
                    }
                    continue;
                }
                boolean added = false;
                for (IndexedArtifactFile file : ia.getFiles()) {
                    if (file.version == null || file.version.endsWith("-SNAPSHOT")) continue;
                    added = true;
                    result.add(file);
                    break;
                }
                if (added) continue;
                result.add((IndexedArtifactFile)ia.getFiles().iterator().next());
                continue;
            }
            Object object = element;
            if (!(object instanceof IndexedArtifactFile)) continue;
            IndexedArtifactFile cfr_ignored_2 = (IndexedArtifactFile)object;
            IndexedArtifactFile cfr_ignored_3 = (IndexedArtifactFile)object;
            result.add((IndexedArtifactFile)indexedArtifactFile);
        }
        return result;
    }

    void scheduleSearch(String query, boolean delay) {
        if (query != null && query.length() > 2) {
            if (this.searchJob == null) {
                this.searchJob = new SearchJob(this.queryType);
            } else if (!this.searchJob.cancel()) {
                this.searchJob = new SearchJob(this.queryType);
            }
            this.searchJob.setQuery(query.toLowerCase());
            this.searchJob.schedule(delay ? 500L : 150L);
        } else if (this.searchJob != null) {
            this.searchJob.cancel();
        }
    }

    public static String getKey(IndexedArtifactFile file) {
        return file.group + ":" + file.artifact + ":" + file.version;
    }

    public static String getKey(IndexedArtifact art) {
        return art.getGroupId() + ":" + art.getArtifactId();
    }

    private class SearchJob
    extends MavenJob {
        private String query;
        private final String field;
        private volatile boolean stop;

        public SearchJob(String field) {
            super(Messages.MavenPomSelectionComponent_searchJob);
            this.stop = false;
            this.field = field;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public boolean shouldRun() {
            this.stop = false;
            return super.shouldRun();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (MavenPomSelectionComponent.this.searchResultViewer == null || MavenPomSelectionComponent.this.searchResultViewer.getControl() == null || MavenPomSelectionComponent.this.searchResultViewer.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            if (this.query != null) {
                String activeQuery = this.query;
                this.setResult(0, NLS.bind((String)Messages.MavenPomSelectionComponent_searching, (Object)activeQuery.toLowerCase()), null);
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.stop = true;
        }

        private void setResult(int severity, String message, Map<String, IndexedArtifact> result) {
            if (this.stop) {
                return;
            }
            Display.getDefault().syncExec(() -> {
                MavenPomSelectionComponent.this.setStatus(severity, message);
                if (result != null && !MavenPomSelectionComponent.this.searchResultViewer.getControl().isDisposed()) {
                    MavenPomSelectionComponent.this.searchResultViewer.setInput((Object)result);
                }
            });
        }
    }

    public static class SearchResultContentProvider
    implements ITreeContentProvider {
        private static Object[] EMPTY = new Object[0];

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getElements(Object inputElement) {
            Object object = inputElement;
            if (object instanceof Map) {
                void map;
                Map map2 = (Map)object;
                Map cfr_ignored_0 = (Map)object;
                return map.values().toArray();
            }
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildren(Object parentElement) {
            Object object = parentElement;
            if (object instanceof IndexedArtifact) {
                void a;
                IndexedArtifact indexedArtifact = (IndexedArtifact)object;
                IndexedArtifact cfr_ignored_0 = (IndexedArtifact)object;
                return a.getFiles().toArray();
            }
            return EMPTY;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IndexedArtifact;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }
    }

    public static class SearchResultLabelProvider
    extends LabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final Set<String> artifactKeys;
        private final Set<String> managedKeys;

        public SearchResultLabelProvider(Set<String> artifactKeys, Set<String> managedKeys) {
            this.artifactKeys = artifactKeys;
            this.managedKeys = managedKeys;
        }

        public String getText(Object element) {
            return super.getText(element);
        }

        protected String getRepoDisplayName(String repo) {
            return repo;
        }

        /*
         * WARNING - void declaration
         */
        public Color getForeground(Object element) {
            Object object = element;
            if (object instanceof IndexedArtifactFile) {
                void f;
                IndexedArtifactFile indexedArtifactFile = (IndexedArtifactFile)object;
                IndexedArtifactFile cfr_ignored_0 = (IndexedArtifactFile)object;
                if (this.artifactKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifactFile)f))) {
                    return Display.getDefault().getSystemColor(16);
                }
            } else {
                Object object2 = element;
                if (object2 instanceof IndexedArtifact) {
                    void i;
                    IndexedArtifact indexedArtifact = (IndexedArtifact)object2;
                    IndexedArtifact cfr_ignored_1 = (IndexedArtifact)object2;
                    if (this.artifactKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifact)i))) {
                        return Display.getDefault().getSystemColor(16);
                    }
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Image getImage(Object element) {
            if (element instanceof IndexedArtifactFile) {
                return MavenImages.IMG_VERSION;
            }
            Object object = element;
            if (object instanceof IndexedArtifact) {
                void i;
                IndexedArtifact indexedArtifact = (IndexedArtifact)object;
                IndexedArtifact cfr_ignored_0 = (IndexedArtifact)object;
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifact)i))) {
                    return MavenImages.getOverlayImage("jar_obj.png", "lock_ovr.png", 2);
                }
                return MavenImages.IMG_JAR;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public StyledString getStyledText(Object element) {
            Object object = element;
            if (object instanceof IndexedArtifact) {
                void a;
                IndexedArtifact indexedArtifact = (IndexedArtifact)object;
                IndexedArtifact cfr_ignored_0 = (IndexedArtifact)object;
                String name = (String)(a.getClassname() == null ? "" : a.getClassname() + "   " + a.getPackageName() + "   ") + a.getGroupId() + "   " + a.getArtifactId();
                StyledString ss = new StyledString();
                ss.append(name);
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifact)a))) {
                    ss.append(Messages.MavenPomSelectionComponent_managed_decoration, StyledString.DECORATIONS_STYLER);
                }
                return ss;
            }
            Object object2 = element;
            if (object2 instanceof IndexedArtifactFile) {
                void f;
                IndexedArtifactFile name = (IndexedArtifactFile)object2;
                IndexedArtifactFile cfr_ignored_1 = (IndexedArtifactFile)object2;
                StyledString ss = new StyledString();
                String name2 = f.version + " [" + (f.type == null ? "jar" : f.type) + (String)(f.classifier != null ? ", " + f.classifier : "") + "]";
                ss.append(name2);
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey((IndexedArtifactFile)f))) {
                    ss.append(Messages.MavenPomSelectionComponent_managed_decoration, StyledString.DECORATIONS_STYLER);
                }
                return ss;
            }
            return new StyledString();
        }
    }
}

