/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.EClassLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.TrimIdDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.TrimContributionImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TrimContributionEditor
extends AbstractComponentEditor<MTrimContribution> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    @Inject
    @Optional
    protected IProject project;
    @Inject
    private IModelResource resource;
    @Inject
    private EModelService modelService;

    @Inject
    public TrimContributionEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.TrimBarEditor_AddToolBar, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ToolBar")){

            public void run() {
                TrimContributionEditor.this.handleAddChild(MenuPackageImpl.Literals.TOOL_BAR);
            }
        });
        this.actions.add(new Action(this.Messages.TrimBarEditor_AddToolControl, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ToolControl")){

            public void run() {
                TrimContributionEditor.this.handleAddChild(MenuPackageImpl.Literals.TOOL_CONTROL);
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.TrimContribution");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.TrimContributionEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        String pid;
        if (element instanceof TrimContributionImpl && E.notEmpty(pid = ((TrimContributionImpl)element).getParentId())) {
            return pid;
        }
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.TrimContributionEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MTrimContribution)object));
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MTrimContribution> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.MenuContributionEditor_ParentId);
        l.setLayoutData((Object)new GridData());
        final Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.trimParentId(this.getEditingDomain()).observeDetail(this.getMaster()));
        Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrimIdDialog dialog = new TrimIdDialog(t.getShell(), TrimContributionEditor.this.resource, (MTrimContribution)TrimContributionEditor.this.getMaster().getValue(), TrimContributionEditor.this.getEditingDomain(), TrimContributionEditor.this.modelService, TrimContributionEditor.this.Messages);
                dialog.open();
            }
        });
        ControlFactory.createTextField(parent, this.Messages.TrimContributionEditor_Position, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.trimPositionInParent(this.getEditingDomain()));
        E4PickList pickList = new E4PickList(parent, 0, null, (AbstractComponentEditor)this, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN){

            @Override
            protected void addPressed() {
                EClass eClass = (EClass)this.getSelection().getFirstElement();
                TrimContributionEditor.this.handleAddChild(eClass);
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.TrimContributionEditor_Controls);
        TableViewer viewer = pickList.getList();
        FontDescriptor italicFontDescriptor = FontDescriptor.createFrom((Font)viewer.getControl().getFont()).setStyle(2);
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ComponentLabelProvider(this.getEditor(), this.Messages, italicFontDescriptor)));
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        viewer.setInput((Object)E4Properties.children().observeDetail(this.getMaster()));
        pickList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        pickList.setLabelProvider((ILabelProvider)new EClassLabelProvider(this.getEditor()));
        pickList.setInput(new EClass[]{MenuPackageImpl.Literals.TOOL_BAR, MenuPackageImpl.Literals.TOOL_CONTROL});
        pickList.setSelection((ISelection)new StructuredSelection((Object)MenuPackageImpl.Literals.TOOL_BAR));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MTrimContribution.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return E4Properties.children().observe((Object)((MTrimContribution)element));
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    protected void handleAddChild(EClass eClass) {
        EObject toolbar = EcoreUtil.create((EClass)eClass);
        this.setElementId(toolbar);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)toolbar);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(toolbar);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

