/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target.shared;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.model.Model;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;
import org.eclipse.m2e.pde.target.shared.WrappedBundle;

public class MavenBundleWrapper {
    private static final Pattern DASH = Pattern.compile("-");

    private MavenBundleWrapper() {
    }

    public static WrappedBundle getWrappedArtifact(Artifact artifact, Function<DependencyNode, Properties> instructionsLookup, final List<RemoteRepository> repositories, final RepositorySystem repoSystem, final RepositorySystemSession repositorySession, SyncContextFactory syncContextFactory) throws Exception {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, null));
        collectRequest.setRepositories(repositories);
        DependencyNode node = repoSystem.collectDependencies(repositorySession, collectRequest).getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setRoot(node);
        dependencyRequest.setFilter(new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                ArtifactRequest request = new ArtifactRequest();
                request.setRepositories(repositories);
                Artifact nodeArtifact = node.getArtifact();
                request.setArtifact(nodeArtifact);
                try {
                    repoSystem.resolveArtifact(repositorySession, request);
                }
                catch (ArtifactResolutionException e) {
                    return false;
                }
                return true;
            }
        });
        repoSystem.resolveDependencies(repositorySession, dependencyRequest);
        Throwable throwable = null;
        Object var10_11 = null;
        try (SyncContext syncContext = syncContextFactory.newInstance(repositorySession, false);){
            final HashSet lockList = new HashSet();
            node.accept(new DependencyVisitor(){

                public boolean visitLeave(DependencyNode n) {
                    return true;
                }

                public boolean visitEnter(DependencyNode n) {
                    lockList.add(n.getArtifact());
                    return true;
                }
            });
            syncContext.acquire(lockList, null);
            HashMap<DependencyNode, WrappedBundle> visited = new HashMap<DependencyNode, WrappedBundle>();
            WrappedBundle wrappedNode = MavenBundleWrapper.getWrappedNode(node, instructionsLookup, visited);
            for (WrappedBundle wrap : visited.values()) {
                wrap.getJar().ifPresent(jar -> jar.close());
            }
            return wrappedNode;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static WrappedBundle getWrappedNode(DependencyNode node, Function<DependencyNode, Properties> instructionsLookup, Map<DependencyNode, WrappedBundle> visited) throws Exception {
        WrappedBundle wrappedNode = visited.get(node);
        if (wrappedNode != null) {
            return wrappedNode;
        }
        Artifact artifact = node.getArtifact();
        File originalFile = artifact.getFile();
        if (originalFile == null) {
            if (node.getDependency().isOptional()) {
                wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, "Optional artifact " + String.valueOf(node.getArtifact()) + " was not found")));
                visited.put(node, wrappedNode);
            } else {
                wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.ERROR, "Artifact " + String.valueOf(node.getArtifact()) + " not found")));
                visited.put(node, wrappedNode);
            }
            return wrappedNode;
        }
        Jar jar = new Jar(originalFile);
        Manifest originalManifest = jar.getManifest();
        if (originalManifest != null && originalManifest.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
            wrappedNode = new WrappedBundle(node, List.of(), null, originalFile.toPath(), jar, List.of());
            visited.put(node, wrappedNode);
            return wrappedNode;
        }
        List children = node.getChildren();
        ArrayList<WrappedBundle> depends = new ArrayList<WrappedBundle>();
        for (DependencyNode child : children) {
            depends.add(MavenBundleWrapper.getWrappedNode(child, instructionsLookup, visited));
        }
        WrappedBundle wrappedNodeAfterVisit = visited.get(node);
        if (wrappedNodeAfterVisit != null) {
            return wrappedNodeAfterVisit;
        }
        Properties instructions = instructionsLookup.apply(node);
        String key = MavenBundleWrapper.getInstructionsKey(instructions, depends);
        Throwable throwable = null;
        Object var14_15 = null;
        try (Jar analyzerJar = jar;){
            File parent = new File(originalFile.getParent(), "bnd-" + key);
            File wrapArtifactFile = new File(parent, originalFile.getName());
            Jar cached = MavenBundleWrapper.getCachedJar(wrapArtifactFile.toPath(), originalFile.toPath());
            if (cached == null) {
                ArrayList<ProcessingMessage> messages = new ArrayList<ProcessingMessage>();
                wrapArtifactFile.getParentFile().mkdirs();
                boolean hasErrors = false;
                Throwable throwable2 = null;
                Object var22_25 = null;
                try (Analyzer analyzer = new Analyzer(analyzerJar);){
                    analyzer.setProperty("mvnGroupId", artifact.getGroupId());
                    analyzer.setProperty("mvnArtifactId", artifact.getArtifactId());
                    analyzer.setProperty("mvnVersion", artifact.getBaseVersion());
                    analyzer.setProperty("mvnClassifier", artifact.getClassifier());
                    String versionString = MavenBundleWrapper.createOSGiVersion(artifact).toString();
                    analyzer.setProperty("generatedOSGiVersion", versionString);
                    for (String property : instructions.stringPropertyNames()) {
                        String trimValue = instructions.getProperty(property).trim();
                        analyzer.setProperty(property, trimValue);
                    }
                    for (WrappedBundle dep : depends) {
                        Jar depJar = dep.getJar().orElse(null);
                        if (depJar == null) {
                            messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, "Dependency " + String.valueOf(dep.getNode().getDependency()) + " was ignored!"));
                            continue;
                        }
                        analyzer.addClasspath(depJar);
                        analyzer.removeClose((AutoCloseable)depJar);
                    }
                    analyzerJar.setManifest(analyzer.calcManifest());
                    analyzerJar.write(wrapArtifactFile);
                    for (String err : analyzer.getErrors()) {
                        if (err.contains("Classes found in the wrong directory")) continue;
                        messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.ERROR, err));
                        hasErrors = true;
                    }
                    for (String warn : analyzer.getWarnings()) {
                        messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, warn));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                if (hasErrors) {
                    Files.deleteIfExists(wrapArtifactFile.toPath());
                    wrappedNode = new WrappedBundle(node, depends, key, null, null, messages);
                    visited.put(node, wrappedNode);
                } else {
                    Files.setLastModifiedTime(wrapArtifactFile.toPath(), Files.getLastModifiedTime(originalFile.toPath(), new LinkOption[0]));
                    wrappedNode = new WrappedBundle(node, depends, key, wrapArtifactFile.toPath(), new Jar(wrapArtifactFile), messages);
                    visited.put(node, wrappedNode);
                }
            } else {
                wrappedNode = new WrappedBundle(node, depends, key, wrapArtifactFile.toPath(), new Jar(wrapArtifactFile), List.of());
                visited.put(node, wrappedNode);
            }
            return wrappedNode;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static Jar getCachedJar(Path cacheFile, Path sourceFile) {
        try {
            if (!MavenBundleWrapper.isOutdated(cacheFile, sourceFile)) {
                return new Jar(cacheFile.toFile());
            }
        }
        catch (IOException e) {
            Platform.getLog(MavenBundleWrapper.class).error("Reading cached data for " + String.valueOf(cacheFile) + " failed, will regenerate the data ...", (Throwable)e);
        }
        return null;
    }

    private static String getInstructionsKey(Properties properties, List<WrappedBundle> depends) {
        Stream instructionsStream = properties == null ? Stream.empty() : properties.stringPropertyNames().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(key -> key.toLowerCase() + ":" + properties.getProperty((String)key));
        Stream<String> dependsStream = depends.stream().map(WrappedBundle::getInstructionsKey).filter(Objects::nonNull).sorted(String.CASE_INSENSITIVE_ORDER).distinct();
        String string = Stream.concat(instructionsStream, dependsStream).collect(Collectors.joining("#"));
        return DigestUtils.md5Hex((String)string);
    }

    public static Version createOSGiVersion(Artifact artifact) {
        String version = artifact.getVersion();
        return MavenBundleWrapper.createOSGiVersion(version);
    }

    public static Version createOSGiVersion(Model model) {
        return MavenBundleWrapper.createOSGiVersion(model.getVersion());
    }

    public static Version createOSGiVersion(String version) {
        if (version == null || version.isEmpty()) {
            return new Version(0, 0, 1);
        }
        try {
            version = DASH.matcher(version).replaceFirst(".");
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            return new Version(0, 0, 1, version);
        }
    }

    public static boolean isOutdated(Path cacheFile, Path sourceFile) throws IOException {
        if (Files.exists(cacheFile, new LinkOption[0])) {
            FileTime sourceTimeStamp = Files.getLastModifiedTime(sourceFile, new LinkOption[0]);
            FileTime cacheTimeStamp = Files.getLastModifiedTime(cacheFile, new LinkOption[0]);
            return sourceTimeStamp.toMillis() > cacheTimeStamp.toMillis();
        }
        return true;
    }
}

