/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.model.Identifiable;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.BrowseCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IDiscoveryItemFactory;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.InstallUpdatesNotificationItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePatternFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewerSorter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.OpenFavoritesNotificationItem;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.RetryErrorActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesFindFavoritesActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesSignInActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesUnsupportedActionItem;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IIdentifiable;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IMarketplaceStorageService;
import org.eclipse.epp.mpc.core.service.QueryHelper;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.TextSearchControl;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketplaceViewer
extends CatalogViewer {
    public static final String QUERY_TAG_KEYWORD = "tag:";
    private ViewerFilter[] filters;
    private ContentType contentType = ContentType.SEARCH;
    public static String CONTENT_TYPE_PROPERTY = "contentType";
    private final SelectionModel selectionModel;
    private QueryData queryData = new QueryData();
    private final Map<ContentType, QueryData> tabQueries = new HashMap<ContentType, QueryData>();
    private ContentType queryContentType;
    private final IMarketplaceWebBrowser browser;
    private String findText;
    private final MarketplaceWizard wizard;
    private final List<IPropertyChangeListener> listeners = new LinkedList<IPropertyChangeListener>();
    private IDiscoveryItemFactory discoveryItemFactory;
    private MarketplaceDiscoveryResources discoveryResources;
    private boolean inUpdate;
    private Composite header;
    private final IMarketplaceStorageService.LoginListener loginListener = new IMarketplaceStorageService.LoginListener(){

        public void loginChanged(String oldUser, String newUser) {
            Control control = MarketplaceViewer.this.getControl();
            if (control != null && !control.isDisposed()) {
                Display display = control.getDisplay();
                Display current = Display.getCurrent();
                if (current == null || current != display) {
                    display.syncExec(() -> this.loginChanged(oldUser, newUser));
                    return;
                }
                MarketplaceViewer.this.refreshFavorites();
            }
        }
    };

    public MarketplaceViewer(Catalog catalog, IShellProvider shellProvider, MarketplaceWizard wizard) {
        super(catalog, shellProvider, (IRunnableContext)wizard.getContainer(), (CatalogConfiguration)wizard.getConfiguration());
        this.browser = wizard;
        this.selectionModel = wizard.getSelectionModel();
        this.wizard = wizard;
        this.setAutomaticFind(false);
    }

    protected void doCreateHeaderControls(Composite parent) {
        new StyleHelper().on((Widget)parent).setClass("MarketplaceSearchHeader");
        this.header = parent;
        this.header.setBackgroundMode(1);
        MarketplaceViewer.fixFindControlsLayout(parent);
        int originalChildCount = parent.getChildren().length;
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            if (!(filter instanceof MarketplaceFilter)) continue;
            MarketplaceFilter marketplaceFilter = (MarketplaceFilter)filter;
            marketplaceFilter.createControl(parent);
            marketplaceFilter.addPropertyChangeListener(event -> {
                if ("selected".equals(event.getProperty())) {
                    this.doQuery();
                }
            });
        }
        Control[] children = parent.getChildren();
        int x = originalChildCount;
        while (x < children.length) {
            Control child = children[x];
            GridDataFactory.swtDefaults().hint(135, -1).applyTo(child);
            ++x;
        }
        Button goButton = new Button(parent, 8);
        goButton.setText(Messages.MarketplaceViewer_go);
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceViewer.this.doQuery();
            }
        });
    }

    protected static void fixFindControlsLayout(Composite header) {
        TextSearchControl search = null;
        Control[] controlArray = header.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof TextSearchControl) {
                search = (TextSearchControl)control;
                break;
            }
            ++n2;
        }
        if (search == null) {
            return;
        }
        Text text = search.getTextControl();
        Control[] children = search.getChildren();
        int textIndex = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == text) {
                textIndex = i;
                break;
            }
            ++i;
        }
        header.layout(true);
        Control next = textIndex == -1 || textIndex == children.length - 1 ? null : children[textIndex + 1];
        int heightHint = search.getClientArea().height;
        int minHeight = -1;
        if (next instanceof Label) {
            Rectangle iconBounds = next.getBounds();
            Rectangle textBounds = text.getBounds();
            minHeight = Math.max(iconBounds.height, textBounds.height);
            minHeight = Math.min(heightHint, minHeight);
        }
        GridData gridData = new GridData(4, 4, true, false);
        if (minHeight > 0) {
            gridData.minimumHeight = minHeight;
        }
        gridData.heightHint = heightHint;
        text.setLayoutData((Object)gridData);
    }

    protected CatalogViewer.CatalogContentProvider doCreateContentProvider() {
        return new MarketplaceCatalogContentProvider();
    }

    protected MarketplaceDiscoveryResources getResources() {
        return this.discoveryResources;
    }

    protected void catalogUpdated(boolean wasCancelled, boolean wasError) {
        MarketplaceCatalog catalog = this.getCatalog();
        List<MarketplaceNodeCatalogItem> availableUpdates = catalog.getAvailableUpdates();
        String availableUpdatesKey = null;
        if (availableUpdates != null && !availableUpdates.isEmpty()) {
            availableUpdatesKey = this.calculateAvailableUpdatesKey(availableUpdates);
        }
        List discoveryStrategies = catalog.getDiscoveryStrategies();
        for (AbstractDiscoveryStrategy discoveryStrategy : discoveryStrategies) {
            if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
            MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
            marketplaceDiscoveryStrategy.addLoginListener(this.loginListener);
            for (CatalogCategory catalogCategory : catalog.getCategories()) {
                if (!(catalogCategory instanceof MarketplaceCategory)) continue;
                MarketplaceCategory marketplaceCategory = (MarketplaceCategory)catalogCategory;
                if (availableUpdatesKey != null && marketplaceCategory.getContents() != MarketplaceCategory.Contents.INSTALLED && this.getWizard().shouldShowUpdateBanner(availableUpdatesKey)) {
                    marketplaceDiscoveryStrategy.addUpdateItem(marketplaceCategory, availableUpdates);
                    continue;
                }
                if (marketplaceCategory.getContents() != MarketplaceCategory.Contents.FEATURED || !this.getWizard().shouldShowOpenFavoritesBanner()) continue;
                marketplaceDiscoveryStrategy.addOpenFavoritesItem(marketplaceCategory);
            }
        }
        this.runUpdate(() -> {
            MarketplaceViewer.super.catalogUpdated(wasCancelled, wasError);
            for (CatalogFilter filter : this.getConfiguration().getFilters()) {
                if (!(filter instanceof MarketplaceFilter)) continue;
                ((MarketplaceFilter)filter).catalogUpdated(wasCancelled);
            }
            this.setFilters(this.queryData);
        });
    }

    private String calculateAvailableUpdatesKey(List<MarketplaceNodeCatalogItem> availableUpdates) {
        ArrayList<CallSite> keys = new ArrayList<CallSite>(availableUpdates.size());
        StringBuilder bldr = new StringBuilder();
        for (MarketplaceNodeCatalogItem marketplaceNodeCatalogItem : availableUpdates) {
            String key = String.valueOf(marketplaceNodeCatalogItem.getMarketplaceUrl()) + "::" + marketplaceNodeCatalogItem.getId();
            keys.add((CallSite)((Object)key));
        }
        Collections.sort(keys);
        for (String string : keys) {
            if (bldr.length() > 0) {
                bldr.append(",");
            }
            bldr.append(string);
        }
        return bldr.toString();
    }

    protected void doCheckCatalog() {
    }

    protected void filterTextChanged() {
        this.doFind(this.getFilterText());
    }

    protected void doFind(String text) {
        this.findText = text;
        this.doQuery();
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        CategoryItem item;
        boolean isCategory = false;
        if (element instanceof CatalogItem) {
            CatalogItem catalogItem = (CatalogItem)element;
            if (catalogItem instanceof UserActionCatalogItem) {
                item = this.createUserActionViewerItem((UserActionCatalogItem)catalogItem, parent);
            } else if (catalogItem.getData() instanceof CatalogDescriptor) {
                item = this.createBrowseItem(catalogItem, parent);
            } else {
                DiscoveryItem<CatalogItem> discoveryItem = this.createDiscoveryItem(parent, catalogItem);
                discoveryItem.setSelected(this.getCheckedItems().contains(catalogItem));
                item = discoveryItem;
            }
        } else if (element instanceof MarketplaceCategory) {
            MarketplaceCategory category = (MarketplaceCategory)((Object)element);
            if (category.getContents() == MarketplaceCategory.Contents.FEATURED) {
                category.setName(Messages.MarketplaceViewer_featured);
            } else if (category.getContents() == MarketplaceCategory.Contents.POPULAR) {
                category.setName(Messages.MarketplaceViewer_PopularBannerTitle);
            } else {
                throw new IllegalStateException();
            }
            CategoryItem categoryItem = (CategoryItem)super.doCreateViewerItem(parent, element);
            MarketplaceViewer.setSeparatorVisible(categoryItem, false);
            MarketplaceViewer.fixLayout(categoryItem);
            item = categoryItem;
            isCategory = true;
        } else {
            item = super.doCreateViewerItem(parent, element);
        }
        new StyleHelper().on(item).addClass(isCategory ? "MarketplaceCategory" : "MarketplaceItem");
        return item;
    }

    private BrowseCatalogItem createBrowseItem(CatalogItem catalogItem, Composite parent) {
        CatalogDescriptor catalogDescriptor = (CatalogDescriptor)catalogItem.getData();
        return new BrowseCatalogItem(parent, this.getResources(), this.shellProvider, this.browser, (MarketplaceCategory)catalogItem.getCategory(), catalogDescriptor, this);
    }

    private ControlListItem<?> createUserActionViewerItem(UserActionCatalogItem catalogItem, Composite parent) {
        UserActionCatalogItem.UserAction userAction = catalogItem.getUserAction();
        switch (userAction) {
            case BROWSE: {
                return this.createBrowseItem(catalogItem, parent);
            }
            case CREATE_FAVORITES: {
                return new UserFavoritesFindFavoritesActionItem(parent, this.getResources(), catalogItem, this.getWizard().getCatalogPage());
            }
            case FAVORITES_UNSUPPORTED: {
                MarketplacePage catalogPage = this.getWizard().getCatalogPage();
                ActionLink actionLink = catalogPage.getActionLink("import");
                if (actionLink != null) {
                    catalogPage.removeActionLink(actionLink);
                }
                return new UserFavoritesUnsupportedActionItem(parent, this.getResources(), catalogItem, this.getWizard().getCatalogPage());
            }
            case LOGIN: {
                return new UserFavoritesSignInActionItem(parent, this.getResources(), catalogItem, this);
            }
            case RETRY_ERROR: {
                return new RetryErrorActionItem(parent, this.getResources(), catalogItem, this);
            }
            case OPEN_FAVORITES: {
                this.getWizard().didShowOpenFavoritesBanner();
                return new OpenFavoritesNotificationItem(parent, this.getResources(), catalogItem, this.getWizard().getCatalogPage());
            }
            case UPDATE: {
                return new InstallUpdatesNotificationItem(parent, this.getResources(), catalogItem, this.getWizard().getCatalogPage());
            }
        }
        return null;
    }

    private DiscoveryItem<CatalogItem> createDiscoveryItem(Composite parent, CatalogItem catalogItem) {
        if (this.discoveryItemFactory != null) {
            return this.discoveryItemFactory.createDiscoveryItem(catalogItem, this, parent, this.getResources(), this.shellProvider, this.browser);
        }
        return new DiscoveryItem<CatalogItem>(parent, 0, this.getResources(), this.browser, catalogItem, this);
    }

    public void show(Set<? extends INode> nodes) {
        ContentType newContentType = ContentType.SEARCH;
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.fireContentTypeChange(oldContentType, newContentType);
        this.doQuery(new QueryData(), nodes);
    }

    public void search(String query) {
        this.search(this.getQueryMarket(), this.getQueryCategory(), query);
    }

    public void search(IMarket market, ICategory category, String query) {
        QueryData queryData = new QueryData(market, category, query);
        this.setFilters(queryData);
        this.queryData = queryData;
        this.updateContent(this.contentType, () -> {
            IStatus iStatus = this.doQuery(queryData, null);
        });
    }

    private void setFilters(QueryData queryData) {
        this.setFindText(queryData.queryText == null ? "" : queryData.queryText);
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            List<Tag> choices = tagFilter.getChoices();
            Tag tag2 = tag = choices.isEmpty() ? null : choices.get(0);
            if (tag == null) continue;
            IMarket data = null;
            if (tag.getTagClassifier() == IMarket.class) {
                data = queryData.queryMarket;
            } else {
                if (tag.getTagClassifier() != ICategory.class) continue;
                data = queryData.queryCategory;
            }
            tag = null;
            if (data != null) {
                for (Tag choice : choices) {
                    Object choiceData = choice.getData();
                    if (choiceData != data && !MarketplaceViewer.matches((IIdentifiable)data, choiceData)) continue;
                    tag = choice;
                    break;
                }
            }
            tagFilter.setSelected(tag == null ? Collections.emptySet() : Collections.singleton(tag));
            tagFilter.updateUi();
        }
        this.initQueryFromFilters();
    }

    private static boolean matches(IIdentifiable data, Object tagData) {
        return tagData instanceof IIdentifiable && Identifiable.matches((IIdentifiable)((IIdentifiable)tagData), (IIdentifiable)data);
    }

    public void reload() {
        this.updateContent(this.contentType, () -> {
            IStatus iStatus = this.doQuery();
        });
    }

    private IStatus doQuery() {
        this.initQueryFromFilters();
        return this.doQuery(this.queryData, null);
    }

    private void initQueryFromFilters() {
        this.queryData = new QueryData();
        this.findText = this.getFilterText();
        AbstractTagFilter marketFilter = null;
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            Tag tag2 = tag = tagFilter.getSelected().isEmpty() ? null : tagFilter.getSelected().iterator().next();
            if (tag == null) continue;
            if (tag.getTagClassifier() == IMarket.class) {
                marketFilter = tagFilter;
                this.queryData.queryMarket = (IMarket)tag.getData();
                continue;
            }
            if (tag.getTagClassifier() != ICategory.class) continue;
            this.queryData.queryCategory = (ICategory)tag.getData();
        }
        if (marketFilter != null) {
            this.setFilterEnabled(marketFilter, this.contentType != ContentType.FEATURED_MARKET);
        }
        this.queryData.queryText = this.findText;
    }

    private void setFilterEnabled(MarketplaceFilter filter, boolean enabled) {
        if (this.header != null) {
            Control[] children;
            Control[] controlArray = children = this.header.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getData() == filter) {
                    control.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    public void doQueryForTag(String tag) {
        this.updateContent(ContentType.SEARCH, () -> {
            this.queryData = new QueryData();
            this.queryData.queryText = QUERY_TAG_KEYWORD + tag;
            this.setFilters(this.queryData);
            this.doQuery();
        });
    }

    private void setFindText(String tag) {
        try {
            Field filterTextField = FilteredViewer.class.getDeclaredField("filterText");
            filterTextField.setAccessible(true);
            TextSearchControl textSearchControl = (TextSearchControl)filterTextField.get((Object)this);
            textSearchControl.getTextControl().setText(tag);
        }
        catch (Exception e) {
            MarketplaceClientUi.log(2, Messages.MarketplaceViewer_Could_not_change_find_text, e);
        }
    }

    private void fireContentTypeChange(ContentType oldValue, ContentType newValue) {
        MarketplaceViewer source = this;
        String property = CONTENT_TYPE_PROPERTY;
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)source, property, (Object)oldValue, (Object)newValue));
    }

    protected IStatus refreshFavorites() {
        IStatus status;
        try {
            IStatus[] result = new IStatus[1];
            this.context.run(true, true, monitor -> {
                IStatus iStatus = this.getCatalog().refreshUserFavorites(monitor);
            });
            status = result[0];
        }
        catch (InvocationTargetException e) {
            status = this.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
        }
        catch (InterruptedException e) {
            status = Status.CANCEL_STATUS;
        }
        if (status != null && !status.isOK() && status.getSeverity() != 8) {
            MarketplaceClientUi.handle(status, 7);
        }
        return status;
    }

    private IStatus doQuery(QueryData queryData, Set<? extends INode> nodes) {
        try {
            ContentType queryType;
            this.queryContentType = queryType = this.contentType;
            IStatus[] result = new IStatus[1];
            this.context.run(true, true, monitor -> {
                switch (queryType) {
                    case POPULAR: {
                        iStatusArray[0] = this.getCatalog().popular(monitor);
                        break;
                    }
                    case RECENT: {
                        iStatusArray[0] = this.getCatalog().recent(monitor);
                        break;
                    }
                    case RELATED: {
                        iStatusArray[0] = this.getCatalog().related(monitor);
                        break;
                    }
                    case INSTALLED: {
                        iStatusArray[0] = this.getCatalog().installed(monitor);
                        break;
                    }
                    case FAVORITES: {
                        iStatusArray[0] = this.getCatalog().userFavorites(false, monitor);
                        break;
                    }
                    case SELECTION: {
                        Set selectedNodesById = this.getSelectionModel().getItemToSelectedOperation().keySet().stream().map(node -> QueryHelper.nodeById((String)node.getId())).collect(Collectors.toSet());
                        iStatusArray[0] = this.getCatalog().performNodeQuery(monitor, selectedNodesById);
                        break;
                    }
                    default: {
                        if (nodes != null && !nodes.isEmpty()) {
                            iStatusArray[0] = this.getCatalog().performNodeQuery(monitor, nodes);
                            break;
                        }
                        if (queryData.queryText != null && queryData.queryText.length() > 0) {
                            String tag = this.getTagQuery(queryData.queryText);
                            if (tag != null) {
                                iStatusArray[0] = this.getCatalog().tagged(tag, monitor);
                                break;
                            }
                            iStatusArray[0] = this.getCatalog().performQuery(queryData.queryMarket, queryData.queryCategory, queryData.queryText, monitor);
                            break;
                        }
                        iStatusArray[0] = this.getCatalog().featured(monitor, queryData.queryMarket, queryData.queryCategory);
                    }
                }
                if (!monitor.isCanceled() && result[0] != null && result[0].getSeverity() != 8) {
                    this.getCatalog().checkForUpdates(monitor);
                }
                this.getControl().getDisplay().syncExec(() -> this.updateViewer(queryData.queryText));
            });
            if (result[0] != null && !result[0].isOK() && result[0].getSeverity() != 8) {
                MarketplaceClientUi.handle(result[0], (result[0].getSeverity() > 2 ? 6 : 0) | 1);
                return result[0];
            }
            this.verifyUpdateSiteAvailability();
            return Status.OK_STATUS;
        }
        catch (InvocationTargetException e) {
            IStatus status = this.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
            MarketplaceClientUi.handle(status, 7);
            return status;
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
    }

    private String getTagQuery(String queryText) {
        String tag;
        if (queryText != null && queryText.toLowerCase().startsWith(QUERY_TAG_KEYWORD) && (tag = queryText.substring(QUERY_TAG_KEYWORD.length()).trim()).length() > 0) {
            return tag;
        }
        return null;
    }

    private void updateViewer(String queryText) {
        this.runUpdate(() -> {
            if (this.contentType == ContentType.INSTALLED) {
                this.getViewer().setComparator((ViewerComparator)new MarketplaceViewerSorter());
            } else {
                this.getViewer().setComparator(null);
            }
            MarketplaceViewer.super.doFind(queryText);
            this.getViewer().getControl().getParent().layout(true, true);
        });
    }

    private void runUpdate(Runnable r) {
        if (this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (this.inUpdate) {
            r.run();
            return;
        }
        this.inUpdate = true;
        this.getViewer().getControl().setRedraw(false);
        try {
            r.run();
        }
        finally {
            this.inUpdate = false;
            this.getViewer().getControl().setRedraw(true);
        }
    }

    public void showSelected() {
        this.contentType = ContentType.SELECTION;
        this.queryData = new QueryData();
        this.findText = null;
        this.runUpdate(() -> {
            this.setHeaderVisible(true);
            this.doQuery(new QueryData(null, null, this.findText), null);
        });
        this.contentType = ContentType.SEARCH;
    }

    public void updateContents() {
        this.doSetContentType(this.contentType);
    }

    public MarketplaceCatalogConfiguration getConfiguration() {
        return (MarketplaceCatalogConfiguration)super.getConfiguration();
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    protected PatternFilter doCreateFilter() {
        return new MarketplacePatternFilter();
    }

    public void setContentType(ContentType contentType) {
        if (this.contentType != contentType) {
            this.doSetContentType(contentType);
        }
    }

    private void doSetContentType(ContentType contentType) {
        ContentType oldContentType = this.contentType;
        this.updateContent(contentType, () -> {
            IStatus status = this.doQuery();
            if (status.getSeverity() == 8 || status.getSeverity() >= 4) {
                this.setContentType(oldContentType);
            }
        });
    }

    private void updateContent(ContentType contentType, Runnable queryCall) {
        ContentType queryType;
        ContentType oldContentType = this.contentType;
        this.contentType = contentType;
        boolean hadQuery = this.showQueryHeader(oldContentType);
        boolean hasQuery = this.showQueryHeader(contentType);
        ContentType oldQueryType = oldContentType;
        if (oldQueryType == ContentType.SELECTION) {
            oldQueryType = ContentType.SEARCH;
        }
        if ((queryType = contentType) == ContentType.SELECTION) {
            queryType = ContentType.SEARCH;
        }
        if (oldQueryType != queryType || hasQuery != hadQuery) {
            if (hadQuery) {
                this.initQueryFromFilters();
                this.tabQueries.put(oldQueryType, this.queryData);
            }
            if (hasQuery) {
                QueryData newQueryData = this.tabQueries.get((Object)queryType);
                if (newQueryData == null) {
                    String marketName;
                    boolean hasFeaturedMarketTab;
                    CatalogDescriptor catalogDescriptor;
                    ICatalogBranding catalogBranding;
                    newQueryData = new QueryData();
                    if (queryType == ContentType.FEATURED_MARKET && (catalogBranding = (catalogDescriptor = this.getWizard().getConfiguration().getCatalogDescriptor()).getCatalogBranding()) != null && (hasFeaturedMarketTab = catalogBranding.hasFeaturedMarketTab()) && (marketName = catalogBranding.getFeaturedMarketTabName()) != null) {
                        block0: for (CatalogFilter filter : this.getConfiguration().getFilters()) {
                            AbstractTagFilter tagFilter;
                            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
                            for (Tag tag : tagFilter.getChoices()) {
                                if (tag.getTagClassifier() != IMarket.class) continue block0;
                                IMarket market = (IMarket)tag.getData();
                                if (!marketName.equals(market.getName())) continue;
                                newQueryData.queryMarket = market;
                                continue block0;
                            }
                        }
                        if (newQueryData.queryMarket == null) {
                            this.setContentType(oldContentType);
                            return;
                        }
                    }
                    this.tabQueries.put(queryType, newQueryData);
                }
                this.setFilters(newQueryData);
            }
        }
        this.runUpdate(() -> {
            this.fireContentTypeChange(oldContentType, contentType);
            this.setHeaderVisible(hasQuery);
            queryCall.run();
        });
    }

    private boolean showQueryHeader(ContentType contentType) {
        return contentType == ContentType.SEARCH || contentType == ContentType.SELECTION || contentType == ContentType.FEATURED_MARKET;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public void setHeaderVisible(boolean visible) {
        if (visible != this.isHeaderVisible()) {
            this.runUpdate(() -> {
                if (!visible) {
                    this.filters = this.getViewer().getFilters();
                    this.getViewer().resetFilters();
                } else if (this.filters != null) {
                    this.getViewer().setFilters(this.filters);
                    this.filters = null;
                }
                MarketplaceViewer.super.setHeaderVisible(visible);
            });
        }
    }

    protected boolean doFilter(CatalogItem item) {
        return true;
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        ServiceReference serviceReference = null;
        BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
        try {
            serviceReference = bundleContext.getServiceReference(IDiscoveryItemFactory.class);
            if (serviceReference != null) {
                this.discoveryItemFactory = (IDiscoveryItemFactory)bundleContext.getService(serviceReference);
            }
        }
        catch (Exception ex) {
            MarketplaceClientUi.error(ex);
        }
        Object viewer = super.doCreateViewer(container);
        if (!MarketplaceClientUi.useNativeBorders()) {
            StructuredViewer superViewer = viewer;
            viewer = new ControlListViewer(container, 0){

                protected ControlListItem<?> doCreateItem(Composite parent, Object element) {
                    return MarketplaceViewer.this.doCreateViewerItem(parent, element);
                }
            };
            viewer.setContentProvider(superViewer.getContentProvider());
            viewer.setFilters(superViewer.getFilters());
            superViewer.getControl().dispose();
        }
        viewer.setComparator(null);
        this.discoveryResources = new MarketplaceDiscoveryResources(container.getDisplay());
        viewer.getControl().addDisposeListener(e -> this.discoveryResources.dispose());
        super.getResources().dispose();
        if (serviceReference != null) {
            ServiceReference ref = serviceReference;
            viewer.getControl().addDisposeListener(e -> {
                boolean bl = bundleContext.ungetService(ref);
            });
        }
        new StyleHelper().on((Widget)viewer.getControl()).setClass("MarketplaceViewer");
        return viewer;
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void modifySelection(CatalogItem connector, Operation operation) {
        this.modifySelection(connector, operation == null ? null : operation.getOperation());
    }

    protected void modifySelection(CatalogItem connector, org.eclipse.epp.mpc.ui.Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        org.eclipse.epp.mpc.ui.Operation selectedOperation = this.selectionModel.getSelectedOperation(connector);
        this.selectionModel.select(connector, operation);
        super.modifySelection(connector, operation != org.eclipse.epp.mpc.ui.Operation.NONE);
        if (selectedOperation != operation) {
            this.getViewer().refresh((Object)connector);
        }
    }

    protected void postDiscovery() {
    }

    public void updateCatalog() {
        if (this.getWizard().wantInitializeInitialSelection()) {
            try {
                this.getWizard().initializeInitialSelection();
                if (this.getControl().isDisposed()) {
                    return;
                }
                MarketplaceWizard.WizardState initialState = this.getWizard().getInitialState();
                if (initialState != null) {
                    this.getWizard().getCatalogPage().initialize(initialState);
                }
                this.catalogUpdated(false, false);
            }
            catch (CoreException e) {
                boolean wasCancelled;
                boolean bl = wasCancelled = e.getStatus().getSeverity() == 8;
                if (!wasCancelled) {
                    MarketplaceClientUi.handle(e.getStatus(), 7);
                }
                this.catalogUpdated(wasCancelled, !wasCancelled);
            }
        } else {
            super.updateCatalog();
            if (this.getControl().isDisposed()) {
                return;
            }
        }
        this.refresh();
    }

    protected IStatus computeStatus(InvocationTargetException e, String message) {
        return MarketplaceClientCore.computeStatus((Throwable)e, (String)message);
    }

    protected MarketplaceWizard getWizard() {
        return this.wizard;
    }

    public List<CatalogItem> getCheckedItems() {
        ArrayList<CatalogItem> items = new ArrayList<CatalogItem>();
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : this.getSelectionModel().getItemToSelectedOperation().entrySet()) {
            if (entry.getValue() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            items.add(entry.getKey());
        }
        return items;
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.getCheckedItems());
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getQueryText() {
        return this.queryData.queryText;
    }

    public ICategory getQueryCategory() {
        return this.queryData.queryCategory;
    }

    public IMarket getQueryMarket() {
        return this.queryData.queryMarket;
    }

    ContentType getQueryContentType() {
        return this.queryContentType;
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return MarketplaceClientUi.computeInstalledFeatures(monitor);
    }

    public void refresh() {
        this.runUpdate(() -> MarketplaceViewer.super.refresh());
    }

    protected static void fixLayout(CategoryItem<?> categoryItem) {
        CatalogCategory category = (CatalogCategory)categoryItem.getData();
        boolean hasDescription = category.getDescription() != null;
        int valignTitle = hasDescription ? 1 : 0x1000000;
        int totalRows = hasDescription ? 2 : 1;
        Control[] children = categoryItem.getChildren();
        Composite categoryHeaderContainer = (Composite)children[0];
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, hasDescription ? 5 : 10).equalWidth(false).applyTo(categoryHeaderContainer);
        Control[] headerChildren = categoryHeaderContainer.getChildren();
        Control iconLabel = headerChildren[0];
        Control nameLabel = headerChildren[1];
        Control tooltip = headerChildren[2];
        GridDataFactory.swtDefaults().align(0x1000000, valignTitle).span(1, totalRows).applyTo(iconLabel);
        GridDataFactory.fillDefaults().grab(true, false).align(1, valignTitle).applyTo(nameLabel);
        if (tooltip instanceof Label) {
            GridDataFactory.fillDefaults().align(0x1000008, valignTitle).applyTo(tooltip);
        }
    }

    protected static void setSeparatorVisible(CategoryItem<?> categoryItem, boolean visible) {
        Control childControl = categoryItem.getChildren()[0];
        if (childControl instanceof GradientCanvas) {
            GradientCanvas canvas = (GradientCanvas)childControl;
            canvas.setSeparatorVisible(visible);
        }
    }

    public void reveal(Object item) {
        this.viewer.reveal(item);
    }

    public static enum ContentType {
        SEARCH,
        FEATURED_MARKET,
        RECENT,
        POPULAR,
        INSTALLED,
        SELECTION,
        RELATED,
        FAVORITES;

    }

    public static class MarketplaceCatalogContentProvider
    extends CatalogViewer.CatalogContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];

        public Catalog getCatalog() {
            return super.getCatalog();
        }

        public Object[] getElements(Object inputElement) {
            if (this.getCatalog() != null) {
                ArrayList<CatalogCategory> items = new ArrayList<CatalogCategory>(this.getCatalog().getItems());
                for (CatalogCategory category : this.getCatalog().getCategories()) {
                    if (!(category instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
                    int pos = 0;
                    int i = 0;
                    while (i < items.size()) {
                        if (!(items.get(i) instanceof UserActionCatalogItem)) {
                            pos = i;
                            break;
                        }
                        ++i;
                    }
                    if (marketplaceCategory.getContents() != MarketplaceCategory.Contents.FEATURED && (pos <= 0 || pos >= items.size() - 1)) continue;
                    items.add(pos, category);
                }
                return items.toArray();
            }
            return NO_ELEMENTS;
        }
    }

    private static class QueryData {
        public String queryText;
        public IMarket queryMarket;
        public ICategory queryCategory;

        public QueryData() {
        }

        public QueryData(IMarket queryMarket, ICategory queryCategory, String queryText) {
            this.queryMarket = queryMarket;
            this.queryCategory = queryCategory;
            this.queryText = queryText;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.queryCategory == null ? 0 : this.queryCategory.hashCode());
            result = 31 * result + (this.queryMarket == null ? 0 : this.queryMarket.hashCode());
            result = 31 * result + (this.queryText == null ? 0 : this.queryText.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryData other = (QueryData)obj;
            if (this.queryCategory == null ? other.queryCategory != null : !this.queryCategory.equals(other.queryCategory)) {
                return false;
            }
            if (this.queryMarket == null ? other.queryMarket != null : !this.queryMarket.equals(other.queryMarket)) {
                return false;
            }
            return !(this.queryText == null ? other.queryText != null : !this.queryText.equals(other.queryText));
        }
    }
}

