/*
 * Copyright 2015-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j;

/**
 * {@link RuntimeException} used to indicate that the execution of a test
 * was incomplete &mdash; for example, that the execution was entirely
 * skipped or aborted mid-stream. See subclasses for concrete use cases.
 *
 * <p>An {@code IncompleteExecutionException} is <strong>not</strong> used
 * to indicate that a test execution failed.
 *
 * @author Johannes Link
 * @author Sam Brannen
 * @since 1.0
 */
public class IncompleteExecutionException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	public IncompleteExecutionException() {
	}

	public IncompleteExecutionException(String message) {
		super(message);
	}

	public IncompleteExecutionException(String message, Throwable cause) {
		super(message, cause);
	}

}
