/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.properties;

import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.MultiLineTextFieldEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.ConfigureMessages;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IAConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.AbstractConfigurePropertyOptionsPage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.AutotoolsConfigurePrefStore;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.ToolListElement;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class AutotoolsToolPropertyOptionPage
extends AbstractConfigurePropertyOptionsPage {
    private ToolListElement element;
    private String toolName = "";
    private IAConfiguration cfg;
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private StringFieldEditor commandStringField;
    private static final String ALL_OPTIONS = "Tool.allopts";
    private static final String COMMAND = "Tool.command";

    public AutotoolsToolPropertyOptionPage(ToolListElement element, IAConfiguration cfg) {
        super(element.getName());
        this.element = element;
        this.toolName = element.getName();
        this.cfg = cfg;
    }

    public String getName() {
        return super.getName();
    }

    public ToolListElement getElement() {
        return this.element;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        FontMetrics fm = AbstractCPropertyTab.getFontMetrics((Control)parent);
        this.commandStringField = new StringFieldEditor(this.toolName, ConfigureMessages.getString((String)COMMAND), parent);
        this.commandStringField.setEmptyStringAllowed(false);
        GridData gd = (GridData)this.commandStringField.getTextControl(parent).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)3);
        this.addField((FieldEditor)this.commandStringField);
        Composite par = this.getFieldEditorParent();
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(AutotoolsConfigurePrefStore.ALL_OPTIONS_ID, ConfigureMessages.getString((String)ALL_OPTIONS), par);
        this.allOptionFieldEditor.getTextControl(par).setEditable(false);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.allOptionFieldEditor);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title) {
        return new LabelFieldEditor(parent, title);
    }

    public void updateFields() {
        this.allOptionFieldEditor.load();
    }

    public void setValues() {
        this.commandStringField.load();
        this.updateFields();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.commandStringField) {
            this.cfg.setOption(this.toolName, this.commandStringField.getStringValue());
            this.updateFields();
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private String fTitle;
        private Label fTitleLabel;

        public LabelFieldEditor(Composite parent, String title) {
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fTitleLabel.getLayoutData()).horizontalSpan = 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fTitleLabel = new Label(parent, 64);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = 2;
            this.fTitleLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

