/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.trace;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.lttng.core.TraceHelper;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventContent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventType;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngLocation;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.exceptions.LttngException;
import org.eclipse.linuxtools.internal.lttng.core.trace.EventTypeKey;
import org.eclipse.linuxtools.internal.lttng.core.trace.LTTngTraceVersion;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.utility.LiveTraceManager;
import org.eclipse.linuxtools.internal.lttng.jni.common.JniTime;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.jni.JniMarker;
import org.eclipse.linuxtools.lttng.jni.JniTrace;
import org.eclipse.linuxtools.lttng.jni.JniTracefile;
import org.eclipse.linuxtools.lttng.jni.factory.JniTraceFactory;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class LTTngTrace
extends TmfTrace<LttngEvent>
implements ITmfEventParser<LttngEvent> {
    public static final boolean PRINT_DEBUG = false;
    public static final boolean UNIQUE_EVENT = true;
    private static final boolean SHOW_LTT_DEBUG_DEFAULT = false;
    private static final boolean IS_PARSING_NEEDED_DEFAULT = false;
    private static final int CHECKPOINT_PAGE_SIZE = 50000;
    private static final long LTTNG_STREAMING_INTERVAL = 2000L;
    private JniTrace currentJniTrace;
    LttngTimestamp eventTimestamp;
    String eventSource;
    LttngEventContent eventContent;
    String eventReference;
    LttngEvent currentLttngEvent;
    LttngLocation previousLocation;
    LttngEventType eventType;
    HashMap<Integer, LttngEventType> traceTypes;
    Vector<Integer> traceTypeNames;
    private String traceLibPath;
    public int nbEventsRead = 0;

    public LTTngTrace() {
    }

    public boolean validate(IProject project, String path) {
        if (this.fileExists(path)) {
            String traceLibPath = TraceHelper.getTraceLibDirFromProject(project);
            try {
                LTTngTraceVersion version = new LTTngTraceVersion(path, traceLibPath);
                return version.isValidLttngTrace();
            }
            catch (LttngException lttngException) {}
        }
        return false;
    }

    public synchronized void initTrace(IResource resource, String path, Class<LttngEvent> eventType) throws TmfTraceException {
        super.initialize(resource, path, eventType);
        this.initialize(resource, path, eventType);
    }

    protected synchronized void initialize(IResource resource, String path, Class<LttngEvent> eventType) throws TmfTraceException {
        try {
            this.currentJniTrace = JniTraceFactory.getJniTrace((String)path, (String)this.traceLibPath, (boolean)false);
        }
        catch (Exception e) {
            throw new TmfTraceException(e.getMessage());
        }
        this.traceTypes = new HashMap();
        this.traceTypeNames = new Vector();
        this.initialiseEventTypes(this.currentJniTrace);
        this.eventTimestamp = new LttngTimestamp();
        this.eventSource = "";
        this.eventType = new LttngEventType();
        this.eventContent = new LttngEventContent(this.currentLttngEvent);
        this.eventReference = this.getName();
        this.currentLttngEvent = new LttngEvent(this, this.eventTimestamp, this.eventSource, this.eventType, this.eventContent, this.eventReference, null);
        this.previousLocation = new LttngLocation();
        this.eventContent.setEvent(this.currentLttngEvent);
        this.setParser(this);
        this.setCacheSize(50000);
        this.initializeStreamingMonitor();
    }

    private void initializeStreamingMonitor() {
        JniTrace jniTrace = this.getCurrentJniTrace();
        if (jniTrace == null || !jniTrace.isLiveTraceSupported() || !LiveTraceManager.isLiveTrace(jniTrace.getTracepath())) {
            TmfContext context = this.seekEvent(0L);
            LttngEvent event = this.getNext((ITmfContext)context);
            LttngTimestamp startTime = new LttngTimestamp(event.getTimestamp());
            LttngTimestamp endTime = new LttngTimestamp(this.currentJniTrace.getEndTime().getTime());
            this.setTimeRange(new TmfTimeRange((ITmfTimestamp)startTime, (ITmfTimestamp)endTime));
            TmfTraceUpdatedSignal signal = new TmfTraceUpdatedSignal((Object)this, (ITmfTrace)this, this.getTimeRange());
            this.broadcast((TmfSignal)signal);
            return;
        }
        TmfContext context = this.seekEvent(0L);
        LttngEvent event = this.getNext((ITmfContext)context);
        this.setEndTime(TmfTimestamp.BIG_BANG);
        final long startTime = event != null ? event.getTimestamp().getValue() : TmfTimestamp.BIG_BANG.getValue();
        this.setStreamingInterval(2000L);
        Thread thread = new Thread("Streaming Monitor for trace " + this.getName()){
            LttngTimestamp safeTimestamp;
            TmfTimeRange timeRange;
            {
                super($anonymous0);
                this.safeTimestamp = null;
                this.timeRange = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!LTTngTrace.this.fExecutor.isShutdown()) {
                    TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
                    if (experiment != null) {
                        TmfEventRequest<TmfEvent> request = new TmfEventRequest<TmfEvent>(TmfEvent.class, TmfTimeRange.ETERNITY, 0, ITmfDataRequest.ExecutionType.FOREGROUND){

                            public void handleCompleted() {
                                this.updateJniTrace();
                            }
                        };
                        TmfExperiment tmfExperiment = experiment;
                        synchronized (tmfExperiment) {
                            experiment.sendRequest((ITmfDataRequest)request);
                        }
                        try {
                            request.waitForCompletion();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        this.updateJniTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            private void updateJniTrace() {
                JniTrace jniTrace = LTTngTrace.this.getCurrentJniTrace();
                LTTngTrace.this.currentJniTrace.updateTrace();
                long endTime = jniTrace.getEndTime().getTime();
                LttngTimestamp startTimestamp = new LttngTimestamp(startTime);
                LttngTimestamp endTimestamp = new LttngTimestamp(endTime);
                this.timeRange = this.safeTimestamp != null && this.safeTimestamp.compareTo(LTTngTrace.this.getTimeRange().getEndTime(), false) > 0 ? new TmfTimeRange((ITmfTimestamp)startTimestamp, (ITmfTimestamp)this.safeTimestamp) : null;
                this.safeTimestamp = endTimestamp;
                if (this.timeRange != null) {
                    LTTngTrace.this.setTimeRange(this.timeRange);
                }
            }
        };
        thread.start();
    }

    public LTTngTrace(IResource resource, String path) throws Exception {
        this(resource, path, null, true, false);
    }

    public LTTngTrace(IResource resource, String path, boolean waitForCompletion) throws Exception {
        this(resource, path, null, waitForCompletion, true);
    }

    public LTTngTrace(IResource resource, String path, String traceLibPath, boolean waitForCompletion, boolean bypassIndexing) throws Exception {
        super(resource, LttngEvent.class, path, 50000);
        this.initialize(resource, path, LttngEvent.class);
        this.traceLibPath = traceLibPath;
    }

    public LTTngTrace(LTTngTrace other) throws Exception {
        this(other.getResource(), other.getPath(), other.getTraceLibPath(), false, true);
        this.setTimeRange(new TmfTimeRange((ITmfTimestamp)new LttngTimestamp(other.getStartTime()), (ITmfTimestamp)new LttngTimestamp(other.getEndTime())));
    }

    public String getTraceLibPath() {
        return this.traceLibPath;
    }

    private void initialiseEventTypes(JniTrace trace) {
        LttngEventType tmpType = null;
        String[] markerFieldsLabels = null;
        String newTracefileKey2 = null;
        Integer newMarkerKey2 = null;
        JniTracefile newTracefile = null;
        JniMarker newMarker = null;
        for (String newTracefileKey2 : trace.getTracefilesMap().keySet()) {
            newTracefile = (JniTracefile)trace.getTracefilesMap().get(newTracefileKey2);
            for (Integer newMarkerKey2 : newTracefile.getTracefileMarkersMap().keySet()) {
                newMarker = (JniMarker)newTracefile.getTracefileMarkersMap().get(newMarkerKey2);
                markerFieldsLabels = newMarker.getMarkerFieldsHashMap().keySet().toArray(new String[newMarker.getMarkerFieldsHashMap().size()]);
                tmpType = new LttngEventType(newTracefile.getTracefileName(), newTracefile.getCpuNumber(), newMarker.getName(), newMarkerKey2, markerFieldsLabels);
                this.addEventTypeToMap(tmpType);
            }
        }
    }

    private void addEventTypeToMap(LttngEventType newEventType) {
        int newTypeKey = EventTypeKey.getEventTypeHash(newEventType);
        this.traceTypes.put(newTypeKey, newEventType);
        this.traceTypeNames.add(newTypeKey);
    }

    public synchronized ITmfLocation<?> getCurrentLocation() {
        return this.previousLocation;
    }

    public synchronized ITmfContext seekEvent(ITmfLocation<?> location) {
        if (location == null) {
            LttngLocation curLocation = new LttngLocation();
            TmfContext context = this.seekEvent((ITmfTimestamp)curLocation.getOperationTime());
            context.setRank(0L);
            return context;
        }
        LttngLocation curLocation = (LttngLocation)location;
        TmfContext context = this.seekEvent((ITmfTimestamp)curLocation.getOperationTime());
        if (curLocation.isLastOperationReadNext()) {
            this.getNext((ITmfContext)context);
        }
        return context;
    }

    public synchronized TmfContext seekEvent(ITmfTimestamp timestamp) {
        this.currentJniTrace.seekToTime(new JniTime(timestamp.getValue()));
        this.previousLocation.setOperationTime(timestamp.getValue());
        this.previousLocation.setLastOperationSeek();
        LttngLocation curLocation = new LttngLocation(this.previousLocation);
        return new TmfContext((ITmfLocation)curLocation);
    }

    public synchronized TmfContext seekEvent(long rank) {
        ITmfContext checkpointContext = this.getIndexer().seekIndex(rank);
        LttngLocation location = (LttngLocation)checkpointContext.getLocation();
        LttngTimestamp timestamp = location.getLocation();
        long index = rank / (long)this.getCacheSize();
        TmfContext tmpContext = this.seekEvent((ITmfTimestamp)timestamp);
        tmpContext.setRank((index + 1L) * (long)this.getCacheSize());
        this.previousLocation = (LttngLocation)tmpContext.getLocation();
        Long currentPosition = index * (long)this.getCacheSize();
        Long lastTimeValueRead = 0L;
        JniEvent tmpJniEvent = this.currentJniTrace.findNextEvent();
        while (tmpJniEvent != null && currentPosition < rank) {
            tmpJniEvent = this.currentJniTrace.readNextEvent();
            currentPosition = currentPosition + 1L;
        }
        if (tmpJniEvent != null) {
            lastTimeValueRead = tmpJniEvent.getEventTime().getTime();
        }
        this.previousLocation.setLastOperationSeek();
        this.previousLocation.setOperationTime(lastTimeValueRead);
        LttngLocation curLocation = new LttngLocation(this.previousLocation);
        return new TmfContext((ITmfLocation)curLocation, rank);
    }

    public TmfContext seekEvent(double ratio) {
        return null;
    }

    public double getLocationRatio(ITmfLocation<?> location) {
        return 0.0;
    }

    public synchronized LttngEvent getNext(ITmfContext context) {
        LttngEvent returnedEvent = null;
        LttngLocation curLocation = null;
        curLocation = (LttngLocation)context.getLocation();
        if (curLocation == null) {
            curLocation = this.getCurrentLocation(context);
        }
        if (!curLocation.isLastOperationParse() || this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
            if (this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
                this.seekEvent((ITmfTimestamp)curLocation.getOperationTime());
            }
            returnedEvent = this.readNextEvent(curLocation);
        } else {
            returnedEvent = this.currentLttngEvent;
            this.previousLocation.setLastOperationReadNext();
            curLocation.setLastOperationReadNext();
        }
        if (returnedEvent != null) {
            this.setPreviousAndCurrentTimes(context, returnedEvent, curLocation);
        }
        return returnedEvent;
    }

    private synchronized void setPreviousAndCurrentTimes(ITmfContext context, LttngEvent returnedEvent, LttngLocation curLocation) {
        ITmfTimestamp eventTimestamp = returnedEvent.getTimestamp();
        this.previousLocation.setOperationTime(eventTimestamp.getValue());
        curLocation.setOperationTime(eventTimestamp.getValue());
        this.updateAttributes(context, eventTimestamp);
        context.increaseRank();
    }

    private synchronized LttngEvent readNextEvent(LttngLocation curLocation) {
        LttngEvent returnedEvent = this.readEvent(curLocation);
        ++this.nbEventsRead;
        this.previousLocation.setLastOperationReadNext();
        curLocation.setLastOperationReadNext();
        return returnedEvent;
    }

    private LttngLocation getCurrentLocation(ITmfContext context) {
        LttngLocation curLocation = new LttngLocation();
        context.setLocation((ITmfLocation)curLocation);
        return curLocation;
    }

    public synchronized LttngEvent parseEvent(ITmfContext context) {
        LttngEvent returnedEvent = null;
        LttngLocation curLocation = null;
        if (context.getLocation() == null) {
            curLocation = new LttngLocation();
            context.setLocation((ITmfLocation)curLocation);
        } else {
            curLocation = (LttngLocation)context.getLocation();
        }
        if (!curLocation.isLastOperationParse() || this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
            if (this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
                this.seekEvent((ITmfTimestamp)curLocation.getOperationTime());
            }
            returnedEvent = this.readEvent(curLocation);
        } else {
            returnedEvent = this.currentLttngEvent;
        }
        if (returnedEvent != null) {
            this.previousLocation.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
            curLocation.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
        }
        this.previousLocation.setLastOperationParse();
        curLocation.setLastOperationParse();
        return returnedEvent;
    }

    private synchronized LttngEvent readEvent(LttngLocation location) {
        LttngEvent returnedEvent = null;
        JniEvent tmpEvent = null;
        tmpEvent = this.currentJniTrace.readNextEvent();
        if (tmpEvent != null) {
            returnedEvent = this.convertJniEventToTmf(tmpEvent);
            location.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
        } else {
            location.setOperationTime(this.getEndTime().getValue() + 1L);
        }
        return returnedEvent;
    }

    public synchronized LttngEvent convertJniEventToTmf(JniEvent newEvent) {
        this.currentLttngEvent = this.convertJniEventToTmf(newEvent, false);
        return this.currentLttngEvent;
    }

    public synchronized LttngEvent convertJniEventToTmf(JniEvent jniEvent, boolean isParsingNeeded) {
        this.eventTimestamp.setValue(jniEvent.getEventTime().getTime());
        this.eventSource = jniEvent.requestEventSource();
        this.eventType = this.traceTypes.get(EventTypeKey.getEventTypeHash(jniEvent));
        String fullTracePath = this.getName();
        String reference = fullTracePath.substring(fullTracePath.lastIndexOf(47) + 1);
        this.currentLttngEvent.setReference(reference);
        this.eventContent.emptyContent();
        this.currentLttngEvent.setType(this.eventType);
        this.currentLttngEvent.updateJniEventReference(jniEvent);
        if (isParsingNeeded) {
            this.eventContent.getFields();
        }
        return this.currentLttngEvent;
    }

    private synchronized LttngEvent convertJniEventToTmfMultipleEventEvilFix(JniEvent jniEvent, boolean isParsingNeeded) {
        this.eventTimestamp = new LttngTimestamp(jniEvent.getEventTime().getTime());
        this.eventSource = jniEvent.requestEventSource();
        this.eventReference = this.getName();
        this.eventType = new LttngEventType(this.traceTypes.get(EventTypeKey.getEventTypeHash(jniEvent)));
        this.eventContent = new LttngEventContent(this.currentLttngEvent);
        this.currentLttngEvent = new LttngEvent(this, this.eventTimestamp, this.eventSource, this.eventType, this.eventContent, this.eventReference, null);
        this.currentLttngEvent.updateJniEventReference(jniEvent);
        this.eventContent.setEvent(this.currentLttngEvent);
        if (isParsingNeeded) {
            this.eventContent.getFields();
        }
        return this.currentLttngEvent;
    }

    public JniTrace getCurrentJniTrace() {
        return this.currentJniTrace;
    }

    public synchronized LttngEvent getCurrentEvent() {
        return this.currentLttngEvent;
    }

    public short getVersionMajor() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getLttMajorVersion();
        }
        return -1;
    }

    public short getVersionMinor() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getLttMinorVersion();
        }
        return -1;
    }

    public int getCpuNumber() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getCpuNumber();
        }
        return -1;
    }

    public synchronized void dispose() {
        if (this.currentJniTrace != null) {
            this.currentJniTrace.closeTrace();
        }
        super.dispose();
    }

    public String toString() {
        String returnedData = "";
        returnedData = String.valueOf(returnedData) + "Path :" + this.getPath() + " ";
        returnedData = String.valueOf(returnedData) + "Trace:" + this.currentJniTrace + " ";
        returnedData = String.valueOf(returnedData) + "Event:" + (Object)((Object)this.currentLttngEvent);
        return returnedData;
    }
}

