/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.DownloadJob;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class SourcesFileDownloadHyperlink
implements IHyperlink {
    String fileName;
    IFile original;
    IRegion region;

    public SourcesFileDownloadHyperlink(IFile original, String fileName, IRegion region) {
        this.fileName = fileName;
        this.original = original;
        this.region = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return String.valueOf(Messages.SourcesFileHyperlink_1) + ' ' + this.fileName;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IContainer container = this.original.getParent();
        IResource saveFolder = container.getParent().findMember("SOURCES");
        if (saveFolder == null) {
            saveFolder = container.findMember(this.original.getFullPath().removeLastSegments(1));
        }
        if (saveFolder == null) {
            saveFolder = container.findMember("/");
        }
        try {
            URL url = new URL(this.fileName);
            URLConnection connection = url.openConnection();
            String savedFileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
            IFile savedFile = this.original.getProject().getFile(saveFolder.getProjectRelativePath().append(savedFileName));
            if (savedFile.exists()) {
                MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 292);
                mb.setText(Messages.SourcesFileDownloadHyperlink_0);
                mb.setMessage(NLS.bind((String)Messages.SourcesFileDownloadHyperlink_1, (Object)savedFileName));
                int rc = mb.open();
                if (rc == 32) {
                    new DownloadJob(savedFile, connection, true).schedule();
                }
            } else {
                new DownloadJob(savedFile, connection).schedule();
            }
        }
        catch (IOException iOException) {
            MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 40);
            mb.setMessage(Messages.SourcesFileDownloadHyperlink_2);
            mb.setText(Messages.SourcesFileDownloadHyperlink_3);
            mb.open();
        }
    }
}

