/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;

public class SpecfilePackageContainer
extends SpecfileElement {
    List<SpecfilePackage> packages = new ArrayList<SpecfilePackage>();

    public SpecfilePackage[] getPackages() {
        try {
            Object[] objs = this.packages.toArray();
            SpecfilePackage[] packs = new SpecfilePackage[objs.length];
            int i = 0;
            while (i < objs.length) {
                SpecfilePackage pack;
                packs[i] = pack = (SpecfilePackage)objs[i];
                ++i;
            }
            return packs;
        }
        catch (Exception e) {
            SpecfileLog.logError(e);
            return new SpecfilePackage[0];
        }
    }

    void addPackage(SpecfilePackage subPackage) {
        this.packages.add(subPackage);
    }

    public int getLineStartPosition() {
        if (this.packages == null || this.packages.size() == 0) {
            return 0;
        }
        int lowestStartLine = Integer.MAX_VALUE;
        for (SpecfilePackage subPackage : this.packages) {
            if (subPackage.getLineStartPosition() >= lowestStartLine) continue;
            lowestStartLine = subPackage.getLineStartPosition();
        }
        if (lowestStartLine == Integer.MAX_VALUE) {
            return 0;
        }
        return lowestStartLine;
    }

    public int getLineEndPosition() {
        if (this.packages == null || this.packages.isEmpty()) {
            return 0;
        }
        int highestEndLine = 0;
        for (SpecfilePackage subPackage : this.packages) {
            if (subPackage.getLineStartPosition() <= highestEndLine) continue;
            highestEndLine = subPackage.getLineEndPosition();
        }
        if (highestEndLine < 0) {
            return 0;
        }
        return highestEndLine;
    }

    public SpecfilePackage getPackage(String packageName) {
        for (SpecfilePackage thisPackage : this.packages) {
            if (!thisPackage.getPackageName().equals(thisPackage.resolve(packageName))) continue;
            return thisPackage;
        }
        return null;
    }

    public boolean contains(SpecfilePackage subPackage) {
        return this.packages.contains(subPackage);
    }

    public boolean hasChildren() {
        return this.packages != null && this.packages.size() > 0;
    }
}

