/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IGetEventInfoDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.BaseEventComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.KernelProviderComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.UstProviderComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AssignEventHandler
extends BaseControlViewHandler {
    private Parameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            final Parameter param = new Parameter(this.fParam);
            final IGetEventInfoDialog dialog = TraceControlDialogFactory.getInstance().getGetEventInfoDialog();
            dialog.setIsKernel(param.isKernel());
            dialog.setSessions(param.getSessions());
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_EnableEventsJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    try {
                        ArrayList<String> eventNames = new ArrayList<String>();
                        List<BaseEventComponent> events = param.getEvents();
                        for (BaseEventComponent event : events) {
                            eventNames.add(event.getName());
                        }
                        TraceChannelComponent channel = dialog.getChannel();
                        if (channel == null) {
                            dialog.getSession().enableEvents(eventNames, param.isKernel(), monitor);
                        } else {
                            channel.enableEvents(eventNames, monitor);
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    AssignEventHandler.this.refresh(new CommandParameter(dialog.getSession()));
                    if (error != null) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_EnableEventsFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        ArrayList<BaseEventComponent> events = new ArrayList<BaseEventComponent>();
        TraceSessionComponent[] sessions = null;
        Boolean isKernel = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                if (!(element instanceof BaseEventComponent)) continue;
                BaseEventComponent event = (BaseEventComponent)element;
                ITraceControlComponent provider = event.getParent();
                boolean temp = false;
                if (provider instanceof KernelProviderComponent) {
                    temp = true;
                } else if (provider instanceof UstProviderComponent) {
                    temp = false;
                } else {
                    return false;
                }
                if (isKernel == null) {
                    isKernel = temp;
                } else if (isKernel != temp) {
                    return false;
                }
                events.add(event);
                if (sessions != null) continue;
                TargetNodeComponent root = (TargetNodeComponent)event.getParent().getParent().getParent();
                sessions = root.getSessions();
            }
        }
        boolean isEnabled = !events.isEmpty() && sessions != null && sessions.length > 0;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter(sessions, events, isKernel);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static final class Parameter {
        private List<BaseEventComponent> fEvents;
        private final TraceSessionComponent[] fSessions;
        private final boolean fIsKernel;

        public Parameter(TraceSessionComponent[] sessions, List<BaseEventComponent> events, boolean isKernel) {
            this.fSessions = Arrays.copyOf(sessions, sessions.length);
            this.fEvents = new ArrayList<BaseEventComponent>();
            this.fEvents.addAll(events);
            this.fIsKernel = isKernel;
        }

        public Parameter(Parameter other) {
            this(other.fSessions, other.fEvents, other.fIsKernel);
        }

        public TraceSessionComponent[] getSessions() {
            return this.fSessions;
        }

        public List<BaseEventComponent> getEvents() {
            return this.fEvents;
        }

        public boolean isKernel() {
            return this.fIsKernel;
        }
    }
}

