/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class TypeCountWriter {
    private final OrcsApi orcsApi;

    public TypeCountWriter(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void write(BranchId branch, Set<ArtifactId> newArts, Set<ArtifactId> modifiedArts, Set<ArtifactId> deletedArts, List<Long> artTypes, List<Long> attrTypes, OutputStream outputStream) {
        try {
            int index;
            Object[] row;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            List<AttributeTypeToken> attributes = this.getAttrTypes(attrTypes);
            Object[] headers = this.getHeaders(attributes);
            int columns = headers.length;
            sheetWriter.startSheet("Type Count Report", headers.length);
            sheetWriter.writeRow(headers);
            List<ArtifactTypeToken> artifactTypes = this.getTypes(artTypes);
            if (!newArts.isEmpty()) {
                ResultSet newArtifacts = this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes).andIds(newArts).getResults();
                for (ArtifactReadable art : newArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "NEW";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeToken type : attributes) {
                        row[index++] = art.getAttributeValues(type).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            if (!modifiedArts.isEmpty()) {
                ResultSet modifiedArtifacts = this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes).andIds(modifiedArts).getResults();
                for (ArtifactReadable art : modifiedArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "MODIFIED";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeToken type : attributes) {
                        row[index++] = art.getAttributeValues(type).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            if (!deletedArts.isEmpty()) {
                ResultSet deletedArtifacts = this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes).andIds(deletedArts).getResults();
                for (ArtifactReadable art : deletedArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "DELETED";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeToken type : attributes) {
                        row[index++] = art.getAttributeValues(type).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private List<ArtifactTypeToken> getTypes(List<Long> typeIds) {
        ArrayList<ArtifactTypeToken> toReturn = new ArrayList<ArtifactTypeToken>();
        Collection allTypes = this.orcsApi.tokenService().getArtifactTypes();
        for (ArtifactTypeToken type : allTypes) {
            if (!typeIds.contains(type.getId())) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    private List<AttributeTypeToken> getAttrTypes(List<Long> typeIds) {
        ArrayList<AttributeTypeToken> toReturn = new ArrayList<AttributeTypeToken>();
        Collection allTypes = this.orcsApi.tokenService().getAttributeTypes();
        for (AttributeTypeGeneric type : allTypes) {
            if (!typeIds.contains(type.getId())) continue;
            toReturn.add((AttributeTypeToken)type);
        }
        return toReturn;
    }

    private String[] getHeaders(List<AttributeTypeToken> types) {
        String[] toReturn = new String[types.size() + 3];
        int index = 0;
        toReturn[index++] = "Name";
        toReturn[index++] = "Mod Type";
        toReturn[index++] = "Art Type";
        for (AttributeTypeToken type : types) {
            toReturn[index++] = type.getName();
        }
        return toReturn;
    }
}

