/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.config.OrganizePrograms;
import org.eclipse.osee.ats.rest.internal.demo.AtsDbConfigAIsAndTeamsDemoOp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class AtsDbConfigDemoOp {
    private final AtsApi atsApi;

    public AtsDbConfigDemoOp(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        new AtsDbConfigAIsAndTeamsDemoOp(this.atsApi).run();
        this.configureForParallelCommit();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set ATS Admin");
        changes.relate((ArtifactId)AtsUserGroups.AtsTempAdmin, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Joe_Smith);
        changes.execute();
        new OrganizePrograms(this.atsApi).run();
        this.createDemoWebConfig();
        this.atsApi.setConfigValue("single_server_deployment", "true");
        return new XResultData();
    }

    private void createDemoWebConfig() {
        ArtifactToken headingArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsTopFolder);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Web Programs");
        ArtifactToken oseeWebArt = changes.createArtifact(headingArt, AtsArtifactToken.WebPrograms);
        ArtifactToken sawProgram = this.atsApi.getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_PL_Program);
        changes.relate((ArtifactId)oseeWebArt, CoreRelationTypes.UniversalGrouping_Members, (ArtifactId)sawProgram);
        changes.execute();
    }

    private void configureForParallelCommit() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("configureForParallelCommit");
        Version sawBld1Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_1);
        Version sawBld2Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_2);
        Version sawBld3Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_3);
        changes.relate((Object)sawBld1Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld2Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld1Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld3Ver);
        changes.execute();
    }
}

