/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.internal.ContextConfigProvider;
import org.eclipse.osee.authentication.ldap.internal.LdapClient;
import org.eclipse.osee.authentication.ldap.internal.LdapConnection;
import org.eclipse.osee.logger.Log;

public final class LdapConnectionFactoryImpl
implements LdapClient.LdapConnectionFactory {
    private static final String KERBEROS_LOGIN = "KerberosLogin";
    private final Log logger;

    public LdapConnectionFactoryImpl(Log logger) {
        this.logger = logger;
    }

    @Override
    public LdapConnection createConnection(ContextConfigProvider provider, LdapAuthenticationType authType, Hashtable<String, String> properties) throws NamingException, LoginException, PrivilegedActionException {
        DirContext context = LdapAuthenticationType.GSSAPI == authType ? this.doKerberosLogin(properties) : new InitialDirContext(properties);
        return new LdapConnection(this.logger, provider, context);
    }

    private DirContext doKerberosLogin(final Hashtable<String, String> env) throws LoginException, PrivilegedActionException {
        LoginContext context = new LoginContext(KERBEROS_LOGIN);
        context.login();
        Subject subject = context.getSubject();
        try {
            DirContext dirContext = Subject.doAs(subject, new PrivilegedExceptionAction<DirContext>(){

                @Override
                public DirContext run() throws NamingException {
                    return new InitialDirContext(env);
                }
            });
            return dirContext;
        }
        finally {
            context.logout();
        }
    }
}

