/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.session;

import org.eclipse.osee.jaxrs.server.database.AbstractDatabaseStorage;
import org.eclipse.osee.jaxrs.server.session.SessionData;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;

public class SessionStorage
extends AbstractDatabaseStorage<SessionData> {
    private static final String INSERT_SESSION = "INSERT INTO osee_oauth_session (session_id, issued_at, expires_in, subject_token) VALUES (?,?,?,?)";
    private static final String SELECT_SESSION_BY_ID = "select * from osee_oauth_session where session_id = ?";
    private static final String DELETE_SESSION_BY_ID = "DELETE FROM osee_oauth_session WHERE session_id = ?";

    public SessionStorage(Log logger, JdbcClient jdbcClient) {
        super(logger, jdbcClient);
    }

    @Override
    protected Object[] asInsert(SessionData session) {
        return new Object[]{session.getGuid(), session.getIssuedAt(), session.getExpiresIn(), session.getSubjectToken()};
    }

    @Override
    protected Object[] asUpdate(SessionData item) {
        return null;
    }

    @Override
    protected Object[] asDelete(SessionData item) {
        return new Object[]{item.getGuid()};
    }

    public void insertSessions(SessionData ... sessions) {
        this.insertItems(INSERT_SESSION, sessions);
    }

    public SessionData getSession(String sessionId) {
        return (SessionData)((Object)this.selectOneOrNull(SELECT_SESSION_BY_ID, sessionId));
    }

    public void deleteSessioin(Iterable<SessionData> datas) {
        this.deleteItems(DELETE_SESSION_BY_ID, datas);
    }

    @Override
    protected SessionData readData(JdbcStatement chStmt) {
        String sessionId = chStmt.getString("session_id");
        Long issuedAt = chStmt.getLong("issued_at");
        Long expiresIn = chStmt.getLong("expires_in");
        String subjectToken = chStmt.getString("subject_token");
        SessionData sessionData = new SessionData(sessionId);
        sessionData.setIssuedAt(issuedAt);
        sessionData.setExpiresIn(expiresIn);
        sessionData.setSubjectToken(subjectToken);
        return sessionData;
    }
}

