/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.IcdEndpoint;
import org.eclipse.osee.mim.internal.IcdStreamingOutput;
import org.eclipse.osee.orcs.OrcsApi;

public class IcdEndpointImpl
implements IcdEndpoint {
    private final BranchId branch;
    private final ArtifactId viewId;
    private final OrcsApi orcsApi;
    private final ArtifactId connectionId;

    public IcdEndpointImpl(BranchId branch, ArtifactId viewId, ArtifactId connectionId, OrcsApi orcsApi) {
        this.branch = branch;
        this.viewId = viewId;
        this.orcsApi = orcsApi;
        this.connectionId = connectionId;
    }

    @Override
    public Response getIcd() {
        IcdStreamingOutput streamingOutput = new IcdStreamingOutput(this.orcsApi, this.branch, this.viewId, this.connectionId);
        String connectionName = this.orcsApi.getQueryFactory().fromBranch(this.branch, this.viewId).andId(this.connectionId).asArtifact().getName();
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=InterfaceWorkbook_" + connectionName + ".xml"));
        return builder.build();
    }
}

