/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsCollectorValidator;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsCollectorWriter;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterCollectorGenerator;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterExcelReader;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterStreamingOutput;
import org.eclipse.osee.orcs.rest.model.OrcsWriterEndpoint;
import org.eclipse.osee.orcs.rest.model.writer.OrcsWriterResponse;
import org.eclipse.osee.orcs.rest.model.writer.config.OrcsWriterInputConfig;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;

public class OrcsWriterEndpointImpl
implements OrcsWriterEndpoint {
    private static final String EXCEPTION_READING_INPUT_S = "Exception reading input\n\n%s";
    private static final String ERROR_READING_INPUT_S = "Exception reading input\n\n%s";
    private static final String ERROR_VALIDATING_INPUT_S = "Error validating input\n\n%s";
    private static final String EXCEPTION_VALIDATING_INPUT_S = "Exception validating input\n\n%s";
    private static final String EXCEPTION_WRITING_CHANGES_S = "Exception writing changes\n\n%s";
    private static final String ERROR_WRITING_CHANGES_S = "Error writing changes:\n\n%s";
    private final OrcsApi orcsApi;

    public OrcsWriterEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public Response getOrcsWriterInputDefault() {
        OrcsWriterCollectorGenerator generator = new OrcsWriterCollectorGenerator();
        OwCollector collector = generator.run(this.orcsApi);
        OrcsWriterStreamingOutput streamingOutput = new OrcsWriterStreamingOutput(this.orcsApi, collector);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)"attachment; filename=OrcsWriterInput.xml");
        return builder.build();
    }

    public Response getOrcsWriterInputDefaultJson() throws Exception {
        OrcsWriterCollectorGenerator generator = new OrcsWriterCollectorGenerator();
        OwCollector collector = generator.run(this.orcsApi);
        return Response.ok((Object)collector).build();
    }

    public Response getOrcsWriterInputFromConfig(OrcsWriterInputConfig config) {
        OrcsWriterCollectorGenerator generator = new OrcsWriterCollectorGenerator(config);
        OwCollector collector = generator.run(this.orcsApi);
        OrcsWriterStreamingOutput streamingOutput = new OrcsWriterStreamingOutput(this.orcsApi, collector);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)"attachment; filename=OrcsWriterInput.xml");
        return builder.build();
    }

    public Response getOrcsWriterValidate(OwCollector collector) {
        OrcsWriterResponse response = new OrcsWriterResponse();
        response.setTitle("JSON Validator");
        XResultData results = null;
        try {
            OrcsCollectorValidator validator = new OrcsCollectorValidator(this.orcsApi, collector);
            results = validator.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_VALIDATING_INPUT_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_VALIDATING_INPUT_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        response.setMessage("Success");
        return Response.ok((Object)response).build();
    }

    public Response getOrcsWriterPersist(OwCollector collector) {
        OrcsWriterResponse response = new OrcsWriterResponse();
        response.setTitle("JSON Executor");
        XResultData results = null;
        try {
            OrcsCollectorValidator validator = new OrcsCollectorValidator(this.orcsApi, collector);
            results = validator.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_VALIDATING_INPUT_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_VALIDATING_INPUT_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        try {
            OrcsCollectorWriter writer = new OrcsCollectorWriter(this.orcsApi, collector, results);
            writer.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_WRITING_CHANGES_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_WRITING_CHANGES_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        response.setMessage("Success");
        return Response.ok().entity((Object)response).build();
    }

    public Response validateExcelInput(Attachment attachment) {
        InputStream stream = (InputStream)attachment.getObject(InputStream.class);
        OrcsWriterResponse response = new OrcsWriterResponse();
        response.setTitle("Excel Validation");
        XResultData results = new XResultData();
        OrcsWriterExcelReader reader = new OrcsWriterExcelReader(results);
        try {
            reader.run(stream);
        }
        catch (Exception ex) {
            response.setMessage(String.format("Exception reading input\n\n%s", Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format("Exception reading input\n\n%s", results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        OwCollector collector = reader.getCollector();
        try {
            OrcsCollectorValidator validator = new OrcsCollectorValidator(this.orcsApi, collector);
            results = validator.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_VALIDATING_INPUT_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_VALIDATING_INPUT_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        response.setMessage("Success");
        return Response.ok().entity((Object)response).build();
    }

    public Response persistExcelInput(Attachment attachment) {
        InputStream stream = (InputStream)attachment.getObject(InputStream.class);
        XResultData results = new XResultData();
        OrcsWriterResponse response = new OrcsWriterResponse();
        response.setTitle("Excel Executor");
        OrcsWriterExcelReader reader = new OrcsWriterExcelReader(results);
        try {
            reader.run(stream);
        }
        catch (Exception ex) {
            response.setMessage(String.format("Exception reading input\n\n%s", Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format("Exception reading input\n\n%s", results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        OwCollector collector = reader.getCollector();
        try {
            OrcsCollectorValidator validator = new OrcsCollectorValidator(this.orcsApi, collector);
            results = validator.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_VALIDATING_INPUT_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_VALIDATING_INPUT_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        try {
            OrcsCollectorWriter writer = new OrcsCollectorWriter(this.orcsApi, collector, results);
            writer.run();
        }
        catch (Exception ex) {
            response.setMessage(String.format(EXCEPTION_WRITING_CHANGES_S, Lib.exceptionToString((Exception)ex)));
            return Response.serverError().entity((Object)response).build();
        }
        if (results.isErrors()) {
            response.setMessage(String.format(ERROR_WRITING_CHANGES_S, results.toString()));
            return Response.serverError().entity((Object)response).build();
        }
        results.log("Success");
        response.setMessage(results.toString());
        return Response.ok().entity((Object)response).build();
    }
}

