/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.activity.api.ThreadStats;

public class ThreadActivity {
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private static final int ConvertToMillSec = 1000000;

    public ThreadStats[] getThreadActivity() {
        ThreadInfo[] threadInfos = this.threadMxBean.dumpAllThreads(false, false);
        ThreadStats[] threadStats = new ThreadStats[threadInfos.length];
        int i = 0;
        while (i < threadStats.length) {
            threadStats[i] = new ThreadStats(threadInfos[i], this.threadMxBean.getThreadCpuTime(threadInfos[i].getThreadId()));
            ++i;
        }
        return threadStats;
    }

    public List<String> getThreadActivityDelta(ThreadStats[] threadStats) {
        LinkedList<String> threads = new LinkedList<String>();
        ThreadStats[] threadStatsArray = threadStats;
        int n = threadStats.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadStats stat = threadStatsArray[n2];
            stat.setCpuTimeElapsed(this.threadMxBean);
            ++n2;
        }
        Arrays.sort(threadStats, (t1, t2) -> Long.compare(t1.cpuTimeElapsed, t2.cpuTimeElapsed));
        int n3 = Math.max(threadStats.length - 15, 0);
        int i = threadStats.length - 1;
        while (i >= n3) {
            if (threadStats[i].cpuTimeElapsed == 0L) break;
            threads.add(String.format("[%s] - id [%s] elapsed [%s] total [%s]", threadStats[i].threadInfo.getThreadName(), threadStats[i].threadInfo.getThreadId(), threadStats[i].cpuTimeElapsed / 1000000L, threadStats[i].cpuTime / 1000000L));
            StackTraceElement[] stackTrace = threadStats[i].threadInfo.getStackTrace();
            if (stackTrace.length > 0) {
                int stackCount = Math.min(12, stackTrace.length);
                int j = 0;
                while (j < stackCount) {
                    threads.add("trace: " + String.valueOf(stackTrace[j]));
                    ++j;
                }
            }
            --i;
        }
        return threads;
    }
}

