/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jaxrs.server.database.AbstractDatabaseStorage;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;

public class ClientCredentialStorage
extends AbstractDatabaseStorage<OAuthClientCredential> {
    private static final String SELECT_CLIENT_CREDENTIAL_BY_CLIENT_ID_AND_APPLICATION_ID = "SELECT * FROM osee_oauth_client_credential WHERE client_id= ? AND application_id = ?";
    private static final String SELECT_CLIENT_CREDENTIAL_BY_APPLICATION_ID = "SELECT * FROM osee_oauth_client_credential WHERE application_id = ?";
    private static final String SELECT_CLIENT_CREDENTIAL_BY_CLIENT_KEY = "SELECT * FROM osee_oauth_client_credential WHERE client_key = ?";
    private static final String INSERT_CLIENT_CREDENTIAL = "INSERT INTO osee_oauth_client_credential (client_id, application_id, subject_id, client_key, client_secret, client_cert) VALUES (?,?,?,?,?,?)";
    private static final String DELETE_CLIENT_CREDENTIAL_BY_CLIENT_ID = "DELETE FROM osee_oauth_client_credential WHERE client_id = ?";
    private static final String UPDATE_BY_CLIENT_CREDENTIAL = "UPDATE osee_oauth_client_credential SET subject_id = ?, client_key = ?, client_key = ?, client_secret = ?, client_cert = ? WHERE client_id = ? AND application_id = ?";

    public ClientCredentialStorage(Log logger, JdbcClient jdbcClient) {
        super(logger, jdbcClient);
    }

    protected Object[] asInsert(OAuthClientCredential data) {
        return new Object[]{data.getClientId(), data.getApplicationId(), data.getSubjectId(), data.getClientKey(), this.asVarcharOrNull(data.getClientSecret()), this.asVarcharOrNull(this.asCertString(data.getClientCertificates()))};
    }

    protected Object[] asUpdate(OAuthClientCredential data) {
        return new Object[]{data.getSubjectId(), data.getClientKey(), this.asVarcharOrNull(data.getClientSecret()), this.asVarcharOrNull(this.asCertString(data.getClientCertificates())), data.getClientId(), data.getApplicationId()};
    }

    protected Object[] asDelete(OAuthClientCredential data) {
        return new Object[]{data.getClientId()};
    }

    public void update(OAuthClientCredential data) {
        this.updateItems(UPDATE_BY_CLIENT_CREDENTIAL, new OAuthClientCredential[]{data});
    }

    public OAuthClientCredential getByClientKey(String clientKey) {
        return (OAuthClientCredential)this.selectOneOrNull(SELECT_CLIENT_CREDENTIAL_BY_CLIENT_KEY, new Object[]{clientKey});
    }

    public OAuthClientCredential getByApplicationId(long applicationId) {
        return (OAuthClientCredential)this.selectOneOrNull(SELECT_CLIENT_CREDENTIAL_BY_APPLICATION_ID, new Object[]{applicationId});
    }

    public OAuthClientCredential getByClientIdAndApplicationId(long clientId, ArtifactId applicationId) {
        return (OAuthClientCredential)this.selectOneOrNull(SELECT_CLIENT_CREDENTIAL_BY_CLIENT_ID_AND_APPLICATION_ID, new Object[]{clientId, applicationId});
    }

    public void insert(OAuthClientCredential data) {
        this.insertItems(INSERT_CLIENT_CREDENTIAL, new OAuthClientCredential[]{data});
    }

    public void delete(OAuthClientCredential data) {
        this.deleteItems(DELETE_CLIENT_CREDENTIAL_BY_CLIENT_ID, new OAuthClientCredential[]{data});
    }

    public void delete(Iterable<OAuthClientCredential> datas) {
        this.deleteItems(DELETE_CLIENT_CREDENTIAL_BY_CLIENT_ID, datas);
    }

    protected OAuthClientCredential readData(JdbcStatement chStmt) {
        long clientId = chStmt.getLong("client_id");
        long applicationId = chStmt.getLong("application_id");
        long subjectId = chStmt.getLong("subject_id");
        String clientKey = chStmt.getString("client_key");
        String clientSecret = chStmt.getString("client_secret");
        String clientCert = chStmt.getString("client_cert");
        List certs = Collections.fromString((String)clientCert, (String)";");
        return this.newCredential(clientId, applicationId, subjectId, clientKey, clientSecret, certs);
    }

    private String asCertString(List<String> certs) {
        return certs != null ? Collections.toString((String)";", certs) : null;
    }

    public OAuthClientCredential newCredential(final long clientId, final long applicationId, final long subjectId, final String clientKey, final String clientSecret, final List<String> clientCert) {
        return new OAuthClientCredential(){

            @Override
            public long getClientId() {
                return clientId;
            }

            @Override
            public long getApplicationId() {
                return applicationId;
            }

            @Override
            public long getSubjectId() {
                return subjectId;
            }

            @Override
            public String getClientKey() {
                return clientKey;
            }

            @Override
            public String getClientSecret() {
                return clientSecret;
            }

            @Override
            public List<String> getClientCertificates() {
                return clientCert;
            }
        };
    }
}

