/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.synchronization.rest.AbstractGroveThing;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.rest.RootList;
import org.eclipse.osee.synchronization.util.IndentedString;

public class HeaderGroveThing
extends AbstractGroveThing
implements Id {
    private OrcsApi orcsApi = null;
    private RootList rootList;

    public HeaderGroveThing() {
        super(IdentifierType.HEADER.createIdentifier());
    }

    void setOrcsApi(OrcsApi orcsApi) {
        assert (Objects.nonNull(orcsApi) && Objects.isNull(this.orcsApi));
        this.orcsApi = orcsApi;
    }

    void setRootListImpl(RootList rootList) {
        assert (Objects.nonNull(rootList) && Objects.isNull(this.rootList));
        this.rootList = rootList;
    }

    public Long getId() {
        return this.groveThingKey.getCount();
    }

    public String getComment() {
        return this.rootList.toText(null).toString();
    }

    public String getRepositoryId() {
        JdbcService jdbcService = this.orcsApi.getJdbcService();
        JdbcClient jdbcClient = jdbcService.getClient();
        String databaseName = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db");
        if (Objects.isNull(databaseName) || databaseName.isEmpty()) {
            databaseName = "(no-database-name)";
        }
        String databaseId = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db.guid");
        return databaseName + "( " + databaseId + " )";
    }

    public String getSourceToolId() {
        return OseeCodeVersion.getVersionId().toString();
    }

    public GregorianCalendar getTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        return calendar;
    }

    public String getTitle() {
        return "OSEE Synchronization Artifact";
    }

    @Override
    public GroveThing setNativeThing(Object nativeThing) {
        assert (nativeThing instanceof HeaderGroveThing);
        return super.setNativeThing(nativeThing);
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(indent + 0);
        String indent1 = IndentedString.indentString(indent + 1);
        String name = this.getClass().getName();
        outMessage.append(indent0).append(name).append("\n").append(indent1).append("ORCS API: ").append(Objects.nonNull(this.orcsApi) ? "(is set)" : "(is not set)").append("\n");
        if (Objects.isNull(this.rootList)) {
            outMessage.append(indent1).append("Root List: ").append("(is not set)").append("\n");
        } else {
            this.rootList.toMessage(indent + 1, outMessage);
        }
        return outMessage;
    }
}

