/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.JobChangeLogger;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.OperationBuilderImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public final class Operations {
    public static final int TASK_WORK_RESOLUTION = Integer.MAX_VALUE;
    private static final IOperation NOOP_OPERATION = Operations.createNoOpOperation("");

    private Operations() {
    }

    public static IOperation createNoOpOperation(String name) {
        return new AbstractOperation(name, null){

            @Override
            protected void doWork(IProgressMonitor monitor) throws Exception {
            }
        };
    }

    public static IOperation getNoOpOperation() {
        return NOOP_OPERATION;
    }

    public static int calculateWork(int totalWork, double workPercentage) {
        return (int)((double)totalWork * workPercentage);
    }

    public static void checkForErrorStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Throwable th = status.getException();
            if (th != null) {
                OseeCoreException.wrapAndThrow((Throwable)th);
            } else {
                throw new OseeStateException(status.getMessage(), new Object[0]);
            }
        }
    }

    public static IStatus executeWork(IOperation operation) {
        return Operations.executeWork(operation, null);
    }

    public static void executeWorkAndCheckStatus(IOperation operation) {
        Operations.executeWorkAndCheckStatus(operation, null);
    }

    public static IStatus executeWorkAndCheckStatus(IOperation operation, IProgressMonitor monitor) {
        IStatus status = Operations.executeWork(operation, monitor);
        Operations.checkForErrorStatus(status);
        return status;
    }

    public static Job executeAsJob(IOperation operation, boolean user) {
        return Operations.executeAsJob(operation, user, 30, null, null);
    }

    public static Job executeAsJob(IOperation operation, boolean user, ISchedulingRule rule) {
        return Operations.executeAsJob(operation, user, 30, null, rule);
    }

    public static Job executeAsJob(IOperation operation, boolean user, int priority, IJobChangeListener jobChangeListener, ISchedulingRule rule) {
        OperationJob job = new OperationJob(operation);
        job.addJobChangeListener((IJobChangeListener)new JobChangeLogger(operation.getLogger()));
        return Operations.scheduleJob(job, user, priority, jobChangeListener, rule);
    }

    public static Job executeAsJob(IOperation operation, boolean user, int priority, IJobChangeListener jobChangeListener) {
        return Operations.executeAsJob(operation, user, priority, jobChangeListener, null);
    }

    public static Job scheduleJob(Job job, boolean user, int priority, IJobChangeListener jobChangeListener) {
        return Operations.scheduleJob(job, user, priority, jobChangeListener, null);
    }

    private static Job scheduleJob(Job job, boolean user, int priority, IJobChangeListener jobChangeListener, ISchedulingRule rule) {
        job.setUser(user);
        job.setPriority(priority);
        if (jobChangeListener != null) {
            job.addJobChangeListener(jobChangeListener);
        }
        job.setRule(rule);
        job.schedule();
        return job;
    }

    public static boolean areOperationsScheduled() {
        Job[] jobs = Job.getJobManager().find(OperationJob.class);
        return jobs != null && jobs.length > 0;
    }

    public static IStatus executeWork(IOperation operation, IProgressMonitor monitor) {
        IStatus status = null;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)operation.getName(), (int)Integer.MAX_VALUE);
            status = operation.run(subMonitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return status;
    }

    public static OperationBuilder createBuilder(String operationName) {
        return new OperationBuilderImpl(operationName);
    }

    public static OperationBuilder createBuilder(String name, IOperation operation, IOperation ... operations) {
        OperationBuilder builder = Operations.createBuilder(name);
        builder.addOp(operation);
        IOperation[] iOperationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            IOperation op = iOperationArray[n2];
            builder.addOp(op);
            ++n2;
        }
        return builder;
    }

    private static final class OperationJob
    extends Job {
        private final IOperation operation;

        public OperationJob(IOperation operation) {
            super(operation.getName());
            this.operation = operation;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return Operations.executeWork(this.operation, monitor);
        }

        public boolean belongsTo(Object family) {
            return OperationJob.class.equals(family);
        }
    }
}

