/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;
import org.eclipse.osee.orcs.db.internal.proxy.UriDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.VarCharDataProxy;

public class AttributeDataProxyFactory {
    private final IResourceManager resourceManager;
    private final Log logger;

    public AttributeDataProxyFactory(IResourceManager resourceManager, Log logger) {
        this.resourceManager = resourceManager;
        this.logger = logger;
    }

    public DataProxy createProxy(AttributeTypeToken attributeTypeToken, Object value, String uri) {
        Object checkedValue = this.intern(attributeTypeToken, value);
        AbstractDataProxy dataProxy = attributeTypeToken.isUri() ? new UriDataProxy() : new VarCharDataProxy();
        dataProxy.setLogger(this.logger);
        dataProxy.setStorage(new Storage(this.resourceManager, dataProxy));
        dataProxy.setData(checkedValue, uri);
        return dataProxy;
    }

    private Object intern(AttributeTypeToken attributeType, Object original) {
        Object value = original;
        if (attributeType.isEnumerated() && value instanceof String) {
            value = Strings.intern((String)((String)value));
        }
        return value;
    }
}

