/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.dsl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.SearchQueryBuilder;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.AttributeTypePredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.ExistenceTypePredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.GuidsPredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.IdsPredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.IsOfTypePredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.RelatedToPredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.TypeEqualsPredicateHandler;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;

public class DslFactory {
    private static SearchQueryBuilder builder;

    public static synchronized SearchQueryBuilder createQueryBuilder(OrcsApi orcsApi) {
        if (builder == null) {
            Map<SearchMethod, PredicateHandler> handlers = DslFactory.getHandlers();
            builder = new SearchQueryBuilder(orcsApi, handlers);
        }
        return builder;
    }

    public static Map<SearchMethod, PredicateHandler> getHandlers() {
        HashMap<SearchMethod, PredicateHandler> handlers = new HashMap<SearchMethod, PredicateHandler>();
        handlers.put(SearchMethod.IDS, new IdsPredicateHandler());
        handlers.put(SearchMethod.GUIDS, new GuidsPredicateHandler());
        handlers.put(SearchMethod.IS_OF_TYPE, new IsOfTypePredicateHandler());
        handlers.put(SearchMethod.TYPE_EQUALS, new TypeEqualsPredicateHandler());
        handlers.put(SearchMethod.EXISTS_TYPE, new ExistenceTypePredicateHandler());
        handlers.put(SearchMethod.NOT_EXISTS_TYPE, new ExistenceTypePredicateHandler());
        handlers.put(SearchMethod.ATTRIBUTE_TYPE, new AttributeTypePredicateHandler());
        handlers.put(SearchMethod.RELATED_TO, new RelatedToPredicateHandler());
        return handlers;
    }
}

