/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwApplicability;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttribute;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwBranch;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsWriterFactory {
    private final Pattern relTypePattern = Pattern.compile("\\[(.*)\\]-\\[(.*)\\]-\\[(.*)\\]-\\[(.*)\\]");
    private final Pattern nameIdPattern = Pattern.compile("\\[(.*)\\]-\\[(.*)\\]");
    private final Map<Long, OwArtifactType> idToArtType = new HashMap<Long, OwArtifactType>();
    private final Map<Long, OwArtifactToken> idToArtToken = new HashMap<Long, OwArtifactToken>();
    private final OwCollector collector;

    public OrcsWriterFactory(OwCollector collector) {
        this.collector = collector;
    }

    public OwArtifactToken getOrCreateToken(String value) {
        Long id;
        OwArtifactToken token = null;
        Matcher matcher = this.nameIdPattern.matcher(value);
        if (matcher.find() && (token = this.idToArtToken.get(id = Long.valueOf(matcher.group(2)))) == null) {
            token = new OwArtifactToken(id, matcher.group(1));
            token.setData(value);
            this.collector.getArtTokens().add(token);
            this.idToArtToken.put(id, token);
        }
        return token;
    }

    public OwArtifactType getOrCreateArtifactType(String value) {
        Long id;
        OwArtifactType artType = null;
        Matcher matcher = this.nameIdPattern.matcher(value);
        if (matcher.find() && (artType = this.idToArtType.get(id = Long.valueOf(matcher.group(2)))) == null) {
            artType = new OwArtifactType(id, matcher.group(1));
            artType.setData(value);
            this.collector.getArtTypes().add(artType);
            this.idToArtType.put(id, artType);
        }
        return artType;
    }

    public OwAttribute getOrCreateAttribute(OwArtifact artifact, OwAttributeType attrType) {
        OwAttribute attr = null;
        for (OwAttribute fAttr : artifact.getAttributes()) {
            if (fAttr.getType().getId() > 0L && fAttr.getType().getId().equals(attrType.getId())) {
                attr = fAttr;
                break;
            }
            if (!fAttr.getType().getName().equals(attrType.getName())) continue;
            attr = fAttr;
            break;
        }
        if (attr == null) {
            attr = new OwAttribute();
            attr.setType(attrType);
            artifact.getAttributes().add(attr);
        }
        return attr;
    }

    public OwApplicability getOrCreateApplicability(OwArtifact artifact) {
        OwApplicability app = artifact.getAppId();
        if (app == null) {
            app = new OwApplicability();
            artifact.setAppId(app);
        }
        return app;
    }

    public OwRelation createRelationType(OwRelationType relType, String value) {
        OwArtifactToken token = this.getOrCreateToken(value);
        OwRelation relation = new OwRelation();
        relation.setData(value);
        relation.setArtToken((ArtifactToken)token);
        relation.setType(relType);
        return relation;
    }

    public void processRelationType(OwRelationType relType, String value) {
        relType.setData(value);
        Matcher matcher = this.relTypePattern.matcher(value);
        if (matcher.find()) {
            relType.setName(matcher.group(1));
            relType.setSideName(matcher.group(2));
            relType.setSideA(matcher.group(3).contains("Side A"));
            relType.setId(Long.valueOf(matcher.group(4)));
        }
    }

    public void processAttributeType(OwAttributeType attrType, String value) {
        attrType.setData(value);
        Matcher matcher = this.nameIdPattern.matcher(value);
        if (matcher.find()) {
            attrType.setName(matcher.group(1));
            attrType.setId(Long.valueOf(matcher.group(2)));
        } else {
            attrType.setName(value);
        }
    }

    public OwBranch getOrCreateBranchToken(String value) {
        OwBranch branch = new OwBranch(Long.valueOf(0L), "");
        Matcher matcher = this.nameIdPattern.matcher(value);
        if (matcher.find()) {
            branch.setName(matcher.group(1));
            branch.setId(Long.valueOf(matcher.group(2)));
        }
        return branch;
    }
}

