/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.disposition.model.CiItemData;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.CopySetParams;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetData;
import org.eclipse.osee.disposition.model.DispoSetDescriptorData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.DispoQuery;
import org.eclipse.osee.disposition.rest.internal.DispoResolutionValidator;
import org.eclipse.osee.disposition.rest.internal.DispoWriter;
import org.eclipse.osee.disposition.rest.internal.OrcsStorageImpl;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.internal.importer.DispoImporterFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageAdapter;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class DispoApiImpl
implements DispoApi {
    private final Date newDate = new Date();
    private Storage storage;
    private ExecutorAdmin executor;
    private Log logger;
    private DispoDataFactory dataFactory;
    private DispoConnector dispoConnector;
    private DispoResolutionValidator resolutionValidator;
    private DispoImporterFactory importerFactory;
    private OrcsApi orcsApi;
    private volatile DispoApiConfiguration config;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public DispoApiConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(DispoApiConfiguration config) {
        this.config = config;
    }

    public void setExecutor(ExecutorAdmin executor) {
        this.executor = executor;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setDataFactory(DispoDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public void setDispoConnector(DispoConnector dispoConnector) {
        this.dispoConnector = dispoConnector;
    }

    public void setResolutionValidator(DispoResolutionValidator resolutionValidator) {
        this.resolutionValidator = resolutionValidator;
    }

    public void setStorageForTest(Storage storage) {
        this.storage = storage;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting DispoApiImpl...", new Object[0]);
        this.update(props);
        this.importerFactory = new DispoImporterFactory(this.dataFactory, this.executor, this.config, this.logger, this.orcsApi.jaxRsApi());
        this.storage = new OrcsStorageImpl(this.orcsApi);
    }

    public void update(Map<String, Object> props) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.setConfig(DispoApiConfiguration.newConfig(props));
    }

    public void stop() {
        this.logger.trace("Stopping DispoApiImpl...", new Object[0]);
    }

    private DispoQuery getQuery() {
        return this.storage;
    }

    private DispoWriter getWriter() {
        return this.storage;
    }

    @Override
    public Long createDispoProgram(String name, String userName) {
        UserId author = this.getQuery().findUserByName(userName);
        return this.getWriter().createDispoProgram(author, name);
    }

    @Override
    public ArtifactId createDispoSet(BranchId branch, DispoSetDescriptorData descriptor, String userName) {
        DispoSetData newSet = this.dataFactory.creteSetDataFromDescriptor(descriptor);
        UserId author = this.getQuery().findUserByName(userName);
        return this.getWriter().createDispoSet(author, branch, (DispoSet)newSet);
    }

    private void createDispoItems(BranchId branch, String setId, List<DispoItem> dispoItems, String userName) {
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, setId);
        if (parentSet != null) {
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().createDispoItems(author, branch, parentSet, dispoItems);
        }
    }

    @Override
    public String createDispoAnnotation(BranchId branch, String itemId, DispoAnnotationData annotationToCreate, String userName, boolean isCi) {
        String idOfNewAnnotation = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            this.dataFactory.initAnnotation(annotationToCreate);
            idOfNewAnnotation = this.dataFactory.getNewId();
            annotationToCreate.setId(idOfNewAnnotation);
            int indexOfAnnotation = annotationsList.size();
            annotationToCreate.setIndex(indexOfAnnotation);
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            this.dispoConnector.connectAnnotation(annotationToCreate, discrepanciesList);
            annotationsList.add(indexOfAnnotation, annotationToCreate);
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(annotationsList, discrepanciesList);
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), updatedItem);
        }
        return idOfNewAnnotation;
    }

    @Override
    public void editDispoSet(BranchId branch, String setId, DispoSetData newSet, String userName) {
        DispoSet dispSetToEdit = this.getQuery().findDispoSetsById(branch, setId);
        if (dispSetToEdit != null) {
            if (newSet.getOperation() != null) {
                this.runOperation(branch, dispSetToEdit, newSet, userName, false);
            } else {
                UserId author = this.getQuery().findUserByName(userName);
                this.getWriter().updateDispoSet(author, branch, (String)dispSetToEdit.getGuid(), (DispoSet)newSet);
            }
        }
    }

    @Override
    public void importAllDispoSets(BranchId branch, String filterState, String userName) {
        List<Object> dispoSets = new ArrayList();
        dispoSets = this.getDispoSets(branch, "codeCoverage");
        if (filterState.isEmpty()) {
            filterState = "None";
        }
        for (DispoSet dispoSet : dispoSets) {
            DispoSetData newSet = new DispoSetData();
            newSet.setOperation("Import");
            if (filterState.equalsIgnoreCase("All") || dispoSet.getImportState().equalsIgnoreCase(filterState)) {
                this.runOperation(branch, dispoSet, newSet, userName, true);
                continue;
            }
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoSet(author, branch, (String)dispoSet.getGuid(), (DispoSet)newSet);
        }
    }

    @Override
    public void importAllDispoPrograms(String filterState, String userName) {
        List<Object> dispoBranches = new ArrayList();
        dispoBranches = this.getDispoPrograms();
        for (BranchToken branchToken : dispoBranches) {
            this.importAllDispoSets((BranchId)branchToken, filterState, userName);
        }
    }

    @Override
    public boolean deleteDispoSet(BranchId branch, String setId, String userName) {
        UserId author = this.getQuery().findUserByName(userName);
        return this.getWriter().deleteDispoSet(author, branch, setId);
    }

    @Override
    public boolean editMassDispositions(BranchId branch, String setId, List<String> ids, String resolutionType, String resolution, String userName) {
        boolean wasUpdated = false;
        List<DispoItem> itemsToEdit = this.massDisposition(branch, setId, ids, resolutionType, resolution);
        if (itemsToEdit.size() > 0) {
            this.editDispoItems(branch, setId, itemsToEdit, true, "Import", userName);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean editDispoItem(BranchId branch, String itemId, DispoItemData newDispoItem, String userName, boolean assignUser) {
        boolean wasUpdated = false;
        DispoItem dispoItemToEdit = this.getQuery().findDispoItemById(branch, itemId);
        if (assignUser || dispoItemToEdit != null && newDispoItem.getAnnotationsList() == null && newDispoItem.getDiscrepanciesList() == null) {
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(author, branch, (String)dispoItemToEdit.getGuid(), (DispoItem)newDispoItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    private String getFullFilePathFromDispoItemId(BranchId branch, String itemId, DispoItem dispoItemToEdit) {
        DispoSet dispoSet;
        Conditions.notNull((Object[])new Object[]{dispoItemToEdit});
        Conditions.notNull((Object[])new Object[]{branch});
        Conditions.notNull((Object[])new Object[]{itemId});
        ArtifactId set = this.getQuery().getDispoItemParentSet(branch, itemId);
        if (set != null && (dispoSet = this.getQuery().findDispoSetsById(branch, set.getIdString())) != null) {
            String importPath = dispoSet.getImportPath();
            String name = dispoItemToEdit.getName().replaceAll(this.config.getFileExtRegex(), ".LIS");
            return String.valueOf(importPath) + File.separator + "vcast" + File.separator + name;
        }
        return "";
    }

    @Override
    public boolean massEditTeam(BranchId branch, String setId, List<String> itemNames, String team, String operation, String userName) {
        boolean wasUpdated = false;
        HashSet<DispoItem> dispoItems = new HashSet<DispoItem>();
        List<DispoItem> itemsFromSet = this.getDispoItems(branch, setId);
        HashMap<String, String> nameToId = new HashMap<String, String>();
        OperationReport report = new OperationReport();
        for (DispoItem item : itemsFromSet) {
            nameToId.put(item.getName(), (String)item.getGuid());
        }
        HashSet<String> itemsUpdated = new HashSet<String>();
        for (String name : itemNames) {
            String matchingItemId = (String)nameToId.get(name = name.trim());
            if (matchingItemId == null) {
                report.addEntry(name, "No existing item with this name for the selected set", DispoSummarySeverity.WARNING);
                continue;
            }
            itemsUpdated.add(name);
            DispoItemData newItem = new DispoItemData();
            newItem.setGuid(matchingItemId);
            newItem.setTeam(team);
            dispoItems.add((DispoItem)newItem);
        }
        if (!itemsUpdated.isEmpty()) {
            report.addEntry(team, String.format("Team Applied to %s of %s items", itemsUpdated.size(), itemNames.size()), DispoSummarySeverity.UPDATE);
            if (itemsUpdated.size() != itemNames.size()) {
                HashSet<String> uniqueNames = new HashSet<String>(itemNames);
                itemNames.removeAll(uniqueNames);
                if (!itemNames.isEmpty()) {
                    String duplicatesAsString = Collections.toString((String)", ", itemNames);
                    report.addEntry(team, String.format("There were %s duplciates: %s", itemNames.size(), duplicatesAsString), DispoSummarySeverity.WARNING);
                }
            }
            this.editDispoItems(branch, setId, dispoItems, false, operation, userName);
        } else {
            report.addEntry("Womp womp womp", "No items were updated. Please check your 'Items' list and make sure it's a comma seperated list of item names", DispoSummarySeverity.ERROR);
        }
        UserId author = this.getQuery().findUserByName(userName);
        this.getWriter().updateOperationSummary(author, branch, setId, report);
        return wasUpdated;
    }

    private void editDispoItems(BranchId branch, String setId, Collection<DispoItem> dispoItems, boolean resetRerunFlag, String operation, String userName) {
        UserId author = this.getQuery().findUserByName(userName);
        this.getWriter().updateDispoItems(author, branch, dispoItems, resetRerunFlag, operation);
    }

    @Override
    public boolean deleteDispoItem(BranchId branch, String itemId, String userName) {
        UserId author = this.getQuery().findUserByName(userName);
        return this.getWriter().deleteDispoItem(author, branch, itemId);
    }

    @Override
    public boolean editDispoAnnotation(BranchId branch, String itemId, String annotationId, DispoAnnotationData newAnnotation, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            boolean isResolutionChange;
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData origAnnotation = DispoUtil.getById(annotationsList, annotationId);
            int indexOfAnnotation = origAnnotation.getIndex();
            boolean needToReconnect = false;
            String newLocationRefs = newAnnotation.getLocationRefs();
            String newResolution = newAnnotation.getResolution();
            String newResolutionType = newAnnotation.getResolutionType();
            boolean isTypeChange = !origAnnotation.getResolutionType().equals(newResolutionType);
            boolean bl = isResolutionChange = !origAnnotation.getResolution().equals(newResolution);
            if (isTypeChange || isResolutionChange) {
                needToReconnect = true;
                this.resolutionValidator.validate(newAnnotation);
            }
            if (!origAnnotation.getLocationRefs().equals(newLocationRefs)) {
                needToReconnect = true;
            }
            if (needToReconnect) {
                newAnnotation.disconnect();
                this.dispoConnector.connectAnnotation(newAnnotation, discrepanciesList);
            }
            annotationsList.set(indexOfAnnotation, newAnnotation);
            UserId author = this.getQuery().findUserByName(userName);
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setAnnotationsList(annotationsList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteDispoAnnotation(BranchId branch, String itemId, String annotationId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData annotationToRemove = DispoUtil.getById(annotationsList, annotationId);
            annotationToRemove.disconnect();
            List<DispoAnnotationData> newAnnotationsList = this.removeAnnotationFromList(annotationsList, annotationToRemove.getIndex());
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(newAnnotationsList, discrepanciesList);
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), updatedItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteAllDispoAnnotation(BranchId branch, String itemId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                annotation.disconnect();
            }
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(new ArrayList<DispoAnnotationData>(), discrepanciesList);
            UserId author = this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), updatedItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public List<BranchToken> getDispoPrograms() {
        return this.getQuery().getDispoBranches();
    }

    @Override
    public BranchToken getDispoProgramIdByName(String branchName) {
        return this.getQuery().findDispoProgramIdByName(branchName);
    }

    @Override
    public List<DispoSet> getDispoSets(BranchId branch, String type) {
        return this.getQuery().findDispoSets(branch, type);
    }

    @Override
    public DispoSet getDispoSetById(BranchId branch, String setId) {
        return this.getQuery().findDispoSetsById(branch, setId);
    }

    @Override
    public String getDispoSetIdByName(BranchId branchId, String setName) {
        return this.getQuery().findDispoSetIdByName(branchId, setName);
    }

    @Override
    public List<DispoItem> getDispoItems(BranchId branch, String setArtId, boolean isDetailed) {
        return this.getQuery().findDispoItems(branch, setArtId, isDetailed);
    }

    private List<DispoItem> getDispoItems(BranchId branch, String setArtId) {
        return this.getDispoItems(branch, setArtId, true);
    }

    @Override
    public DispoItem getDispoItemById(BranchId branch, String itemId) {
        return this.getQuery().findDispoItemById(branch, itemId);
    }

    @Override
    public String getDispoItemIdByName(BranchId branchId, String setId, String itemName) {
        return this.getQuery().findDispoItemIdByName(branchId, setId, itemName);
    }

    @Override
    public Collection<DispoItem> getDispoItemByAnnotationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        return this.getQuery().findDispoItemByAnnoationText(branch, setId, keyword, isDetailed);
    }

    @Override
    public List<DispoAnnotationData> getDispoAnnotations(BranchId branch, String itemId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        return dispoItem.getAnnotationsList();
    }

    @Override
    public List<DispoAnnotationData> getDispoAnnotationsByType(Iterable<DispoAnnotationData> annotationData, String resolutionType) {
        ArrayList<DispoAnnotationData> resolutionTypeAnnotations = new ArrayList<DispoAnnotationData>();
        for (DispoAnnotationData dad : annotationData) {
            if (!dad.getResolutionType().equals(resolutionType)) continue;
            resolutionTypeAnnotations.add(dad);
        }
        return resolutionTypeAnnotations;
    }

    @Override
    public List<String> getCheckedReruns(BranchId branch, String setId) {
        DispoSet set = this.getDispoSetById(branch, setId);
        HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, set);
        return this.getQuery().getCheckedReruns(nameToItemMap, setId);
    }

    @Override
    public DispoAnnotationData getDispoAnnotationById(BranchId branch, String itemId, String annotationId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        List annotationsList = dispoItem.getAnnotationsList();
        return DispoUtil.getById(annotationsList, annotationId);
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        return this.getQuery().isUniqueProgramName(name);
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        return this.getQuery().isUniqueItemName(branch, setId, name);
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        return this.getQuery().isUniqueSetName(branch, name);
    }

    private void runOperation(BranchId branch, DispoSet setToEdit, DispoSetData newSet, String userName, boolean isIterative) {
        OperationReport report = new OperationReport();
        String operation = newSet.getOperation();
        UserId author = this.getQuery().findUserByName(userName);
        if (operation.equals("Import")) {
            try {
                HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, setToEdit);
                DispoImporterApi importer = setToEdit.getDispoType().equalsIgnoreCase("codeCoverage") ? this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.LIS, this.dispoConnector) : this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.TMO, this.dispoConnector);
                File importFile = new File(setToEdit.getImportPath());
                boolean pathExists = this.checkIfPathExists(importFile, report);
                List<DispoItem> itemsFromParse = importer.importDirectory(nameToItemMap, importFile, report);
                if (pathExists && itemsFromParse.isEmpty()) {
                    report.addEntry(setToEdit.getImportPath(), "No file(s) found", DispoSummarySeverity.IGNORE);
                } else {
                    report.addEntry("INFO", "CI Set: " + setToEdit.getCiSet(), DispoSummarySeverity.IGNORE);
                    report.addEntry("INFO", "Dispo Type: " + setToEdit.getDispoType(), DispoSummarySeverity.IGNORE);
                    report.addEntry("INFO", "Import State: " + setToEdit.getImportState(), DispoSummarySeverity.IGNORE);
                }
                ArrayList<DispoItem> itemsToCreate = new ArrayList<DispoItem>();
                ArrayList<DispoItem> itemsToEdit = new ArrayList<DispoItem>();
                for (DispoItem item : itemsFromParse) {
                    if (item.getGuid() == null) {
                        itemsToCreate.add(item);
                        report.addEntry(item.getName(), "", DispoSummarySeverity.NEW);
                        continue;
                    }
                    itemsToEdit.add(item);
                }
                if (!report.getStatus().isFailed()) {
                    if (itemsToCreate.size() > 0) {
                        this.createDispoItems(branch, (String)setToEdit.getGuid(), itemsToCreate, userName);
                    }
                    if (itemsToEdit.size() > 0) {
                        this.editDispoItems(branch, (String)setToEdit.getGuid(), itemsToEdit, true, "Import", userName);
                    }
                }
            }
            catch (Exception ex) {
                if (isIterative) {
                    return;
                }
                throw new OseeCoreException((Throwable)ex);
            }
        }
        List notesList = setToEdit.getNotesList();
        Note genOpNotes = this.generateOperationNotes(operation);
        notesList.add(this.generateOperationNotes("Import"));
        notesList.add(genOpNotes);
        newSet.setNotesList(notesList);
        this.newDate.setTime(System.currentTimeMillis());
        newSet.setTime(this.newDate);
        this.getWriter().updateOperationSummary(author, branch, (String)setToEdit.getGuid(), report);
        this.getWriter().updateDispoSet(author, branch, (String)setToEdit.getGuid(), (DispoSet)newSet);
    }

    private boolean checkIfPathExists(File file, OperationReport report) {
        boolean ret = true;
        if (!file.canRead()) {
            report.addEntry(file.getAbsolutePath(), "No Read Access", DispoSummarySeverity.IGNORE);
        }
        if (!file.canWrite()) {
            report.addEntry(file.getAbsolutePath(), "No Write Access", DispoSummarySeverity.IGNORE);
        }
        if (!file.exists() && !file.isDirectory()) {
            ret = false;
            boolean isRealPath = false;
            String filePath = file.getAbsolutePath();
            while (!isRealPath && filePath.contains(File.separator)) {
                int end = filePath.lastIndexOf(File.separator);
                StringBuilder pathName = new StringBuilder();
                pathName.append(filePath.substring(0, end));
                filePath = pathName.toString();
                if (!new File(filePath).isDirectory()) continue;
                isRealPath = true;
            }
            if (isRealPath) {
                report.addEntry(file.getAbsolutePath(), "No file or directory was found. Closest path found at: " + filePath, DispoSummarySeverity.IGNORE);
            } else {
                report.addEntry(file.getAbsolutePath(), "No file or directory was found.", DispoSummarySeverity.IGNORE);
            }
        } else {
            report.addEntry(file.getAbsolutePath(), "The Import Path/File Does Exist", DispoSummarySeverity.IGNORE);
        }
        return ret;
    }

    private List<DispoItem> massDisposition(BranchId branch, String setId, List<String> itemIds, String resolutionType, String resolution) {
        ArrayList<DispoItem> toEdit = new ArrayList<DispoItem>();
        List<DispoItem> allItemsInSet = this.getDispoItems(branch, setId);
        for (DispoItem item : allItemsInSet) {
            if (!itemIds.contains(item.getGuid())) continue;
            DispoItemData newItem = new DispoItemData();
            newItem.setGuid((String)item.getGuid());
            newItem.setName(item.getName());
            List<DispoAnnotationData> newAnnotations = new ArrayList();
            newAnnotations = item.getAnnotationsList();
            for (DispoAnnotationData annotation : item.getAnnotationsList()) {
                if (!annotation.getResolution().equals("")) continue;
                annotation.setResolutionType(resolutionType);
                annotation.setResolution(resolution);
                annotation.setLastResolution("N/A");
                annotation.setIsResolutionValid(true);
                annotation.setIsConnected(true);
                annotation.setIsDefault(false);
                this.dispoConnector.connectAnnotation(annotation, item.getDiscrepanciesList());
                newAnnotations.set(annotation.getIndex(), annotation);
            }
            newItem.setAnnotationsList(newAnnotations);
            newItem.setDiscrepanciesList(item.getDiscrepanciesList());
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            toEdit.add((DispoItem)newItem);
        }
        return toEdit;
    }

    private HashMap<String, DispoItem> getItemsMap(BranchId branch, DispoSet set) {
        HashMap<String, DispoItem> toReturn = new HashMap<String, DispoItem>();
        List<DispoItem> dispoItems = this.getDispoItems(branch, (String)set.getGuid());
        for (DispoItem item : dispoItems) {
            toReturn.put(item.getName(), item);
        }
        return toReturn;
    }

    private Note generateOperationNotes(String operation) {
        Note operationNote = new Note();
        this.newDate.setTime(System.currentTimeMillis());
        operationNote.setDateString(this.newDate.toString());
        operationNote.setType("SYSTEM");
        operationNote.setContent(operation);
        return operationNote;
    }

    private List<DispoAnnotationData> removeAnnotationFromList(List<DispoAnnotationData> oldList, int indexRemoved) {
        ArrayList<DispoAnnotationData> newList = new ArrayList<DispoAnnotationData>();
        oldList.remove(indexRemoved);
        int newIndex = 0;
        for (DispoAnnotationData annotation : oldList) {
            annotation.setIndex(newIndex);
            newList.add(newIndex, annotation);
            ++newIndex;
        }
        return newList;
    }

    @Override
    public void copyDispoSetCoverage(BranchId sourceBranch, Long sourceCoverageUuid, BranchId destBranch, String destSetId, CopySetParams params, String userName) {
        Map<String, ArtifactReadable> coverageUnits = this.getQuery().getCoverageUnits(sourceBranch, sourceCoverageUuid);
        List<DispoItem> destItems = this.getDispoItems(destBranch, destSetId);
        OperationReport report = new OperationReport();
        CoverageAdapter coverageAdapter = new CoverageAdapter(this.dispoConnector);
        List<DispoItem> copyData = coverageAdapter.copyData(coverageUnits, destItems, report);
        String operation = String.format("Copy From Legacy Coverage - Branch [%s] and Source Set [%s]", sourceBranch, sourceCoverageUuid);
        if (!copyData.isEmpty()) {
            this.editDispoItems(destBranch, destSetId, copyData, false, operation, userName);
            this.storage.updateOperationSummary(this.getQuery().findUser(), destBranch, destSetId, report);
        }
    }

    @Override
    public void copyDispoSet(BranchId branch, String destSetId, BranchId sourceBranch, String sourceSetId, CopySetParams params, String userName) {
        DispoConfig dispoConfig = this.getDispoConfig(branch);
        HashSet<String> validResolutions = new HashSet<String>();
        dispoConfig.getValidResolutions().forEach(res -> validResolutions.add(res.getValue()));
        List<DispoItem> sourceItems = this.getDispoItems(sourceBranch, sourceSetId);
        HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
        for (DispoItem itemArt : this.getDispoItems(branch, destSetId)) {
            DispoItemData itemData = DispoUtil.itemArtToItemData(itemArt, true, true);
            String name = itemData.getName();
            Set itemsWithSameName = (Set)namesToDestItems.get(name);
            if (itemsWithSameName == null) {
                HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                set.add(itemData);
                namesToDestItems.put(name, set);
                continue;
            }
            itemsWithSameName.add(itemData);
            namesToDestItems.put(name, itemsWithSameName);
        }
        HashMap<String, String> reruns = new HashMap<String, String>();
        HashMap<String, DispoItem> namesToToEditItems = new HashMap<String, DispoItem>();
        OperationReport report = new OperationReport();
        DispoSetCopier copier = new DispoSetCopier(this.dispoConnector);
        if (!params.getAnnotationParam().isNone()) {
            List<DispoItem> copyResults = copier.copyAllDispositions(namesToDestItems, sourceItems, true, reruns, params.getAllowOnlyValidResolutionTypes(), validResolutions, report);
            for (DispoItem item : copyResults) {
                namesToToEditItems.put(item.getName(), item);
            }
        }
        copier.copyCategories(namesToDestItems, sourceItems, namesToToEditItems, params.getCategoryParam());
        copier.copyAssignee(namesToDestItems, sourceItems, namesToToEditItems, params.getAssigneeParam());
        copier.copyNotes(namesToDestItems, sourceItems, namesToToEditItems, params.getNoteParam());
        String operation = String.format("Copy Set from Program [%s] and Set [%s]", sourceBranch, sourceSetId);
        if (!namesToToEditItems.isEmpty() && !report.getStatus().isFailed()) {
            this.editDispoItems(branch, destSetId, namesToToEditItems.values(), false, operation, userName);
            this.storage.updateOperationSummary(this.getQuery().findUser(), branch, destSetId, report);
        }
        this.storeRerunData(branch, destSetId, reruns);
    }

    private void storeRerunData(BranchId branch, String destSetId, HashMap<String, String> reruns) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : reruns.entrySet()) {
            sb = sb.append("\t\t<ScriptEntry>\n");
            sb = sb.append(String.format("\t\t\t<Name>%s</Name>\n", entry.getKey()));
            sb = sb.append(String.format("\t\t\t<Path>%s</Path>\n", entry.getValue()));
            sb = sb.append("\t\t\t<IsRunnable>true</IsRunnable>\n");
            sb = sb.append("\t\t</ScriptEntry>\n");
        }
        DispoSetData dispoSetData = new DispoSetData();
        this.newDate.setTime(System.currentTimeMillis());
        dispoSetData.setTime(this.newDate);
        dispoSetData.setRerunList("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TestManagerConfig>\n\t<ScriptPageConfig>\n\t\t<ServicesSettings/>\n" + sb.toString() + "\t</ScriptPageConfig>\n</TestManagerConfig>");
        UserId author = this.getQuery().findUser();
        this.storage.updateDispoSet(author, branch, destSetId, (DispoSet)dispoSetData);
    }

    @Override
    public DispoConfig getDispoConfig(BranchId branch) {
        return this.getQuery().findDispoConfig(branch);
    }

    @Override
    public DispoSet getDispoItemParentSet(BranchId branch, String itemId) {
        ArtifactId id = this.getQuery().getDispoItemParentSet(branch, itemId);
        return this.getDispoSetById(branch, id.getIdString());
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        return this.getQuery().getCiSet(setData);
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        return this.getQuery().getDispoItemId(branch, setId, item);
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        return this.getQuery().getAllCiSets();
    }

    @Override
    public String createDispoDiscrepancy(BranchId branch, String itemId, Discrepancy discrepancy, String userName) {
        String idOfNewDiscrepancy = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            idOfNewDiscrepancy = this.dataFactory.getNewId();
            discrepancy.setId(idOfNewDiscrepancy);
            if (discrepancy.getLocation() == null) {
                discrepancy.setLocation("");
            }
            if (discrepancy.getText() == null) {
                discrepancy.setText("");
            }
            discrepancyList.put(idOfNewDiscrepancy, discrepancy);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepancyList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            UserId author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)newItem);
        }
        return idOfNewDiscrepancy;
    }

    @Override
    public void createDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            ArrayList<DispoItem> dispoItems = new ArrayList<DispoItem>();
            for (Discrepancy discrepancy : discrepancies) {
                String idOfNewDiscrepancy = "";
                idOfNewDiscrepancy = this.dataFactory.getNewId();
                discrepancy.setId(idOfNewDiscrepancy);
                if (discrepancy.getLocation() == null) {
                    discrepancy.setLocation("");
                }
                if (discrepancy.getText() == null) {
                    discrepancy.setText("");
                }
                discrepancyList.put(idOfNewDiscrepancy, discrepancy);
                DispoItemData newItem = new DispoItemData();
                newItem.setDiscrepanciesList(discrepancyList);
                newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
                dispoItems.add((DispoItem)newItem);
            }
            UserId author = this.getQuery().findUser();
            String operation = String.format("Create Dispo Discrepancies in Program [%s], Item [%s]", branch, itemId);
            this.getWriter().updateDispoItems(author, branch, dispoItems, false, operation);
        }
    }

    @Override
    public boolean editDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, Discrepancy newDiscrepancy, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.put(discrepancyId, newDiscrepancy);
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            UserId author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public void editDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            for (Discrepancy discrepancy : discrepancies) {
                discrepanciesList.put(discrepancy.getId(), discrepancy);
            }
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            UserId author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
        }
    }

    @Override
    public boolean deleteDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.remove(discrepancyId);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepanciesList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            UserId author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)newItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public String createDispoItem(BranchId branch, CiItemData data, String userName) {
        DispoItemData dispoItemData = new DispoItemData();
        dispoItemData.setName(data.getScriptName());
        dispoItemData.setGuid(this.dataFactory.getNewId());
        dispoItemData.setDiscrepanciesAsRanges(data.getTestPoints().getFail());
        dispoItemData.setDiscrepanciesList(new HashMap());
        dispoItemData.setAnnotationsList(data.getAnnotations());
        UserId author = this.getQuery().findUser();
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, data.getSetData().getDispoSetId());
        if (parentSet != null) {
            this.getWriter().createDispoItem(author, branch, parentSet, (DispoItem)dispoItemData);
        }
        return dispoItemData.getGuid();
    }
}

