/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.framework.core.data.BranchId;

public class AnnotationResource {
    private final DispoApi dispoApi;
    private final BranchId branch;
    private final String itemId;

    public AnnotationResource(DispoApi dispoApi, BranchId branch, String setUuid, String dispResourceId) {
        this.dispoApi = dispoApi;
        this.branch = branch;
        this.itemId = dispResourceId;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response postDispoAnnotation(DispoAnnotationData annotation, @QueryParam(value="userName") String userName) {
        Response response;
        if (!annotation.getLocationRefs().isEmpty()) {
            DispoAnnotationData createdAnnotation;
            Response.Status status;
            String createdAnnotationId = this.dispoApi.createDispoAnnotation(this.branch, this.itemId, annotation, userName, false);
            if (!createdAnnotationId.equals("")) {
                status = Response.Status.CREATED;
                createdAnnotation = this.dispoApi.getDispoAnnotationById(this.branch, this.itemId, createdAnnotationId);
            } else {
                status = Response.Status.NOT_ACCEPTABLE;
                createdAnnotation = null;
            }
            response = Response.status((Response.Status)status).entity(createdAnnotation).build();
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Annotation must have a valid location reference").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<DispoAnnotationData> getAllDispoAnnotations() {
        return this.dispoApi.getDispoAnnotations(this.branch, this.itemId);
    }

    @Path(value="resolutionType/{resolutionType}")
    @GET
    @Produces(value={"application/json"})
    public Iterable<DispoAnnotationData> getAllDispoAnnotationsByType(@PathParam(value="resolutionType") String resolutionType) {
        List<DispoAnnotationData> annotationData = this.dispoApi.getDispoAnnotations(this.branch, this.itemId);
        return this.dispoApi.getDispoAnnotationsByType(annotationData, resolutionType);
    }

    @Path(value="{annotationId}")
    @GET
    @Produces(value={"application/json"})
    public DispoAnnotationData getAnnotationByIdJson(@PathParam(value="annotationId") String annotationId) {
        return this.dispoApi.getDispoAnnotationById(this.branch, this.itemId, annotationId);
    }

    @Path(value="{annotationId}")
    @PUT
    @Consumes(value={"application/json"})
    public Response putDispoAnnotation(@PathParam(value="annotationId") String annotationId, DispoAnnotationData newAnnotation, @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.editDispoAnnotation(this.branch, this.itemId, annotationId, newAnnotation, userName, false);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        return response;
    }

    @Path(value="{annotationId}")
    @DELETE
    public Response deleteDispoAnnotation(@PathParam(value="annotationId") String annotationId, @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.deleteDispoAnnotation(this.branch, this.itemId, annotationId, userName, false);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        return response;
    }
}

