/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.logger.Log;

public abstract class AbstractDatabaseStorage<T> {
    private final Log logger;
    private final JdbcClient jdbcClient;

    public AbstractDatabaseStorage(Log logger, JdbcClient jdbcClient) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
    }

    protected Object asVarcharOrNull(String value) {
        return value != null ? value : SQL3DataType.VARCHAR;
    }

    protected abstract Object[] asInsert(T var1);

    protected abstract Object[] asUpdate(T var1);

    protected abstract Object[] asDelete(T var1);

    protected abstract T readData(JdbcStatement var1);

    protected <R> R execute(Callable<R> callable) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    protected T selectOneOrNull(String query, Object ... data) {
        return (T)this.execute(this.select(query, data)).getOneOrNull();
    }

    protected ResultSet<T> selectItems(String query, Object ... data) {
        return this.execute(this.select(query, data));
    }

    protected void insertItems(String insertSql, T ... items) {
        this.insertItems(insertSql, (Iterable<T>)Arrays.asList(items));
    }

    protected void insertItems(String insertSql, Iterable<T> items) {
        this.execute(this.insert(insertSql, items));
    }

    protected void deleteItems(String deleteSql, T ... items) {
        this.deleteItems(deleteSql, (Iterable<T>)Arrays.asList(items));
    }

    protected void deleteItems(String deleteSql, Iterable<T> items) {
        this.execute(this.delete(deleteSql, items));
    }

    protected void updateItems(String insertSql, T ... items) {
        this.updateItems(insertSql, (Iterable<T>)Arrays.asList(items));
    }

    protected void updateItems(String updateSql, Iterable<T> items) {
        this.execute(this.update(updateSql, items));
    }

    protected long countItems(String countSql, Object ... data) {
        return this.execute(this.count(countSql, data));
    }

    private Callable<ResultSet<T>> select(String query, Object ... data) {
        return new AbstractCallable<Object[], ResultSet<T>>(this, query, data){

            @Override
            protected ResultSet<T> innerCall() throws Exception {
                LinkedList list = new LinkedList();
                this.getJdbcClient().runQuery(stmt -> {
                    Object data = this.readData((JdbcStatement)stmt);
                    list.add(data);
                }, this.query, (Object[])this.data);
                return ResultSets.newResultSet(list);
            }
        };
    }

    private Callable<Long> count(String query, Object ... data) {
        return new AbstractCallable<Object[], Long>(this, query, data){

            @Override
            protected Long innerCall() throws Exception {
                return (Long)jdbcClient.fetch((Object)-1L, this.query, (Object[])this.data);
            }
        };
    }

    private Callable<Integer> insert(final String insertSql, final Iterable<T> items) {
        return new AbstractCallable<Iterable<T>, Integer>(this, insertSql, items){

            @Override
            protected Integer innerCall() throws Exception {
                ArrayList<Object[]> data = new ArrayList<Object[]>();
                for (Object item : items) {
                    data.add(this.asInsert(item));
                }
                return jdbcClient.runBatchUpdate(insertSql, data);
            }
        };
    }

    private Callable<Integer> delete(final String deleteSql, final Iterable<T> items) {
        return new AbstractCallable<Iterable<T>, Integer>(this, deleteSql, items){

            @Override
            protected Integer innerCall() throws Exception {
                ArrayList<Object[]> data = new ArrayList<Object[]>();
                for (Object item : items) {
                    data.add(this.asDelete(item));
                }
                return jdbcClient.runBatchUpdate(deleteSql, data);
            }
        };
    }

    private Callable<Integer> update(final String updateSql, final Iterable<T> items) {
        return new AbstractCallable<Iterable<T>, Integer>(this, updateSql, items){

            @Override
            protected Integer innerCall() throws Exception {
                ArrayList<Object[]> data = new ArrayList<Object[]>();
                for (Object item : items) {
                    data.add(this.asUpdate(item));
                }
                return jdbcClient.runBatchUpdate(updateSql, data);
            }
        };
    }

    protected abstract class AbstractCallable<I, O>
    implements Callable<O> {
        protected final String query;
        protected final I data;

        public AbstractCallable(String query, I data) {
            this.query = query;
            this.data = data;
        }

        protected JdbcClient getJdbcClient() {
            return AbstractDatabaseStorage.this.jdbcClient;
        }

        @Override
        public final O call() throws Exception {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            O result = null;
            try {
                if (AbstractDatabaseStorage.this.logger.isTraceEnabled()) {
                    AbstractDatabaseStorage.this.logger.trace("%s [start] - [%s] [%s]", new Object[]{this.getClass().getSimpleName(), this.query, this.data});
                }
                result = this.innerCall();
            }
            finally {
                endTime = System.currentTimeMillis() - startTime;
            }
            if (AbstractDatabaseStorage.this.logger.isTraceEnabled()) {
                AbstractDatabaseStorage.this.logger.trace("%s [finished] - [%s] [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.asTimeString((long)endTime), this.query, this.data});
            }
            return result;
        }

        protected abstract O innerCall() throws Exception;
    }
}

