/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.util.concurrent.Callable;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.branch.BranchOperationsUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public class AtsBranchCommitOperation {
    private final boolean overrideStateValidation;
    private final BranchId destinationBranch;
    private final IAtsTeamWorkflow teamWf;
    private XResultData rd;
    private final AtsApi atsApi;
    private final AtsUser asUser;
    private final OrcsApi orcsApi;

    public AtsBranchCommitOperation(AtsUser asUser, IAtsTeamWorkflow teamWf, AtsApi atsApi, OrcsApi orcsApi, boolean overrideStateValidation, BranchId destinationBranch, XResultData rd) {
        this.teamWf = teamWf;
        this.overrideStateValidation = overrideStateValidation;
        this.destinationBranch = destinationBranch;
        this.rd = rd;
        this.asUser = asUser;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public XResultData run() {
        if (this.rd == null) {
            this.rd = new XResultData();
        }
        BranchToken commitToBranch = ((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.destinationBranch)).getOneOrSentinel();
        BranchOperationsUtil.validateBranchCommit((IAtsTeamWorkflow)this.teamWf, (BranchToken)commitToBranch, (boolean)this.overrideStateValidation, (XResultData)this.rd, (AtsApi)this.atsApi);
        if (this.rd.isErrors()) {
            return this.rd;
        }
        if (!this.overrideStateValidation) {
            for (IAtsWorkItemHook item : this.atsApi.getWorkItemService().getWorkItemHooks()) {
                this.rd = item.committing(this.teamWf, this.rd);
                if (!this.rd.isErrors()) continue;
                return this.rd;
            }
        }
        BranchToken workingBranch = this.atsApi.getBranchService().getBranch(this.teamWf);
        try {
            this.rd.logf("Commiting Branch\n", new Object[0]);
            this.rd.logf("Source Branch [%s]\n", new Object[]{workingBranch});
            this.rd.logf("Destination Branch [%s]\n", new Object[]{commitToBranch});
            try {
                Callable op = this.orcsApi.getBranchOps().commitBranch((ArtifactId)this.asUser, (BranchId)workingBranch, (BranchId)commitToBranch);
                TransactionToken tx = (TransactionToken)op.call();
                this.rd.setTxId(tx.getIdString());
            }
            catch (Exception ex) {
                this.rd.errorf("Exception commiting branch [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
                return this.rd;
            }
        }
        catch (Exception ex) {
            this.rd.errorf("Exception committing branch %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.rd;
    }
}

