/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.server.application.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.core.util.HttpProcessor;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.server.application.internal.model.ServerStatus;
import org.eclipse.osee.server.application.internal.model.StatusKey;
import org.eclipse.osee.server.application.internal.operations.BuildServerStatusOperation;

@Path(value="/health")
public final class ServerHealthEndpointImpl {
    private final IApplicationServerManager applicationServerManager;
    private final Map<String, JdbcService> jdbcServices;
    private final IAuthenticationManager authManager;
    private final ActivityLog activityLog;
    private ObjectMapper mapper;
    private static final String GET_VALUE_SQL = "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?";

    public ServerHealthEndpointImpl(IApplicationServerManager applicationServerManager, Map<String, JdbcService> jdbcServices, IAuthenticationManager authManager, ActivityLog activityLog) {
        this.applicationServerManager = applicationServerManager;
        this.jdbcServices = jdbcServices;
        this.authManager = authManager;
        this.activityLog = activityLog;
    }

    @GET
    @Path(value="headers")
    @Produces(value={"text/html"})
    public String getAllHeaders(@Context HttpHeaders headers) {
        MultivaluedMap rh = headers.getRequestHeaders();
        return rh.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + " = " + e.getValue()).collect(Collectors.joining("<br/>"));
    }

    @Path(value="top")
    @GET
    @Produces(value={"text/html"})
    public String getTop() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Lib.isWindows()) {
            sb.append("Top is not available for windows");
        } else {
            ProcessBuilder pb = new ProcessBuilder("top", "-l", "1");
            pb.redirectError();
            Process p = pb.start();
            InputStream is = p.getInputStream();
            int value = -1;
            while ((value = is.read()) != -1) {
                sb.append((char)value);
            }
            int exitCode = p.waitFor();
            sb.append("Top exited with " + exitCode);
        }
        return sb.toString();
    }

    @Path(value="status")
    @GET
    @Produces(value={"application/json"})
    public ServerStatus serverStatus() {
        return new BuildServerStatusOperation(this.applicationServerManager, this.authManager, this.activityLog).get();
    }

    @Path(value="status/all")
    @GET
    @Produces(value={"text/html"})
    public String serverStatusAsll() {
        return this.serverStatusAsll(false);
    }

    @Path(value="status/all/detail")
    @GET
    @Produces(value={"text/html"})
    public String serverStatusAsllDetails() {
        return this.serverStatusAsll(true);
    }

    private String serverStatusAsll(boolean details) {
        String server;
        String serversStr = OseeInfo.getValue((JdbcClient)this.jdbcServices.values().iterator().next().getClient(), (String)"osee.health.servers");
        serversStr = serversStr.replaceAll(" ", "");
        ArrayList<String> servers = new ArrayList<String>();
        String[] stringArray = serversStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            server = stringArray[n2];
            servers.add(server);
            ++n2;
        }
        serversStr = this.getValue(this.jdbcServices.values().iterator().next().getClient(), "osee.health.servers");
        serversStr = serversStr.replaceAll(" ", "");
        stringArray = serversStr.split(",");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            server = stringArray[n2];
            servers.add(server);
            ++n2;
        }
        if (servers.size() == 0) {
            throw new IllegalStateException("No application.servers configured in osee.json file");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)2));
        LinkedList<String> headers = new LinkedList<String>();
        headers.add("Name");
        headers.add("Alive");
        StatusKey[] statusKeyArray = StatusKey.values();
        int n3 = statusKeyArray.length;
        int n4 = 0;
        while (n4 < n3) {
            StatusKey key = statusKeyArray[n4];
            if (details || !key.isDetails()) {
                headers.add(key.name());
            }
            ++n4;
        }
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        for (String server2 : servers) {
            this.addServer(sb, server2, details);
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }

    private ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        return this.mapper;
    }

    private void addServer(StringBuilder sb, String server, boolean details) {
        LinkedList<String> values = new LinkedList<String>();
        String statusUrl = "http://" + server + "/server/health/status";
        values.add(AHTML.getHyperlink((String)statusUrl, (String)server));
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            URL url = new URL(String.format("http://%s%s", server, "/server/health/status"));
            HttpProcessor.AcquireResult result = HttpProcessor.acquire((URL)url, (OutputStream)outputStream, (int)10000);
            if (result.wasSuccessful()) {
                values.add("Ok");
                String json = outputStream.toString(result.getEncoding());
                ServerStatus stat = (ServerStatus)this.getMapper().readValue(json, ServerStatus.class);
                StatusKey[] statusKeyArray = StatusKey.values();
                int n = statusKeyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StatusKey key = statusKeyArray[n2];
                    if (details || !key.isDetails()) {
                        String value = stat.get(key);
                        if (value == null) {
                            value = "";
                        }
                        values.add(value);
                    }
                    ++n2;
                }
            } else {
                values.add("Not successful: " + result.getResult());
            }
        }
        catch (Exception ex) {
            values.add("Exception: " + ex.getMessage());
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
    }

    private String getValue(JdbcClient jdbcClient, String key) {
        String toReturn = (String)jdbcClient.fetch((Object)"", GET_VALUE_SQL, new Object[]{key});
        return toReturn;
    }
}

