/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.InterfaceElementAccessor;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceElementApiImpl
implements InterfaceElementApi {
    private ArtifactAccessor<InterfaceStructureElementToken> accessor;
    private final InterfacePlatformTypeApi platformApi;
    private final List<AttributeTypeId> elementAttributeList;

    InterfaceElementApiImpl(OrcsApi orcsApi, InterfacePlatformTypeApi platformTypeApi) {
        this.setAccessor(new InterfaceElementAccessor(orcsApi));
        this.platformApi = platformTypeApi;
        this.elementAttributeList = this.createElementAttributeList();
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    private ArtifactAccessor<InterfaceStructureElementToken> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceStructureElementToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAll(branch, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public InterfaceStructureElementToken getRelated(BranchId branch, ArtifactId structureId, ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = this.getAccessor().getByRelation(branch, elementId, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, InterfaceStructureElementToken.class);
            element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL);
            return element;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        return this.defaultSetUpElement(branch, element, previousElement, PlatformTypeToken.SENTINEL);
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement, PlatformTypeToken defaultPlatformType) {
        try {
            PlatformTypeToken platformType = defaultPlatformType.isInvalid() ? this.platformApi.getAccessor().getByRelationWithoutId(branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class) : defaultPlatformType;
            if (previousElement.isInvalid()) {
                element.setBeginByte(0.0);
                element.setBeginWord(0.0);
            } else {
                element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
                element.setBeginWord(Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0));
            }
            element.setInterfacePlatformTypeBitSize(platformType.getInterfacePlatformTypeBitSize());
            element.setPlatformTypeId(platformType.getId());
            element.setPlatformTypeName(platformType.getName());
            element.setLogicalType(platformType.getInterfaceLogicalType() != null ? platformType.getInterfaceLogicalType() : "");
            element.setInterfacePlatformTypeMinval(platformType.getInterfacePlatformTypeMinval() != null ? platformType.getInterfacePlatformTypeMinval() : "");
            element.setInterfacePlatformTypeMaxval(platformType.getInterfacePlatformTypeMaxval() != null ? platformType.getInterfacePlatformTypeMaxval() : "");
            element.setInterfacePlatformTypeDefaultValue(platformType.getInterfacePlatformTypeDefaultValue() != null ? platformType.getInterfacePlatformTypeDefaultValue() : "");
            element.setUnits(platformType.getInterfacePlatformTypeUnits() != null ? platformType.getInterfacePlatformTypeUnits() : "");
            element.setInterfacePlatformTypeDescription(platformType.getDescription() != null ? platformType.getDescription() : "");
        }
        catch (Exception exception) {}
        return element;
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements) {
        return this.parseElements(branch, elements, PlatformTypeToken.SENTINEL);
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements, PlatformTypeToken defaultPlatformType) {
        Iterator<InterfaceStructureElementToken> elementIterator = elements.iterator();
        LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
        if (elements.size() >= 2) {
            InterfaceStructureElementToken previousElement = elementIterator.next();
            InterfaceStructureElementToken currentElement = elementIterator.next();
            this.defaultSetUpElement(branch, previousElement, InterfaceStructureElementToken.SENTINEL, defaultPlatformType);
            tempElements.add(previousElement);
            if (!elementIterator.hasNext()) {
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, defaultPlatformType);
            }
            while (elementIterator.hasNext()) {
                InterfaceStructureElementToken nextElement = elementIterator.next();
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, defaultPlatformType);
                tempElements.add(currentElement);
                previousElement = currentElement;
                currentElement = nextElement;
            }
            currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, defaultPlatformType);
            tempElements.add(currentElement);
            elements = tempElements;
        } else {
            for (InterfaceStructureElementToken element : elements) {
                element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL, defaultPlatformType);
            }
        }
        return elements;
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByFilter(branch, filter, this.elementAttributeList, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getElementsByType(BranchId branch, ArtifactId platformTypeId) {
        try {
            PlatformTypeToken platformType = this.platformApi.getAccessor().get(branch, platformTypeId, PlatformTypeToken.class);
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceElementPlatformType_PlatformType, platformTypeId, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements, platformType);
            return elements;
        }
        catch (Exception exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, filter, this.elementAttributeList, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }
}

