/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.define.api.importing.ReqNumbering;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class RoughToRealRectificationOperation {
    private final OrcsApi orcsApi;
    private final BranchId branchId;
    private final XResultData results;
    private final RoughArtifactCollector rawData;
    private final IArtifactImportResolver artifactResolver;
    private final Map<RoughArtifact, ArtifactReadable> roughToRealArtifacts;
    private final List<String> toRectify;
    private String candidateParent = "";
    private final ArtifactReadable destinationArtifact;
    private final TransactionBuilder transaction;
    private final Map<String, ArtifactToken> knownArtsByReqNum = new HashMap<String, ArtifactToken>();

    public RoughToRealRectificationOperation(OrcsApi orcsApi, BranchId branchId, XResultData results, TransactionBuilder transaction, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData, IArtifactImportResolver artifactResolver, boolean deleteUnmatchedArtifacts, String toRectify) {
        this.results = results;
        this.orcsApi = orcsApi;
        this.branchId = branchId;
        this.rawData = rawData;
        this.transaction = transaction;
        this.artifactResolver = artifactResolver;
        this.destinationArtifact = destinationArtifact;
        this.roughToRealArtifacts = new HashMap<RoughArtifact, ArtifactReadable>();
        this.toRectify = new ArrayList<String>(Arrays.asList(toRectify.split(",")));
        this.roughToRealArtifacts.put(rawData.getParentRoughArtifact(), this.destinationArtifact);
    }

    public RoughToRealRectificationOperation(OrcsApi orcsApi, BranchId branchId, XResultData results, TransactionBuilder transaction, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData, IArtifactImportResolver artifactResolver, boolean deleteUnmatchedArtifacts) {
        this.results = results;
        this.orcsApi = orcsApi;
        this.branchId = branchId;
        this.rawData = rawData;
        this.transaction = transaction;
        this.artifactResolver = artifactResolver;
        this.destinationArtifact = destinationArtifact;
        this.roughToRealArtifacts = new HashMap<RoughArtifact, ArtifactReadable>();
        this.toRectify = new ArrayList<String>();
        this.roughToRealArtifacts.put(rawData.getParentRoughArtifact(), this.destinationArtifact);
    }

    public void doWork() {
        this.setupAllKnownArtifacts();
        for (String doorsIdToImport : this.toRectify) {
            RoughArtifact roughArtifact;
            if (this.modExists(doorsIdToImport) || (roughArtifact = this.getArtFromImported(doorsIdToImport)) == null) continue;
            ArtifactToken parent = this.findParentArtifact(roughArtifact, this.branchId);
            if (parent == null) {
                this.results.errorf("no parent found for %s", new Object[]{roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName())});
                return;
            }
            ArtifactToken newParent = parent;
            if (!parent.getName().equals(this.candidateParent)) {
                newParent = this.transaction.createArtifact(CoreArtifactTypes.HeadingMsWord, "Orphan Parent");
                this.transaction.setSoleAttributeFromString((ArtifactId)newParent, (AttributeTypeToken)CoreAttributeTypes.DoorsHierarchy, this.candidateParent);
                this.transaction.relate((ArtifactId)parent, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)newParent);
                String toAdd = this.candidateParent.replace("-", ".");
                this.knownArtsByReqNum.put(toAdd, ArtifactToken.valueOf((ArtifactId)newParent, (String)toAdd));
            }
            ArtifactId art = this.artifactResolver.resolve(roughArtifact, this.branchId, (ArtifactId)newParent, (ArtifactId)newParent);
            String addedArtReqNum = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName()).replace("-", ".");
            this.knownArtsByReqNum.put(addedArtReqNum, ArtifactToken.valueOf((ArtifactId)art, (String)addedArtReqNum));
            if (art != null) continue;
            this.results.errorf("Artifact %s with Doors ID %s not found", new Object[]{roughArtifact.getName(), roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName())});
        }
    }

    private boolean modExists(String doorsId) {
        for (RoughArtifact roughArtifact : this.rawData.getRoughArtifacts()) {
            String modded;
            if (!doorsId.equals(roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName())) || !Strings.isValid((String)(modded = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsModId.getName())))) continue;
            this.results.errorf("found modded id %s for %s", new Object[]{modded, doorsId});
            return true;
        }
        return false;
    }

    private RoughArtifact getArtFromImported(String doorsId) {
        for (RoughArtifact roughArtifact : this.rawData.getRoughArtifacts()) {
            if (!doorsId.equals(roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName()))) continue;
            return roughArtifact;
        }
        this.results.errorf("DoorsId %s not found in import", new Object[]{doorsId});
        return null;
    }

    private void setupAllKnownArtifacts() {
        List known = this.orcsApi.getQueryFactory().fromBranch(this.branchId).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)this.destinationArtifact).asArtifactTokens((AttributeTypeToken)CoreAttributeTypes.DoorsHierarchy);
        known.forEach(item -> {
            ArtifactToken artifactToken = this.knownArtsByReqNum.put(item.getName().replace("-", "."), (ArtifactToken)item);
        });
    }

    private ArtifactToken findParentArtifact(RoughArtifact roughArtifact, BranchId branch) {
        String currentParent;
        String doorsHierarchy = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName());
        ReqNumbering reqNumber = new ReqNumbering(doorsHierarchy, true);
        this.candidateParent = currentParent = reqNumber.getParentString();
        ArtifactToken foundParent = this.knownArtsByReqNum.get(currentParent);
        while (foundParent == null && reqNumber.getLength() > 1) {
            this.candidateParent = currentParent;
            reqNumber = new ReqNumbering(currentParent);
            currentParent = reqNumber.getParentString();
            if (reqNumber.getLength() < 2) {
                this.results.errorf("Parent String %s not found correctly", new Object[]{this.candidateParent});
                break;
            }
            foundParent = this.knownArtsByReqNum.get(currentParent);
        }
        return foundParent;
    }
}

