/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.LdapUserDetailsWrapper;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.icteam.web.rest.layer.util.LdapUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.UserUtility;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="Users")
public class UsersResource
extends AbstractConfigResource {
    public UsersResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(CoreArtifactTypes.User, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getLdapUsers")
    public String getLdapUsers(String user) {
        List<LdapUserDetailsWrapper> ldapSearchResult = LdapUtil.getLDAPSearchResult(user);
        TransferableArtifactsContainer artContainer = new TransferableArtifactsContainer();
        ArrayList<TransferableArtifact> list = new ArrayList<TransferableArtifact>();
        for (LdapUserDetailsWrapper ldapUserDetailsWrapper : ldapSearchResult) {
            String displayName = ldapUserDetailsWrapper.getDisplayName();
            String userId = ldapUserDetailsWrapper.getUserId();
            if (userId == null) continue;
            userId = userId.toLowerCase();
            String mail = ldapUserDetailsWrapper.getMail();
            TransferableArtifact ar = new TransferableArtifact();
            ArrayList<String> userIdList = new ArrayList<String>();
            userIdList.add(userId);
            ArrayList<String> displayNameList = new ArrayList<String>();
            displayNameList.add(displayName);
            ArrayList<String> mailList = new ArrayList<String>();
            mailList.add(mail);
            ar.putAttributes(CoreAttributeTypes.UserId.toString(), userIdList);
            ar.putAttributes(CoreAttributeTypes.Name.toString(), displayNameList);
            ar.putAttributes(CoreAttributeTypes.Email.toString(), mailList);
            list.add(ar);
        }
        artContainer.addAll(list);
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)artContainer);
        return json;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="allWeb")
    public String getAllUsersWeb() {
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).getResults();
            ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
            for (ArtifactReadable artifactReadable : list) {
                TransferableArtifact ar = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                ResultSet attributes = artifactReadable.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId);
                if (attributes != null && attributes.size() > 0) {
                    for (AttributeReadable attributeReadable : attributes) {
                        String userIDString = (String)attributeReadable.getValue();
                        ar.putAttributes(CoreAttributeTypes.UserId.getName(), Arrays.asList(userIDString));
                    }
                }
                listTras.add(ar);
            }
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            container.addAll(listTras);
            JSONSerializer serializer = new JSONSerializer();
            String json = serializer.deepSerialize((Object)container);
            return json;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="createUser")
    public String createUser(String json) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            ArtifactToken childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            ArtifactReadable currentUser = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
            UserId userId = UserId.valueOf((Long)currentUser.getId());
            TransactionBuilder tx = txFactory.createTransaction(CommonUtil.getCommonBranch(orcsApi), userId, "Add New User");
            childArtifact = tx.createArtifact(CoreArtifactTypes.User, artifact.getName());
            Map attributes = artifact.getAttributes();
            Set entrySet = attributes.entrySet();
            for (Map.Entry entry : entrySet) {
                String type = (String)entry.getKey();
                List value = (List)entry.getValue();
                for (String string : value) {
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(type), (String)"Attribute"), string);
                }
            }
            tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)CoreAttributeTypes.Active, "true");
            tx.commit();
            ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
            ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
            TransferableArtifactsContainer artContainer = new TransferableArtifactsContainer();
            TransferableArtifact ar = new TransferableArtifact();
            ar.setName(readableArtifact.getName());
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(readableArtifact, (ITransferableArtifact)ar);
            artContainer.addAll(Arrays.asList(ar));
            JSONSerializer serializer = new JSONSerializer();
            json = serializer.deepSerialize((Object)artContainer);
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getUserID")
    public String getUserByGUID(String userntID) {
        String userData = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable artifactReadable = UserUtility.getUserById(orcsApi, userntID);
            HashMap<String, String> userDetails = new HashMap<String, String>();
            userDetails.put("guid", artifactReadable.getGuid());
            JSONSerializer serializer = new JSONSerializer();
            userData = serializer.deepSerialize(userDetails);
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return userData;
    }
}

