/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class HealthOperations {
    private final AtsApi atsApi;

    public HealthOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData getDuplicateArtifactReport(ArtifactId id, String newArtId) {
        XResultData rd = new XResultData();
        rd.logf("Duplicate Artifact Analysis Report\n\n", new Object[0]);
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(id);
        rd.logf("Artifact [%s]\n", new Object[]{art.getIdString()});
        rd.logf("New Artifact Id [%s]\n", new Object[]{newArtId});
        List artRows = this.atsApi.getQueryService().query("select * from osee_artifact where art_id = ?", new Object[]{id.getIdString()});
        int x = 1;
        for (Map rowMap : artRows) {
            rd.log("\nArtifact " + x++ + "\n============");
            rd.log("ARTIFACT: " + rowMap);
            String artTypeStr = (String)rowMap.get("ART_TYPE_ID");
            Long artTypeId = Long.valueOf(artTypeStr);
            ArtifactTypeToken artType = this.atsApi.tokenService().getArtifactType(artTypeId);
            rd.logf("ART_TYPE: %s\n", new Object[]{artType.toStringWithId()});
            String gammaStr = (String)rowMap.get("GAMMA_ID");
            Long gammaId = Long.valueOf(gammaStr);
            List txsRows = this.atsApi.getQueryService().query("select * from osee_txs where branch_id = 570 and gamma_id = ?", new Object[]{gammaId});
            rd.logf("TXS: %s\n", new Object[]{txsRows});
            for (Object txRow : txsRows) {
                String transId = (String)txRow.get("TRANSACTION_ID");
                List txDetailsRows = this.atsApi.getQueryService().query("select * from osee_tx_details where branch_id = 570 and transaction_id = ?", new Object[]{transId});
                rd.logf("TX_DETAILS: %s\n", new Object[]{txDetailsRows});
            }
        }
        rd.logf("\nACTION: Run ActionFactory.getNextArtifactId to get clean art_id;\n", new Object[0]);
        rd.logf("ACTION: select * from osee_artifact_where art_id = %s;\n", new Object[]{id.getIdString()});
        rd.logf("ACTION: run query and update desired row to new artifact id: %s;\n", new Object[]{newArtId});
        HashCollection transToGamma = new HashCollection();
        HashMap<String, Map> gammaIdToAttrRow = new HashMap<String, Map>();
        HashMap<String, Map> gammaIdToRelRow = new HashMap<String, Map>();
        HashMap<String, Map<String, String>> transIdToTxsRow = new HashMap<String, Map<String, String>>();
        HashMap<String, Map> transIdToTxDetailsRow = new HashMap<String, Map>();
        HashMap<String, String> transDateTotransId = new HashMap<String, String>();
        rd.log("\nAttributes \n============");
        List attrRows = this.atsApi.getQueryService().query("select * from osee_attribute where art_id = ?", new Object[]{id.getIdString()});
        for (Map attrRow : attrRows) {
            rd.logf("ATTR: %s\n", new Object[]{attrRow});
            Iterator gammaStr = (String)attrRow.get("GAMMA_ID");
            gammaIdToAttrRow.put((String)((Object)gammaStr), attrRow);
            Map<String, String> txsRow = this.getTxsRow((String)((Object)gammaStr), rd);
            String transStr = txsRow.get("TRANSACTION_ID");
            transIdToTxsRow.put(transStr, txsRow);
            transToGamma.put((Object)transStr, gammaStr);
        }
        rd.log("\nRelation \n============");
        List relRows = this.atsApi.getQueryService().query("select * from osee_relation_link where a_art_id = ? or b_art_id = ?", new Object[]{id.getIdString(), id.getIdString()});
        for (Map relRow : relRows) {
            rd.logf("REL: %s\n", new Object[]{relRow});
            String gammaStr = (String)relRow.get("GAMMA_ID");
            gammaIdToRelRow.put(gammaStr, relRow);
            Map<String, String> txsRow = this.getTxsRow(gammaStr, rd);
            String transStr = txsRow.get("TRANSACTION_ID");
            transIdToTxsRow.put(transStr, txsRow);
            transToGamma.put((Object)transStr, (Object)gammaStr);
        }
        for (String transId : transToGamma.keySet()) {
            List txDetailsRows = this.atsApi.getQueryService().query("select * from osee_tx_details where branch_id = 570 and transaction_id = ?", new Object[]{transId});
            transIdToTxDetailsRow.put(transId, (Map)txDetailsRows.iterator().next());
            String txTime = (String)((Map)txDetailsRows.iterator().next()).get("TIME");
            transDateTotransId.put(txTime, transId);
        }
        ArrayList dates = new ArrayList();
        dates.addAll(transDateTotransId.keySet());
        java.util.Collections.sort(dates);
        rd.log("\nTransactions \n============");
        for (String transDate : dates) {
            String transId = (String)transDateTotransId.get(transDate);
            Map txsRow = (Map)transIdToTxsRow.get(transId);
            rd.logf("\nTRANS: %s\n", new Object[]{txsRow});
            Map txDetails = (Map)transIdToTxDetailsRow.get(transId);
            rd.logf("DETAILS: %s\n", new Object[]{txDetails});
            ArrayList<String> attrGammas = new ArrayList<String>();
            for (String gamma : (List)transToGamma.getValues((Object)transId)) {
                Map attrRow = (Map)gammaIdToAttrRow.get(gamma);
                if (attrRow == null) continue;
                attrGammas.add(gamma);
                rd.logf("ATTR: %s\n", new Object[]{attrRow});
            }
            if (!attrGammas.isEmpty()) {
                rd.logf("\nACTION: IF this transaction belongs to new art_id, Update attrs with new art_id;\n", new Object[0]);
                rd.logf("ACTION: update osee_attribute set art_id = %s  where gamma_id in (%s);\n\n", new Object[]{newArtId, Collections.toString((String)",", attrGammas)});
            }
            ArrayList<String> relGammas = new ArrayList<String>();
            for (String gamma : (List)transToGamma.getValues((Object)transId)) {
                Map relRow = (Map)gammaIdToRelRow.get(gamma);
                if (relRow == null) continue;
                relGammas.add(gamma);
                rd.logf("REL: %s\n", new Object[]{relRow});
            }
            if (relGammas.isEmpty()) continue;
            rd.logf("\n\nACTION: IF this transaction belongs to new art_id, Update rels with new art_id;\n", new Object[0]);
            rd.logf("ACTION: update osee_relation_link set a_art_id = %s  where gamma_id in (%s);\n", new Object[]{newArtId, Collections.toString((String)",", relGammas)});
            rd.logf("ACTION: update osee_relation_link set b_art_id = %s  where gamma_id in (%s);\n\n", new Object[]{newArtId, Collections.toString((String)",", relGammas)});
        }
        return rd;
    }

    public Map<String, String> getTxDetailsRow(String transId, XResultData rd) {
        List txDetailsRows = this.atsApi.getQueryService().query("select * from osee_tx_details where transaction_id = ?", new Object[]{transId});
        if (txDetailsRows.size() != 1) {
            rd.errorf("Unexpected %s txDetailsRows returned for transId %s\n", new Object[]{txDetailsRows.size(), transId});
        }
        return (Map)txDetailsRows.iterator().next();
    }

    public Map<String, String> getTxsRow(String gammaStr, XResultData rd) {
        List txsRows = this.atsApi.getQueryService().query("select * from osee_txs where branch_id = 570 and gamma_id = ?", new Object[]{gammaStr});
        if (txsRows.size() != 1) {
            rd.errorf("Unexpected %s txRows returned for gamma %s\n", new Object[]{txsRows.size(), gammaStr});
        }
        return (Map)txsRows.iterator().next();
    }
}

