/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.applicability.ApplicabilityBranchConfig;
import org.eclipse.osee.framework.core.applicability.BranchViewDefinition;
import org.eclipse.osee.framework.core.applicability.ExtendedFeatureDefinition;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.applicability.NameValuePair;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityCacheFile;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewToken;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;
import org.eclipse.osee.orcs.core.internal.applicability.StagedFileWatcher;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class OrcsApplicabilityOps
implements OrcsApplicability {
    private final OrcsApi orcsApi;
    private final Log logger;
    private ArtifactToken plFolder = ArtifactToken.SENTINEL;
    private ArtifactToken featureFolder = ArtifactToken.SENTINEL;
    private ArtifactToken configurationsFolder = ArtifactToken.SENTINEL;
    private ArtifactToken plConfigurationGroupsFolder = ArtifactToken.SENTINEL;
    private static StagedFileWatcher fileWatcher;
    private final TransactionFactory txFactory;

    public OrcsApplicabilityOps(OrcsApi orcsApi, Log logger) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.txFactory = orcsApi.getTransactionFactory();
    }

    public ApplicabilityBranchConfig getConfig(BranchId branchId, boolean showAll) {
        ApplicabilityBranchConfig config = new ApplicabilityBranchConfig();
        Branch branch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branchId)).getResults().getExactlyOne();
        config.setBranch((BranchViewToken)branch);
        config.setAssociatedArtifactId(branch.getAssociatedArtifact());
        if (branch.getBranchType().equals(BranchType.WORKING.getId())) {
            config.setEditable(Boolean.valueOf(true));
        } else {
            config.setEditable(Boolean.valueOf(false));
        }
        if (branch.getParentBranch().isValid()) {
            Branch parentBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch.getParentBranch())).getResults().getExactlyOne();
            config.setParentBranch(new BranchViewToken((BranchId)parentBranch, parentBranch.getName(), parentBranch.getViewId()));
        }
        List branchViews = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifacts();
        List groups = this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch((BranchId)branch);
        Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactReadable branchView : branchViews) {
            Map namedViewApplicabilityMap = this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap((BranchId)branch, (ArtifactId)branchView);
            boolean hasFeatureApplicabilities = namedViewApplicabilityMap.entrySet().stream().filter(map -> !((String)map.getKey()).equals("Config")).collect(Collectors.toMap(map -> (String)map.getKey(), map -> (List)map.getValue())).size() > 1;
            config.addView(new BranchViewDefinition(branchView.getIdString(), branchView.getName(), branchView.fetchAttributesAsStringList((AttributeTypeToken)CoreAttributeTypes.ProductApplicability), hasFeatureApplicabilities));
            branchViewsMap.put((ArtifactId)branchView, namedViewApplicabilityMap);
        }
        for (ArtifactToken group : groups) {
            config.addGroup(this.getConfigurationGroup(group.getIdString(), (BranchId)branch));
            branchViewsMap.put((ArtifactId)group, this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap((BranchId)branch, (ArtifactId)group));
        }
        List featureArts = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).asArtifacts();
        Collections.sort(featureArts, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactReadable featureArt : featureArts) {
            FeatureDefinition fDef = this.getFeatureDefinition(featureArt);
            ExtendedFeatureDefinition extfDef = new ExtendedFeatureDefinition(fDef);
            LinkedList<List<NameValuePair>> groupingsList = new LinkedList<List<NameValuePair>>();
            for (ConfigurationGroupDefinition configurationGroupDefinition : config.getGroups()) {
                String groupToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)configurationGroupDefinition.getId()), fDef, branchViewsMap);
                List<NameValuePair> groupList = new LinkedList<NameValuePair>();
                groupList.add(new NameValuePair(configurationGroupDefinition.getName(), groupToFeatureValue));
                for (BranchViewDefinition memberConfig : config.getViews()) {
                    if (!configurationGroupDefinition.getConfigurations().contains(memberConfig.getId())) continue;
                    String viewToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)memberConfig.getId()), fDef, branchViewsMap);
                    groupList.add(new NameValuePair(memberConfig.getName(), viewToFeatureValue));
                }
                groupingsList.add(groupList);
            }
            for (BranchViewDefinition branchViewDefinition : config.getViews()) {
                boolean viewPresent = false;
                for (List<NameValuePair> groupList : groupingsList) {
                    for (NameValuePair configItem : groupList) {
                        if (configItem.getName() != branchViewDefinition.getName()) continue;
                        viewPresent = true;
                    }
                }
                if (viewPresent) continue;
                String viewToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)branchViewDefinition.getId()), fDef, branchViewsMap);
                extfDef.addConfiguration(new NameValuePair(branchViewDefinition.getName(), viewToFeatureValue));
            }
            for (List list : groupingsList) {
                for (NameValuePair configItem : list) {
                    extfDef.addConfiguration(configItem);
                }
            }
            config.addFeature(extfDef);
        }
        return config;
    }

    private String getViewToFeatureValue(ArtifactId view, FeatureDefinition fDef, Map<ArtifactId, Map<String, List<String>>> branchViewsMap) {
        Map<String, List<String>> map = branchViewsMap.get(view);
        List<String> list = map.get(fDef.getName());
        if (list == null) {
            return "";
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", list);
    }

    public CreateViewDefinition getViewDefinition(ArtifactReadable art) {
        CreateViewDefinition view = new CreateViewDefinition();
        view.setId(art.getId());
        view.setName(art.getName());
        view.setProductApplicabilities(art.fetchAttributesAsStringList((AttributeTypeToken)CoreAttributeTypes.ProductApplicability));
        view.setConfigurationGroup(art.getRelated(CoreRelationTypes.PlConfigurationGroup_Group).getList().stream().map(a -> ArtifactId.valueOf((Long)a.getId())).collect(Collectors.toList()));
        view.setData((Object)art);
        return view;
    }

    public FeatureDefinition getFeatureDefinition(ArtifactReadable art) {
        FeatureDefinition feature = new FeatureDefinition();
        feature.setId(art.getId());
        feature.setName(art.getName());
        feature.setDefaultValue((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)""));
        feature.setValues(art.fetchAttributesAsStringList((AttributeTypeToken)CoreAttributeTypes.Value));
        feature.setProductApplicabilities(art.fetchAttributesAsStringList((AttributeTypeToken)CoreAttributeTypes.ProductApplicability));
        feature.setValueType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FeatureValueType, ""));
        feature.setMultiValued(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)false)).booleanValue());
        feature.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
        feature.setData((Object)art);
        return feature;
    }

    public ArtifactToken createFeatureDefinition(FeatureDefinition featureDef, TransactionBuilder tx, XResultData results) {
        FeatureDefinition lFeature;
        ArtifactToken fDefArt = ArtifactToken.SENTINEL;
        if (Strings.isInValid((String)featureDef.getName())) {
            results.error("Feature must have a name.");
        }
        if (!featureDef.getName().matches("^[A-Z0-9_()\\s\\-\\.]+$")) {
            results.error("Feature name must be all caps with no special characters except underscore, dash, and space");
        }
        if (Strings.isInValid((String)featureDef.getDescription())) {
            results.error("Description is required.");
        }
        if (featureDef.getValues() == null) {
            results.error("Values must be specified.  Comma delimited.");
        } else {
            for (String val : featureDef.getValues()) {
                if (val.matches("^[a-zA-Z0-9_()\\s\\-\\.]+$")) continue;
                results.error("The value: " + val + " is invalid.  Must be alphanumeric.");
            }
        }
        if (Strings.isInValid((String)featureDef.getDefaultValue())) {
            results.error("Default value is required");
        }
        if (featureDef.getValues() != null && !featureDef.getValues().contains(featureDef.getDefaultValue())) {
            results.error("Default value must be in the list of values.");
        }
        if (Strings.isInValid((String)featureDef.getValueType())) {
            results.error("Value type is required.");
        }
        if ((lFeature = this.getFeature(featureDef.getName(), tx.getBranch())).isValid()) {
            results.error("Feature: " + lFeature.getName() + " already exists.");
        }
        if (results.isErrors()) {
            return fDefArt;
        }
        if (lFeature.isInvalid()) {
            ArtifactToken featuresFolder = tx.getWriteable((ArtifactId)CoreArtifactTokens.FeaturesFolder);
            if (featuresFolder.isInvalid()) {
                featuresFolder = this.getFeaturesFolder(tx.getBranch());
            }
            if (featuresFolder.isInvalid()) {
                results.error("Features Folder cannot be null");
                return fDefArt;
            }
            fDefArt = tx.createArtifact((ArtifactId)featuresFolder, CoreArtifactTypes.Feature, featureDef.getName());
        }
        this.updateFeatureDefinition(fDefArt, featureDef, tx);
        return fDefArt;
    }

    public ArtifactToken updateFeatureDefinition(FeatureDefinition featureDef, TransactionBuilder tx, XResultData results) {
        ArtifactToken fDefArt = ArtifactToken.SENTINEL;
        if (Strings.isInValid((String)featureDef.getName())) {
            results.error("Feature must have a name.");
        }
        if (!featureDef.getName().matches("^[A-Z0-9_()\\s\\-\\.]+$")) {
            results.error("Feature name must be all caps with no special characters except underscore, dash, and space");
        }
        if (Strings.isInValid((String)featureDef.getDescription())) {
            results.error("Description is required.");
        }
        if (featureDef.getValues() == null) {
            results.error("Values must be specified.  Comma delimited.");
        } else {
            for (String val : featureDef.getValues()) {
                if (val.matches("^[a-zA-Z0-9_()\\s\\-\\.]+$")) continue;
                results.error("The value: " + val + " is invalid.  Must be alphanumeric.");
            }
        }
        if (Strings.isInValid((String)featureDef.getDefaultValue())) {
            results.error("Default value is required");
        }
        if (featureDef.getValues() != null && !featureDef.getValues().contains(featureDef.getDefaultValue())) {
            results.error("Default value must be in the list of values.");
        }
        if (Strings.isInValid((String)featureDef.getValueType())) {
            results.error("Value type is required.");
        }
        FeatureDefinition lFeature = this.getFeature(featureDef.getName(), tx.getBranch());
        if (results.isErrors()) {
            return fDefArt;
        }
        fDefArt = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)lFeature.getId())).asArtifactOrSentinel();
        this.updateFeatureDefinition(fDefArt, featureDef, tx);
        return fDefArt;
    }

    private void updateFeatureDefinition(ArtifactToken fDefArt, FeatureDefinition featureDef, TransactionBuilder tx) {
        tx.setName((ArtifactId)fDefArt, featureDef.getName());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)featureDef.getDefaultValue());
        tx.setAttributesFromValues((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Value, (Collection)featureDef.getValues());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureValueType, (Object)featureDef.getValueType());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)featureDef.isMultiValued());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)featureDef.getDescription());
        if (featureDef.getProductApplicabilities() != null) {
            tx.setAttributesFromValues((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)featureDef.getProductApplicabilities());
        }
    }

    public List<BranchId> getApplicabilityBranches() {
        ArrayList<BranchId> tokens = new ArrayList<BranchId>();
        for (Branch branch : ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList()) {
            if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
            tokens.add((BranchId)branch);
        }
        return tokens;
    }

    public List<BranchId> getApplicabilityBranchesByType(String branchQueryType) {
        ArrayList<BranchId> tokens = new ArrayList<BranchId>();
        List branchList = new ArrayList();
        if (branchQueryType.equals("all")) {
            branchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList();
        }
        if (branchQueryType.equals("baseline")) {
            branchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList();
        }
        for (Branch branch : branchList) {
            if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
            tokens.add((BranchId)branch);
        }
        return tokens;
    }

    public ArtifactToken getFeaturesFolder(BranchId branch) {
        if (this.featureFolder.isInvalid()) {
            this.featureFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("Features").asArtifactTokenOrSentinel();
        }
        return this.featureFolder;
    }

    public ArtifactToken getConfigurationsFolder(BranchId branch) {
        if (this.configurationsFolder.isInvalid()) {
            this.configurationsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("Products").asArtifactOrSentinel();
        }
        if (this.configurationsFolder.isInvalid()) {
            this.configurationsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("Configurations").asArtifactOrSentinel();
        }
        return this.configurationsFolder;
    }

    public ArtifactToken getPlConfigurationGroupsFolder(BranchId branch) {
        if (this.plConfigurationGroupsFolder.isInvalid()) {
            this.plConfigurationGroupsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("PL Configuration Groups").asArtifactOrSentinel();
        }
        return this.plConfigurationGroupsFolder;
    }

    public ArtifactToken getProductLineFolder(BranchId branch) {
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).asArtifactOrSentinel();
        }
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals("Product Line").asArtifactTokenOrSentinel();
        }
        return this.plFolder;
    }

    public XResultData createFeature(FeatureDefinition feature, BranchId branch) {
        XResultData results = new XResultData();
        ArtifactToken featureArt = ArtifactToken.SENTINEL;
        TransactionBuilder tx = this.txFactory.createTransaction(branch, "Create Feature");
        boolean changes = false;
        try {
            featureArt = this.createFeatureDefinition(feature, tx, results);
            if (featureArt.isValid()) {
                changes = true;
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        if (results.getNumErrors() == 0) {
            try {
                for (String value : feature.getValues()) {
                    String applicString = String.valueOf(feature.getName()) + " = " + value;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, (ArtifactId)featureArt, tx, applicString);
                    changes = true;
                }
                List branchViews = this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch);
                Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
                for (ArtifactToken view : branchViews) {
                    Iterable appl = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)view);
                    if (appl.toString().contains(String.valueOf(feature.getName()) + " = ")) continue;
                    String applicString = String.valueOf(feature.getName()) + " = " + feature.getDefaultValue();
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, (ArtifactId)view, tx, applicString);
                    changes = true;
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        }
        if (changes) {
            tx.commit();
        }
        return results;
    }

    private void addIntroduceTuple2(Tuple2Type<ArtifactId, String> tupleType, ArtifactId featureArt, TransactionBuilder tx, String applicString) {
        GammaId gamma = GammaId.SENTINEL;
        gamma = this.orcsApi.getQueryFactory().tupleQuery().getTuple2GammaFromE1E2(tupleType, (Object)featureArt, (Object)applicString);
        if (!gamma.isValid()) {
            tx.addTuple2(tupleType, (Object)featureArt, (Object)applicString);
        } else {
            tx.introduceTuple(tupleType, gamma);
        }
    }

    public XResultData updateFeature(FeatureDefinition feature, BranchId branch) {
        XResultData results = new XResultData();
        ArtifactToken featureArt = ArtifactToken.SENTINEL;
        try {
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Update Feature");
            featureArt = this.updateFeatureDefinition(feature, tx, results);
            if (featureArt.isValid()) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        if (results.getNumErrors() == 0) {
            try {
                boolean changes = false;
                TransactionBuilder tx = this.txFactory.createTransaction(branch, "Add new tuple values for feature");
                HashSet applicData = Sets.newHashSet((Iterable)this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ApplicabilityDefinition, tx.getBranch(), (Object)featureArt));
                for (String value : feature.getValues()) {
                    String applicString = String.valueOf(feature.getName()) + " = " + value;
                    if (applicData.remove(applicString)) continue;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, (ArtifactId)featureArt, tx, applicString);
                    changes = true;
                }
                for (String invalidApplic : applicData) {
                    tx.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)featureArt, (Object)invalidApplic);
                    changes = true;
                }
                if (changes) {
                    tx.commit();
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        }
        return results;
    }

    public FeatureDefinition getFeature(String feature, BranchId branch) {
        if (Strings.isNumeric((String)feature)) {
            ArtifactReadable featureArt = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andId(ArtifactId.valueOf((String)feature)).asArtifactOrSentinel();
            if (featureArt.isValid()) {
                return this.getFeatureDefinition(featureArt);
            }
        } else {
            ArtifactReadable featureArt = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andNameEquals(feature).asArtifactOrSentinel();
            if (featureArt.isValid()) {
                return this.getFeatureDefinition(featureArt);
            }
        }
        return FeatureDefinition.SENTINEL;
    }

    public XResultData deleteFeature(ArtifactId feature, BranchId branch) {
        XResultData results = new XResultData();
        try {
            FeatureDefinition featureDef = this.getFeature(feature.getIdString(), branch);
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Delete Feature");
            List branchViews = this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch);
            Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
            for (ArtifactToken view : branchViews) {
                Iterable applicData = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)view);
                for (String value : featureDef.getValues()) {
                    String applicString = String.valueOf(featureDef.getName()) + " = " + value;
                    if (!applicData.toString().contains(applicString)) continue;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)applicString);
                }
            }
            Iterable applicData = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ApplicabilityDefinition, tx.getBranch(), (Object)feature);
            for (String value : featureDef.getValues()) {
                String applicString = String.valueOf(featureDef.getName()) + " = " + value;
                if (!applicData.toString().contains(applicString)) continue;
                tx.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)feature, (Object)applicString);
            }
            tx.deleteArtifact(feature);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData removeApplicabilityFromView(BranchId branch, ArtifactId viewId, String applicability) {
        XResultData results = new XResultData();
        try {
            CreateViewDefinition view = this.getView(viewId.getIdString(), branch);
            if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, applicability)) {
                TransactionBuilder tx = this.txFactory.createTransaction(branch, "Remove applicability from configuration");
                tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)applicability);
                tx.commit();
            } else {
                results.error(String.valueOf(applicability) + " does not exist on configuration: " + view.getName());
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public CreateViewDefinition getView(String view, BranchId branch) {
        CreateViewDefinition viewDef = new CreateViewDefinition();
        if (Strings.isNumeric((String)view)) {
            ArtifactReadable viewArt = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)view)).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel();
            if (viewArt.isValid()) {
                viewDef = this.getViewDefinition(viewArt);
            }
        } else {
            ArtifactReadable viewArt = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(view).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel();
            if (viewArt.isValid()) {
                viewDef = this.getViewDefinition(viewArt);
            }
        }
        return viewDef;
    }

    public ConfigurationGroupDefinition getConfigurationGroup(String cfgGroup, BranchId branch) {
        ConfigurationGroupDefinition configGroup = new ConfigurationGroupDefinition();
        ArtifactToken groupArt = ArtifactToken.SENTINEL;
        groupArt = Strings.isNumeric((String)cfgGroup) ? this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andId(ArtifactId.valueOf((String)cfgGroup)).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(cfgGroup).asArtifactTokenOrSentinel();
        if (groupArt.isValid()) {
            configGroup.setName(groupArt.getName());
            configGroup.setId(groupArt.getIdString());
            ArrayList<String> views = new ArrayList<String>();
            for (ArtifactId view : this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)groupArt).asArtifactIds()) {
                views.add(view.getIdString());
            }
            configGroup.setConfigurations(views);
        }
        return configGroup;
    }

    public XResultData updateView(CreateViewDefinition view, BranchId branch) {
        TransactionBuilder tx;
        XResultData results = new XResultData();
        CreateViewDefinition editView = this.getView(view.getIdString(), branch);
        if (editView.isInvalid()) {
            results.errorf("Edit failed: invalid view", new Object[0]);
            return results;
        }
        if (view.copyFrom.isValid()) {
            results = this.copyFromView(branch, ArtifactId.valueOf((Long)editView.getId()), view.copyFrom);
        }
        if (results.isErrors()) {
            return results;
        }
        if (view.getProductApplicabilities().isEmpty() && !editView.getProductApplicabilities().isEmpty()) {
            tx = this.txFactory.createTransaction(branch, "Remove Configuration product applicabilities");
            tx.deleteAttributes(ArtifactId.valueOf((Id)editView), (AttributeTypeToken)CoreAttributeTypes.ProductApplicability);
            tx.commit();
        } else if (editView.getProductApplicabilities().isEmpty() || !editView.getProductApplicabilities().equals(view.getProductApplicabilities())) {
            tx = this.txFactory.createTransaction(branch, "Update Configuration product applicabilities");
            tx.setAttributesFromValues(ArtifactId.valueOf((Id)editView), (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)view.getProductApplicabilities());
            tx.commit();
        }
        if (!view.getName().equals(editView.getName())) {
            tx = this.txFactory.createTransaction(branch, "Update Configuration Name");
            tx.setName(ArtifactId.valueOf((Id)editView), view.getName());
            tx.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((Long)editView.getId()), (Object)("Config = " + editView.getName()));
            tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)ArtifactId.valueOf((Long)editView.getId()), (Object)("Config = " + editView.getName()));
            this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, ArtifactId.valueOf((Long)view.getId()), tx, "Config = " + view.getName());
            this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, ArtifactId.valueOf((Long)view.getId()), tx, "Config = " + view.getName());
            tx.commit();
        }
        if (!(view.getConfigurationGroup().isEmpty() && editView.getConfigurationGroup().isEmpty() || view.getConfigurationGroup().equals(editView.getConfigurationGroup()))) {
            List editViewList = editView.getConfigurationGroup().stream().map(a -> a.getIdString()).collect(Collectors.toList());
            List newViewList = view.getConfigurationGroup().stream().map(a -> a.getIdString()).collect(Collectors.toList());
            List editViewDoesNotContain = editViewList.stream().filter(b -> !newViewList.contains(b)).collect(Collectors.toList());
            List newViewDoesNotContain = newViewList.stream().filter(b -> !editViewList.contains(b)).collect(Collectors.toList());
            for (String group : editViewDoesNotContain) {
                results = this.unrelateCfgGroupToView(group, editView.getIdString(), branch);
            }
            for (String group : newViewDoesNotContain) {
                results = this.relateCfgGroupToView(group, editView.getIdString(), branch);
            }
            if (results.isErrors()) {
                return results;
            }
        }
        return results;
    }

    public XResultData createView(CreateViewDefinition view, BranchId branch) {
        XResultData results = new XResultData();
        if (!Strings.isValid((String)view.getName())) {
            results.errorf("Name can not be empty for configuration %s", new Object[]{view.getId()});
            return results;
        }
        CreateViewDefinition newView = this.getView(view.getName(), branch);
        if (newView.isValid()) {
            results.errorf("Configuration Name is already in use.", new Object[0]);
            return results;
        }
        if (newView.isInvalid()) {
            try {
                TransactionBuilder tx = this.txFactory.createTransaction(branch, "Create View ");
                ArtifactToken vDefArt = ArtifactToken.SENTINEL;
                vDefArt = tx.createArtifact((ArtifactId)this.getConfigurationsFolder(tx.getBranch()), CoreArtifactTypes.BranchView, view.getName());
                if (!view.getProductApplicabilities().isEmpty()) {
                    tx.setAttributesFromValues((ArtifactId)vDefArt, (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)view.getProductApplicabilities());
                }
                tx.commit();
                TransactionBuilder tx2 = this.txFactory.createTransaction(branch, "Create Config and Base applicabilities on New View");
                this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, (ArtifactId)vDefArt, tx2, "Config = " + view.getName());
                tx2.createApplicabilityForView((ArtifactId)vDefArt, "Base");
                tx2.createApplicabilityForView((ArtifactId)vDefArt, "Config = " + view.getName());
                tx2.commit();
            }
            catch (Exception ex) {
                results.errorf(Lib.exceptionToString((Exception)ex), new Object[0]);
                return results;
            }
            newView = this.getView(view.getName(), branch);
        }
        if (view.getCopyFrom().isValid() || !view.getConfigurationGroup().isEmpty()) {
            if (newView.isValid()) {
                if (view.getCopyFrom().isValid() && (results = this.copyFromView(branch, ArtifactId.valueOf((Id)newView), view.copyFrom)).isErrors()) {
                    return results;
                }
                if (!view.getConfigurationGroup().isEmpty()) {
                    for (ArtifactId group : view.getConfigurationGroup()) {
                        results = this.relateCfgGroupToView(group.getIdString(), newView.getIdString(), branch);
                    }
                    if (results.isErrors()) {
                        return results;
                    }
                }
            } else {
                results.error("Errors creating new configuration: " + view.getName());
            }
        }
        return results;
    }

    public XResultData deleteView(String view, BranchId branch) {
        XResultData results = new XResultData();
        try {
            CreateViewDefinition viewDef = this.getView(view, branch);
            if (!viewDef.getConfigurationGroup().isEmpty()) {
                for (ArtifactId group : viewDef.getConfigurationGroup()) {
                    this.unrelateCfgGroupToView(group.getIdString(), viewDef.getIdString(), branch);
                }
            }
            Iterable deleteApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)ArtifactId.valueOf((Long)viewDef.getId()));
            ArtifactToken viewArt = (ArtifactToken)viewDef.getData();
            if (viewArt.isValid()) {
                TransactionBuilder txApps = this.txFactory.createTransaction(branch, "Delete all applicabilities for deleted view");
                for (String app : deleteApps) {
                    txApps.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)ArtifactId.valueOf((Long)viewDef.getId()), (Object)app);
                }
                txApps.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)viewArt, (Object)("Config = " + viewDef.getName()));
                txApps.commit();
                TransactionBuilder tx = this.txFactory.createTransaction(branch, "Delete View");
                tx.deleteArtifact((ArtifactId)viewArt);
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData setApplicability(BranchId branch, ArtifactId view, ArtifactId feature, String applicability) {
        XResultData results = new XResultData();
        try {
            ArtifactReadable featureArt = this.orcsApi.getQueryFactory().fromBranch(branch).andId(feature).asArtifactOrSentinel();
            FeatureDefinition fDef = this.orcsApi.getApplicabilityOps().getFeatureDefinition(featureArt);
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Set View Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)view)) {
                if (!appl.startsWith(String.valueOf(fDef.getName()) + " = ")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            String[] stringArray = applicability.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = value.replace("^ +", "");
                value = value.replace(" +$", "");
                value = String.valueOf(featureArt.getName()) + " = " + value;
                newValues.add(value);
                ++n2;
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, view, tx, newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, view, tx, newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData copyFromView(BranchId branch, ArtifactId view, ArtifactId copy_from) {
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Set configuration/View Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)view)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)copy_from)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                newValues.add(appl);
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, view, tx, newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ViewApplicability, view, tx, newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData createApplicabilityForView(ArtifactId viewId, String applicability, BranchId branch) {
        TransactionBuilder tx;
        String featureName;
        FeatureDefinition feature;
        XResultData results = new XResultData();
        if (results.isErrors()) {
            return results;
        }
        if (!this.orcsApi.getQueryFactory().applicabilityQuery().viewExistsOnBranch(branch, viewId)) {
            results.error("View is invalid.");
            return results;
        }
        if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, applicability) && !(feature = this.getFeature(featureName = applicability.substring(0, applicability.indexOf("=") - 1), branch)).isMultiValued()) {
            results.error("Applicability already exists.");
            return results;
        }
        if (applicability.startsWith("Config =")) {
            tx = this.txFactory.createTransaction(branch, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.startsWith("ConfigurationGroup =")) {
            tx = this.txFactory.createTransaction(branch, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.equals("Base")) {
            tx = this.txFactory.createTransaction(branch, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.contains("|") || applicability.contains("&")) {
            boolean validApplicability = false;
            if (applicability.contains("|")) {
                String[] stringArray = applicability.split("\\|");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (Object appl : existingApps) {
                        if (!((String)appl).equals(value.trim())) continue;
                        validApplicability = true;
                    }
                    ++n2;
                }
            } else {
                Object appl;
                int cnt = applicability.split("&").length;
                int validCnt = 0;
                appl = applicability.split("&");
                int existingApps = ((String[])appl).length;
                int n = 0;
                while (n < existingApps) {
                    String value = appl[n];
                    Iterable existingApps2 = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl2 : existingApps2) {
                        if (!appl2.equals(value.trim())) continue;
                        ++validCnt;
                    }
                    ++n;
                }
                if (cnt == validCnt) {
                    validApplicability = true;
                }
            }
            if (validApplicability) {
                TransactionBuilder tx2 = this.txFactory.createTransaction(branch, "Set applicability for view");
                tx2.createApplicabilityForView(viewId, applicability);
                tx2.commit();
                for (ArtifactId bView : this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch)) {
                    this.updateCompoundApplicabilities(branch, bView, true);
                }
            } else {
                results.error("Invalid applicability tag.  One of the applicabilities used is not valid for the given view.");
            }
        } else {
            featureName = applicability.substring(0, applicability.indexOf("=") - 1);
            String featureValue = applicability.substring(applicability.indexOf("=") + 2);
            FeatureDefinition feature2 = this.getFeature(featureName, branch);
            if (feature2.isInvalid()) {
                results.error(String.valueOf(feature2.getName()) + " is not a valid feature for given branch");
            } else if (feature2.isMultiValued()) {
                ArrayList<String> newValues = new ArrayList<String>();
                String[] existingApps2 = featureValue.split(",");
                int appl = existingApps2.length;
                int existingApps = 0;
                while (existingApps < appl) {
                    String val = existingApps2[existingApps];
                    if (!feature2.getValues().contains(val)) {
                        results.error(String.valueOf(val) + " is not a valid value for " + feature2.getName());
                        return results;
                    }
                    newValues.add(String.valueOf(featureName) + " = " + val);
                    ++existingApps;
                }
                LinkedList<String> existingValues = new LinkedList<String>();
                Iterable existingApps22 = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                for (String appl3 : existingApps22) {
                    if (!appl3.startsWith(String.valueOf(featureName) + " = ")) continue;
                    existingValues.add(appl3);
                }
                TransactionBuilder txMv = this.txFactory.createTransaction(branch, "Set applicability for view");
                ArrayList removeValues = new ArrayList(existingValues);
                removeValues.removeAll(newValues);
                for (String val : removeValues) {
                    txMv.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)val);
                }
                newValues.removeAll(existingValues);
                for (String val : newValues) {
                    txMv.createApplicabilityForView(viewId, val);
                }
                txMv.commit();
                this.updateCompoundApplicabilities(branch, viewId, true);
            } else if (feature2.getValues().contains(featureValue)) {
                LinkedList<String> existingValues = new LinkedList<String>();
                Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                for (String appl : existingApps) {
                    if (!appl.startsWith(String.valueOf(featureName) + " = ")) continue;
                    existingValues.add(appl);
                }
                TransactionBuilder tx3 = this.txFactory.createTransaction(branch, "Set applicability for view");
                for (String existingValue : existingValues) {
                    tx3.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)existingValue);
                }
                tx3.createApplicabilityForView(viewId, applicability);
                tx3.commit();
                this.updateCompoundApplicabilities(branch, viewId, true);
            } else {
                results.error(String.valueOf(featureValue) + " is an invalid value");
            }
        }
        return results;
    }

    private XResultData updateCompoundApplicabilities(BranchId branch, ArtifactId viewId, boolean update) {
        XResultData results = new XResultData();
        ArrayList<String> actions = new ArrayList<String>();
        Collection allApps = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch).values();
        List compoundApps = allApps.stream().filter(p -> p.getName().contains("|") || p.getName().contains("&")).collect(Collectors.toList());
        ArtifactToken view = this.orcsApi.getQueryFactory().fromBranch(branch).andId(viewId).asArtifactTokenOrSentinel();
        for (ApplicabilityToken app : compoundApps) {
            TransactionBuilder tx;
            boolean validApplicability = false;
            if (app.getName().contains("|")) {
                String[] stringArray = app.getName().split("\\|");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl : existingApps) {
                        if (!appl.equals(value.trim())) continue;
                        validApplicability = true;
                    }
                    ++n2;
                }
            } else {
                int cnt = app.getName().split("&").length;
                int validCnt = 0;
                String[] stringArray = app.getName().split("&");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl : existingApps) {
                        if (!appl.equals(value.trim())) continue;
                        ++validCnt;
                    }
                    ++n3;
                }
                if (cnt == validCnt) {
                    validApplicability = true;
                }
            }
            if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, app.getName())) {
                if (validApplicability) continue;
                if (update) {
                    tx = this.txFactory.createTransaction(branch, "Remove invalid compound applicability");
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)app.getName());
                    tx.commit();
                }
                actions.add("Remove " + app.getName() + " from configuration: " + view.getName());
                continue;
            }
            if (!validApplicability) continue;
            if (update) {
                tx = this.txFactory.createTransaction(branch, "Apply valid compound applicability");
                tx.createApplicabilityForView(viewId, app.getName());
                tx.commit();
            }
            actions.add("Add " + app.getName() + " to configuration: " + view.getName());
        }
        if (!actions.isEmpty()) {
            results.setResults(actions);
        }
        return results;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch) {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch);
    }

    public XResultData createCfgGroup(ConfigurationGroupDefinition group, BranchId branch) {
        XResultData results = new XResultData();
        if (!Strings.isValid((String)group.getName())) {
            results.errorf("Name can not be empty for Configuration Group: %s", new Object[]{group.getName()});
            return results;
        }
        if (this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(group.getName()).exists()) {
            results.errorf("Configuration Group Name already exists", new Object[0]);
            return results;
        }
        try {
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Create PL Configuration Group");
            ArtifactToken vDefArt = null;
            vDefArt = tx.createArtifact((ArtifactId)this.getPlConfigurationGroupsFolder(tx.getBranch()), CoreArtifactTypes.GroupArtifact, group.getName());
            tx.setName((ArtifactId)vDefArt, group.getName());
            this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, (ArtifactId)vDefArt, tx, "ConfigurationGroup = " + vDefArt.getName());
            tx.commit();
            ArtifactId newGrp = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(group.getName()).asArtifactId();
            TransactionBuilder tx2 = this.txFactory.createTransaction(branch, "Create Config and Base applicabilities on new view");
            tx2.createApplicabilityForView(newGrp, "Base");
            tx2.createApplicabilityForView(newGrp, "ConfigurationGroup = " + group.getName());
            for (FeatureDefinition feature : this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch)) {
                tx2.createApplicabilityForView(newGrp, String.valueOf(feature.getName()) + " = " + feature.getDefaultValue());
            }
            tx2.commit();
            results.getIds().add(newGrp.getIdString());
            if (!group.getConfigurations().isEmpty()) {
                for (String cfg : group.getConfigurations()) {
                    this.relateCfgGroupToView(newGrp.getIdString(), cfg, branch);
                }
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData updateCfgGroup(ConfigurationGroupDefinition group, BranchId branch) {
        XResultData results = new XResultData();
        ConfigurationGroupDefinition currentGroup = this.getConfigurationGroup(group.getId(), branch);
        if (!currentGroup.getName().equals("")) {
            try {
                if (!group.getName().equals(currentGroup.getName())) {
                    TransactionBuilder tx = this.txFactory.createTransaction(branch, "Update PL Configuration Group Name");
                    tx.setName(ArtifactId.valueOf((String)group.getId()), group.getName());
                    tx.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((String)group.getId()), (Object)("ConfigurationGroup = " + currentGroup.getName()));
                    this.addIntroduceTuple2((Tuple2Type<ArtifactId, String>)CoreTupleTypes.ApplicabilityDefinition, ArtifactId.valueOf((String)group.getId()), tx, "ConfigurationGroup = " + group.getName());
                    tx.commit();
                }
                if (!group.getConfigurations().toString().equals(currentGroup.getConfigurations().toString())) {
                    for (String cfg : currentGroup.getConfigurations()) {
                        if (group.getConfigurations().contains(cfg)) continue;
                        results = this.unrelateCfgGroupToView(currentGroup.getId(), cfg, branch);
                    }
                    for (String cfg : group.getConfigurations()) {
                        if (currentGroup.getConfigurations().contains(cfg)) continue;
                        results = this.relateCfgGroupToView(currentGroup.getId(), cfg, branch);
                    }
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        } else {
            results.errorf("Configuration Group does not exist", new Object[0]);
        }
        return results;
    }

    public XResultData relateCfgGroupToView(String groupId, String viewId, BranchId branch) {
        XResultData results = new XResultData();
        ArtifactToken cfgGroup = Strings.isNumeric((String)groupId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)groupId)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(groupId).asArtifactTokenOrSentinel();
        ArtifactReadable view = Strings.isNumeric((String)viewId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)viewId)).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(viewId).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel();
        if (cfgGroup.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        if (view.isInvalid()) {
            results.errorf("View name does not exist", new Object[0]);
            return results;
        }
        List currentGroup = view.getRelated(CoreRelationTypes.PlConfigurationGroup_Group).getList();
        if (!currentGroup.isEmpty() && !currentGroup.stream().filter(o -> o.equals(cfgGroup)).collect(Collectors.toList()).isEmpty()) {
            results.errorf("View is already in the group", new Object[0]);
            return results;
        }
        try {
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Relate view: " + view.getName() + " to PL Configuration Group " + cfgGroup.getName());
            tx.relate((ArtifactId)cfgGroup, (RelationTypeToken)CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)view);
            tx.createApplicabilityForView((ArtifactId)view, "ConfigurationGroup = " + cfgGroup.getName());
            tx.createApplicabilityForView((ArtifactId)cfgGroup, "Config = " + view.getName());
            tx.commit();
            this.syncConfigGroup(branch, cfgGroup.getIdString(), results);
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData unrelateCfgGroupToView(String groupId, String viewId, BranchId branch) {
        XResultData results = new XResultData();
        ArtifactToken cfgGroup = Strings.isNumeric((String)groupId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)groupId)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(groupId).asArtifactTokenOrSentinel();
        ArtifactReadable view = Strings.isNumeric((String)viewId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)viewId)).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(viewId).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactOrSentinel();
        if (cfgGroup.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        if (view.isInvalid()) {
            results.errorf("View name does not exist", new Object[0]);
            return results;
        }
        try {
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Un-Relate view from PL Configuration Group ");
            tx.unrelate((ArtifactId)cfgGroup, (RelationTypeToken)CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)view);
            tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)("ConfigurationGroup = " + cfgGroup.getName()));
            tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)cfgGroup, (Object)("Config = " + view.getName()));
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData deleteCfgGroup(String id, BranchId branch) {
        XResultData results = new XResultData();
        ArtifactReadable cfgGroup = Strings.isNumeric((String)id) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)id)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(id).asArtifactOrSentinel();
        if (cfgGroup.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        try {
            for (ArtifactReadable view : cfgGroup.getRelated(CoreRelationTypes.PlConfigurationGroup_BranchView).getList()) {
                this.unrelateCfgGroupToView(cfgGroup.getIdString(), view.getIdString(), branch);
            }
            Iterable deleteApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)cfgGroup);
            TransactionBuilder txApps = this.txFactory.createTransaction(branch, "Delete Applicabilities associated with ConfigurationGroup");
            for (String app : deleteApps) {
                txApps.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)cfgGroup, (Object)app);
            }
            txApps.deleteTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)cfgGroup, (Object)("ConfigurationGroup = " + cfgGroup.getName()));
            txApps.commit();
            TransactionBuilder tx = this.txFactory.createTransaction(branch, "Delete Cfg Group");
            tx.deleteArtifact((ArtifactId)cfgGroup);
            tx.commit();
            results.getIds().add(id);
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData syncConfigGroup(BranchId branch, String id, XResultData results) {
        ArtifactReadable cfgGroup;
        if (results == null) {
            results = new XResultData();
        }
        if ((cfgGroup = Strings.isNumeric((String)id) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)id)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifact() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(id).asArtifact()).isValid()) {
            List views = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)cfgGroup).asArtifacts();
            ApplicabilityBranchConfig current = this.getConfig(branch, false);
            ConfigurationGroupDefinition currentGroup = current.getGroups().stream().filter(p -> p.getId().equals(id)).findFirst().get();
            if (!currentGroup.getConfigurations().isEmpty()) {
                for (ExtendedFeatureDefinition feature : current.getFeatures()) {
                    String resultApp = null;
                    ArrayList<String> memberApps = new ArrayList<String>();
                    ArrayList<String> groupApps = new ArrayList<String>();
                    String currentApp = "";
                    if (feature.isMultiValued()) {
                        for (NameValuePair pair : feature.getConfigurations()) {
                            boolean isInGroup;
                            if (pair.getName().equals(cfgGroup.getName())) {
                                for (String val : pair.getValues()) {
                                    groupApps.add(String.valueOf(feature.getName()) + " = " + val);
                                }
                            }
                            boolean bl = isInGroup = !views.stream().noneMatch(v -> v.getName().equals(pair.getName()));
                            if (!isInGroup) continue;
                            for (String val : pair.getValues()) {
                                String applicability = String.valueOf(feature.getName()) + " = " + val;
                                if (memberApps.contains(applicability)) continue;
                                memberApps.add(applicability);
                            }
                        }
                    } else {
                        if (feature.getValues().contains("Included")) {
                            resultApp = String.valueOf(feature.getName()) + " = Excluded";
                        }
                        for (NameValuePair pair : feature.getConfigurations()) {
                            boolean isInGroup = false;
                            if (pair.getName().equals(cfgGroup.getName())) {
                                currentApp = String.valueOf(feature.getName()) + " = " + pair.getValue();
                            } else {
                                isInGroup = !views.stream().noneMatch(v -> v.getName().equals(pair.getName()));
                            }
                            ((ArtifactReadable)views.get(0)).getName();
                            if (!isInGroup) continue;
                            String applicability = String.valueOf(feature.getName()) + " = " + pair.getValue();
                            if (feature.getValues().contains("Included")) {
                                if (!pair.getValue().equals("Included")) continue;
                                resultApp = applicability;
                                break;
                            }
                            if (resultApp == null) {
                                resultApp = applicability;
                                continue;
                            }
                            if (resultApp.equals(applicability)) continue;
                            results.error("Updating Group: " + cfgGroup.getName() + ". Applicabilities differ for non-binary feature: " + feature.getName());
                        }
                    }
                    if (!feature.isMultiValued()) {
                        if (currentApp.equals(resultApp) || !results.isSuccess()) continue;
                        TransactionBuilder tx = this.txFactory.createTransaction(branch, "Set applicability for view");
                        tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)cfgGroup, (Object)currentApp);
                        tx.createApplicabilityForView((ArtifactId)cfgGroup, resultApp);
                        tx.commit();
                        continue;
                    }
                    if (!results.isSuccess()) continue;
                    TransactionBuilder tx2 = this.txFactory.createTransaction(branch, "Set applicability for view");
                    ArrayList removeValues = new ArrayList(groupApps);
                    removeValues.removeAll(memberApps);
                    for (String val : removeValues) {
                        tx2.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)cfgGroup, (Object)val);
                    }
                    memberApps.removeAll(groupApps);
                    for (String val : memberApps) {
                        tx2.createApplicabilityForView((ArtifactId)cfgGroup, val);
                    }
                    tx2.commit();
                }
                this.updateCompoundApplicabilities(branch, (ArtifactId)cfgGroup, true);
            }
        } else {
            results.error("Invalid Configuration Group name.");
        }
        return results;
    }

    public XResultData syncConfigGroup(BranchId branch) {
        XResultData results = new XResultData();
        for (ArtifactToken group : this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch(branch)) {
            this.syncConfigGroup(branch, group.getIdString(), results);
        }
        return results;
    }

    public String evaluateApplicabilityExpression(BranchId branch, ArtifactToken view, ApplicabilityBlock applic) {
        return new BlockApplicabilityOps(this.orcsApi, this.logger, branch, view).evaluateApplicabilityExpression(applic);
    }

    public XResultData applyApplicabilityToFiles(BlockApplicabilityStageRequest data, BranchId branch) {
        String cachePath;
        XResultData results = new XResultData();
        results.setLogToSysErr(true);
        String sourcePath = data.getSourcePath();
        String stagePath = data.getStagePath();
        if (sourcePath == null || stagePath == null) {
            results.error("Both a source path and stage path are required\n");
            return results;
        }
        boolean commentNonApplicableBlocks = data.isCommentNonApplicableBlocks();
        Map.Entry viewInfo = data.getViews().entrySet().iterator().next();
        ArtifactId viewId = ArtifactId.valueOf((Long)((Long)viewInfo.getKey()));
        BlockApplicabilityOps ops = this.getBlockApplicabilityOps(results, data, viewId, cachePath = (String)viewInfo.getValue(), branch);
        if (ops == null || results.isErrors()) {
            return results;
        }
        stagePath = this.getFullStagePath(results, stagePath, ops.getOpsView().getName());
        if (results.isErrors()) {
            return results;
        }
        return ops.applyApplicabilityToFiles(results, commentNonApplicableBlocks, sourcePath, stagePath);
    }

    public XResultData refreshStagedFiles(BlockApplicabilityStageRequest data, BranchId branch) {
        String cachePath;
        XResultData results = new XResultData();
        results.setLogToSysErr(true);
        String sourcePath = data.getSourcePath();
        String stagePath = data.getStagePath();
        List files = data.getFiles();
        if (sourcePath == null || stagePath == null) {
            results.error("Both a source path and stage path are required");
            return results;
        }
        boolean commentNonApplicableBlocks = data.isCommentNonApplicableBlocks();
        Map.Entry viewInfo = data.getViews().entrySet().iterator().next();
        ArtifactId viewId = ArtifactId.valueOf((Long)((Long)viewInfo.getKey()));
        BlockApplicabilityOps ops = this.getBlockApplicabilityOps(results, data, viewId, cachePath = (String)viewInfo.getValue(), branch);
        if (ops == null) {
            return results;
        }
        stagePath = this.getFullStagePath(results, stagePath, ops.getOpsView().getName());
        if (results.isErrors()) {
            return results;
        }
        ops.setUpBlockApplicability(commentNonApplicableBlocks);
        return ops.refreshStagedFiles(results, sourcePath, stagePath, files);
    }

    public XResultData startWatcher(final BlockApplicabilityStageRequest data, BranchId branch) {
        XResultData results = new XResultData();
        results.setLogToSysErr(true);
        if (fileWatcher == null) {
            fileWatcher = new StagedFileWatcher(results);
        }
        String sourcePath = data.getSourcePath();
        String stagePath = data.getStagePath();
        if (sourcePath == null || stagePath == null) {
            results.error("Both a source path and stage path are required");
            return results;
        }
        boolean commentNonApplicableBlocks = data.isCommentNonApplicableBlocks();
        for (Map.Entry viewInfo : data.getViews().entrySet()) {
            String cachePath;
            ArtifactId viewId = ArtifactId.valueOf((Long)((Long)viewInfo.getKey()));
            BlockApplicabilityOps ops = this.getBlockApplicabilityOps(results, data, viewId, cachePath = (String)viewInfo.getValue(), branch);
            if (ops == null) {
                return results;
            }
            String fullStagePath = this.getFullStagePath(results, stagePath, ops.getOpsView().getName());
            if (results.isErrors()) {
                return results;
            }
            ops.setUpBlockApplicability(commentNonApplicableBlocks);
            fileWatcher.addView(ops.getOpsView(), fullStagePath, ops);
        }
        Thread watcherThread = new Thread(new Runnable(){

            @Override
            public void run() {
                fileWatcher.runWatcher(data, data.getSourcePath());
            }
        }, "Starting StagedFileWatcher");
        watcherThread.start();
        results.log("Watcher is running");
        return results;
    }

    public XResultData stopWatcher() {
        XResultData results = new XResultData();
        if (fileWatcher == null) {
            results.error("File Watcher has yet to be started");
            return results;
        }
        fileWatcher.stopWatcher();
        fileWatcher = null;
        results.log("Watcher has stopped");
        return results;
    }

    private BlockApplicabilityOps getBlockApplicabilityOps(XResultData results, BlockApplicabilityStageRequest data, ArtifactId viewId, String cachePath, BranchId branch) {
        BlockApplicabilityOps ops = null;
        if (cachePath.isEmpty()) {
            ArtifactToken viewToken = this.orcsApi.getQueryFactory().fromBranch(branch).andId(viewId).asArtifactToken();
            ops = new BlockApplicabilityOps(this.orcsApi, this.logger, branch, viewToken);
        } else {
            File cacheFile = new File(cachePath);
            if (cacheFile.exists()) {
                BlockApplicabilityCacheFile cache;
                ObjectMapper objMap = new ObjectMapper();
                try {
                    cache = (BlockApplicabilityCacheFile)objMap.readValue(cacheFile, BlockApplicabilityCacheFile.class);
                }
                catch (IOException iOException) {
                    results.error("There was a problem reading the cache file given");
                    return ops;
                }
                Long cachedViewId = cache.getViewId();
                if (!cachedViewId.equals(viewId.getId())) {
                    results.errorf("The entered view id (%s) does not match up with the cached view id (%s)\n", new Object[]{viewId.getId(), cachedViewId});
                    return ops;
                }
                ArtifactToken viewToken = ArtifactToken.valueOf((long)cachedViewId, (String)cache.getViewName(), (ArtifactTypeToken)this.orcsApi.tokenService().getArtifactType(cache.getViewTypeId()));
                ops = new BlockApplicabilityOps(this.orcsApi, this.logger, branch, viewToken, cache);
            } else {
                results.error("A cache path was given but no file was found\n");
                return ops;
            }
        }
        return ops;
    }

    private String getFullStagePath(XResultData results, String stagePath, String viewName) {
        File stageDir = new File(stagePath, "Staging");
        if (!stageDir.exists() && !stageDir.mkdir()) {
            results.errorf("Could not create stage directory %s\n", new Object[]{stageDir.toString()});
            return "";
        }
        File stageViewDir = new File(stageDir.getPath(), viewName.replaceAll(" ", "_"));
        if (!stageViewDir.exists() && !stageViewDir.mkdir()) {
            results.errorf("Could not create stage directory %s\n", new Object[]{stageViewDir.toString()});
            return "";
        }
        return stageViewDir.getPath();
    }

    public XResultData validateCompoundApplicabilities(BranchId branch, boolean update) {
        XResultData results = new XResultData();
        ArrayList actions = new ArrayList();
        for (ArtifactId bView : this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch)) {
            actions.addAll(this.updateCompoundApplicabilities(branch, bView, update).getResults());
        }
        results.setResults(actions);
        return results;
    }
}

