/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.mail.notifier;

import java.util.Collection;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.icteam.web.mail.notifier.ICTeamExportClassLoader;
import org.eclipse.osee.icteam.web.mail.notifier.JobSchedularService;
import org.eclipse.osee.icteam.web.mail.notifier.ServiceUtil;

public class ICTeamEmail
extends MimeMessage {
    protected static final String emailType = "mail.smtp.host";
    protected static final String HTMLHead = "<html><body>\n";
    protected static final String HTMLEnd = "</body></html>\n";
    public static final String plainText = "text/plain";
    public static final String HTMLText = "text/html";
    private String body;
    private String bodyType;
    private final Multipart mainMessage;

    public ICTeamEmail() throws OseeCoreException {
        super(ICTeamEmail.getSession());
        this.body = null;
        this.bodyType = null;
        this.mainMessage = new MimeMultipart();
    }

    public ICTeamEmail(Collection<String> toAddresses, String fromAddress, String replyToAddress, String subject, String body, BodyType bodyType) throws OseeCoreException {
        block4: {
            this();
            try {
                this.setRecipients(toAddresses.toArray(new String[toAddresses.size()]));
                this.setFrom(fromAddress);
                this.setSubject(subject);
                this.setReplyTo(replyToAddress);
                if (bodyType == BodyType.Text) {
                    this.setBody(body);
                    break block4;
                }
                if (bodyType == BodyType.Html) {
                    this.setHTMLBody(body);
                    break block4;
                }
                throw new IllegalArgumentException("Unhandled body type " + (Object)((Object)bodyType));
            }
            catch (MessagingException messagingException) {}
        }
    }

    public void addRecipients(String addresses) throws MessagingException {
        this.addRecipients(Message.RecipientType.TO, addresses);
    }

    public void addRecipients(String[] addresses) throws MessagingException {
        this.addRecipients(Message.RecipientType.TO, addresses);
    }

    public void addRecipients(Message.RecipientType type, String[] addresses) throws MessagingException {
        if (addresses != null) {
            InternetAddress[] newAddresses = new InternetAddress[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                newAddresses[i] = new InternetAddress(addresses[i]);
                ++i;
            }
            this.addRecipients(type, (Address[])newAddresses);
        }
    }

    public void setRecipients(String addresses) throws MessagingException {
        this.setRecipients(Message.RecipientType.TO, addresses);
    }

    public void setRecipients(String[] addresses) throws MessagingException {
        this.setRecipients(Message.RecipientType.TO, addresses);
    }

    public void setRecipients(Message.RecipientType type, String[] addresses) throws MessagingException {
        if (addresses != null) {
            InternetAddress[] newAddresses = new InternetAddress[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                newAddresses[i] = new InternetAddress(addresses[i]);
                ++i;
            }
            this.setRecipients(type, (Address[])newAddresses);
        }
    }

    public void setFrom(String address) throws AddressException, MessagingException {
        this.setFrom((Address)new InternetAddress(address));
    }

    public void setReplyTo(String address) throws MessagingException {
        InternetAddress[] replyAddresses = new InternetAddress[]{new InternetAddress(address)};
        this.setReplyTo((Address[])replyAddresses);
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBody(String text) {
        this.body = text;
        this.bodyType = plainText;
    }

    public void addBody(String text) {
        if (this.bodyType == null) {
            this.setBody(text);
        } else if (this.bodyType.equals(plainText)) {
            this.body = String.valueOf(this.body) + text;
        }
    }

    public void setHTMLBody(String htmlText) {
        this.bodyType = HTMLText;
        this.body = HTMLHead + htmlText;
    }

    public void addHTMLBody(String htmlText) {
        if (this.bodyType == null) {
            this.setHTMLBody(htmlText);
        } else if (this.bodyType.equals(HTMLText)) {
            this.body = String.valueOf(this.body) + htmlText;
        }
    }

    public void send() {
        new SendThread(this).start();
    }

    public void sendLocalThread() throws MessagingException, OseeCoreException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            CommandMap.setDefaultCommandMap((CommandMap)mc);
            Thread.currentThread().setContextClassLoader(new ICTeamExportClassLoader(ServiceUtil.getPackageAdmin()));
            if (this.bodyType == null) {
                this.bodyType = plainText;
                this.body = "";
            } else if (this.bodyType.equals(HTMLText)) {
                this.body = String.valueOf(this.body) + HTMLEnd;
            }
            messageBodyPart.setContent((Object)this.body, this.bodyType);
            this.mainMessage.addBodyPart((BodyPart)messageBodyPart, 0);
            this.setContent(this.mainMessage);
            Transport.send((Message)this);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private static Session getSession() throws OseeCoreException {
        Properties props = System.getProperties();
        String mailServer = JobSchedularService.getGlobalArtifact();
        if (mailServer != null) {
            props.put(emailType, mailServer);
        }
        return Session.getDefaultInstance((Properties)props, null);
    }

    public static enum BodyType {
        Html,
        Text;

    }

    private class SendThread
    extends Thread {
        private final ICTeamEmail email;

        public SendThread(ICTeamEmail email) {
            this.email = email;
        }

        @Override
        public void run() {
            try {
                this.email.sendLocalThread();
            }
            catch (MessagingException ex) {
                System.out.println((Object)ex);
            }
            catch (OseeCoreException oseeCoreException) {}
        }
    }
}

