/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;

public final class HiddenFormFields {
    private final Map<String, String> data = new HashMap<String, String>();

    public static HiddenFormFields newForm() {
        return new HiddenFormFields();
    }

    public HiddenFormFields add(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    private void write(StringBuilder writer, String name, String value) {
        if (Strings.isValid((String)value)) {
            writer.append(String.format("<input type=\"hidden\" name=\"%s\" value=\"%s\">\n", name, JaxRsUtils.asTemplateValue(value)));
        }
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"form-group\">\n");
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            this.write(builder, entry.getKey(), entry.getValue());
        }
        builder.append("</div>\n");
        return builder.toString();
    }
}

