/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;

public class PredicateHandlerUtil {
    public static Collection<AttributeTypeId> getAttributeTypes(Collection<String> types) {
        LinkedHashSet<AttributeTypeId> attrTypes = new LinkedHashSet<AttributeTypeId>();
        for (String value : types) {
            long uuid = PredicateHandlerUtil.parseUuid(value);
            if (uuid == -1L) continue;
            attrTypes.add(AttributeTypeId.valueOf((Long)uuid));
        }
        return attrTypes;
    }

    public static Collection<RelationTypeToken> getIRelationTypes(Collection<String> rels, OrcsTokenService tokenService) {
        LinkedHashSet<RelationTypeToken> types = new LinkedHashSet<RelationTypeToken>();
        for (String value : rels) {
            long longUuid = PredicateHandlerUtil.parseUuid(value);
            if (longUuid == -1L) continue;
            types.add(tokenService.getRelationType(Long.valueOf(longUuid)));
        }
        return types;
    }

    public static Collection<RelationTypeSide> getRelationTypeSides(Collection<String> rels, OrcsTokenService orcsTokenService) {
        LinkedHashSet<RelationTypeSide> relSides = new LinkedHashSet<RelationTypeSide>();
        for (String value : rels) {
            long relationTypeId;
            char sideChar = value.charAt(0);
            String uuid = value.substring(1);
            RelationSide side = RelationSide.SIDE_A;
            if (sideChar == 'B') {
                side = RelationSide.SIDE_B;
            }
            if ((relationTypeId = PredicateHandlerUtil.parseUuid(uuid)) == -1L) continue;
            relSides.add(RelationTypeSide.create((RelationTypeToken)orcsTokenService.getRelationType(Long.valueOf(relationTypeId)), (RelationSide)side));
        }
        return relSides;
    }

    public static long parseUuid(String uuid) {
        if (uuid.matches("-?\\d+")) {
            return Long.parseLong(uuid);
        }
        return -1L;
    }
}

